/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.config.StorageFilter;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEMonitorIInventory;
import appeng.me.storage.MEMonitorPassThrough;
import appeng.me.storage.MEPassThrough;
import appeng.util.item.ItemFilterList;
import appeng.util.prioitylist.DefaultPriorityList;
import appeng.util.prioitylist.IPartitionList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class MEInventoryHandler<T extends IAEStack<T>>
implements IMEInventoryHandler<T> {
    private final IMEInventoryHandler<T> internal;
    private int myPriority;
    private IncludeExclude myWhitelist;
    private AccessRestriction myAccess;
    private IPartitionList<T> myPartitionList;
    private IPartitionList<T> myExtractPartitionList;
    private AccessRestriction cachedAccessRestriction;
    protected boolean hasReadAccess;
    protected boolean hasWriteAccess;
    protected boolean isSticky;
    protected boolean isExtractFilterActive;

    public MEInventoryHandler(IMEInventory<T> i, StorageChannel channel) {
        this.internal = i instanceof IMEInventoryHandler ? (IMEInventoryHandler<Object>)i : new MEPassThrough<T>(i, channel);
        this.myPriority = 0;
        this.myWhitelist = IncludeExclude.WHITELIST;
        this.setBaseAccess(AccessRestriction.READ_WRITE);
        this.myPartitionList = new DefaultPriorityList();
        this.myExtractPartitionList = new DefaultPriorityList();
    }

    public IncludeExclude getWhitelist() {
        return this.myWhitelist;
    }

    public void setWhitelist(IncludeExclude myWhitelist) {
        this.myWhitelist = myWhitelist;
    }

    public AccessRestriction getBaseAccess() {
        return this.myAccess;
    }

    public void setBaseAccess(AccessRestriction myAccess) {
        this.myAccess = myAccess;
        this.cachedAccessRestriction = this.myAccess.restrictPermissions(this.internal.getAccess());
        this.hasReadAccess = this.cachedAccessRestriction.hasPermission(AccessRestriction.READ);
        this.hasWriteAccess = this.cachedAccessRestriction.hasPermission(AccessRestriction.WRITE);
    }

    public IPartitionList<T> getExtractPartitionList() {
        return this.myExtractPartitionList;
    }

    public void setExtractPartitionList(IPartitionList<T> myExtractPartitionList) {
        this.myExtractPartitionList = myExtractPartitionList;
    }

    public IPartitionList<T> getPartitionList() {
        return this.myPartitionList;
    }

    public void setPartitionList(IPartitionList<T> myPartitionList) {
        this.myPartitionList = myPartitionList;
    }

    @Override
    public T injectItems(T input, Actionable type, BaseActionSource src) {
        if (!this.canAccept(input)) {
            return input;
        }
        return this.internal.injectItems(input, type, src);
    }

    @Override
    public T extractItems(T request, Actionable type, BaseActionSource src) {
        Predicate<T> filterCondition;
        if (!this.hasReadAccess) {
            return null;
        }
        if (this.isExtractFilterActive() && !this.myExtractPartitionList.isEmpty() && !(filterCondition = this.getExtractFilterCondition()).test(request)) {
            return null;
        }
        return this.internal.extractItems(request, type, src);
    }

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out, int iteration) {
        if (!this.hasReadAccess && !this.isVisible()) {
            return out;
        }
        if (out instanceof ItemFilterList) {
            return this.getAvailableItemsFilter(out, iteration);
        }
        if (this.isExtractFilterActive() && !this.myExtractPartitionList.isEmpty()) {
            return this.filterAvailableItems(out, iteration);
        }
        return this.internal.getAvailableItems(out, iteration);
    }

    public boolean isVisible() {
        IMEMonitor<IAEItemStack> inv;
        IMEInventoryHandler<T> iMEInventoryHandler = this.internal;
        boolean bool = iMEInventoryHandler instanceof MEMonitorIInventory && ((MEMonitorIInventory)(inv = (MEMonitorIInventory)iMEInventoryHandler)).getMode() == StorageFilter.NONE;
        iMEInventoryHandler = this.internal;
        if (iMEInventoryHandler instanceof MEMonitorPassThrough && ((MEMonitorPassThrough)(inv = (MEMonitorPassThrough)iMEInventoryHandler)).getMode() == StorageFilter.NONE) {
            bool = true;
        }
        return bool;
    }

    protected IItemList<T> filterAvailableItems(IItemList<T> out, int iteration) {
        IItemList allAvailableItems = this.internal.getAvailableItems(this.internal.getChannel().createList(), iteration);
        Predicate<IAEStack> filterCondition = this.getExtractFilterCondition();
        for (IAEStack item : allAvailableItems) {
            if (!filterCondition.test(item)) continue;
            out.add(item);
        }
        return out;
    }

    protected IItemList<T> getAvailableItemsFilter(IItemList<T> out, int iteration) {
        if (!this.getPartitionList().isEmpty() && this.getWhitelist() == IncludeExclude.WHITELIST) {
            for (IAEStack is : this.myPartitionList.getItems()) {
                out.add(is);
            }
            return out;
        }
        return this.getInternal().getAvailableItems(out, iteration);
    }

    @Override
    public T getAvailableItem(@Nonnull T request, int iteration) {
        Predicate<T> filterCondition;
        if (!this.hasReadAccess && !this.isVisible()) {
            return null;
        }
        if (this.isExtractFilterActive() && !this.myExtractPartitionList.isEmpty() && !(filterCondition = this.getExtractFilterCondition()).test(request)) {
            return null;
        }
        return this.internal.getAvailableItem(request, iteration);
    }

    public Predicate<T> getExtractFilterCondition() {
        return this.myWhitelist == IncludeExclude.WHITELIST ? i -> this.myExtractPartitionList.isListed((IAEStack)i) : i -> !this.myExtractPartitionList.isListed((IAEStack)i);
    }

    public boolean isExtractFilterActive() {
        return this.isExtractFilterActive;
    }

    public void setIsExtractFilterActive(boolean isExtractFilterActive) {
        this.isExtractFilterActive = isExtractFilterActive;
    }

    @Override
    public StorageChannel getChannel() {
        return this.internal.getChannel();
    }

    @Override
    public AccessRestriction getAccess() {
        return this.cachedAccessRestriction;
    }

    @Override
    public boolean isPrioritized(T input) {
        if (this.myWhitelist == IncludeExclude.WHITELIST) {
            return this.myPartitionList.isListed(input) || this.internal.isPrioritized(input);
        }
        return false;
    }

    @Override
    public boolean canAccept(T input) {
        if (!this.hasWriteAccess) {
            return false;
        }
        if (this.myWhitelist == IncludeExclude.BLACKLIST && this.myPartitionList.isListed(input)) {
            return false;
        }
        if (this.myPartitionList.isEmpty() || this.myWhitelist == IncludeExclude.BLACKLIST) {
            return this.internal.canAccept(input);
        }
        return this.myPartitionList.isListed(input) && this.internal.canAccept(input);
    }

    @Override
    public int getPriority() {
        return this.myPriority;
    }

    public void setPriority(int myPriority) {
        this.myPriority = myPriority;
    }

    @Override
    public int getSlot() {
        return this.internal.getSlot();
    }

    @Override
    public boolean validForPass(int i) {
        return true;
    }

    @Override
    public boolean getSticky() {
        return this.isSticky || this.internal.getSticky();
    }

    public IMEInventory<T> getInternal() {
        return this.internal;
    }

    public void setSticky(boolean value) {
        this.isSticky = value;
    }
}

