/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.highlighter;

import appeng.client.render.highlighter.BlockPosHighlighter;
import appeng.client.render.highlighter.IHighlighter;
import appeng.client.render.highlighter.StoragePosHighlighter;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class HighlighterManager {
    public static final Set<IHighlighter> HIGHLIGHTERS = new HashSet<IHighlighter>();
    static long time = System.currentTimeMillis();

    static void registerHighlighter(IHighlighter h) {
        HIGHLIGHTERS.add(h);
    }

    @SubscribeEvent
    public void renderHighlightedBlocks(RenderWorldLastEvent event) {
        time = System.currentTimeMillis();
        if ((time / 500L & 1L) == 0L) {
            return;
        }
        for (IHighlighter h : HIGHLIGHTERS) {
            if (h.noWork()) continue;
            if (HighlighterManager.hasExpireHighlightTime(h)) {
                h.clear();
                continue;
            }
            h.renderHighlightedBlocks(event);
        }
    }

    private static boolean hasExpireHighlightTime(IHighlighter h) {
        return time > h.getExpireTime();
    }

    static {
        HighlighterManager.registerHighlighter(StoragePosHighlighter.INSTANCE);
        HighlighterManager.registerHighlighter(BlockPosHighlighter.INSTANCE);
    }
}

