/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.implementations.GuiAmount;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.container.implementations.ContainerPatternMulti;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketPatternMultiSet;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartPatternTerminalEx;
import appeng.util.calculators.ArithHelper;
import appeng.util.calculators.Calculator;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GuiPatternMulti
extends GuiAmount {
    private static final int DEFAULT_VALUE = 0;
    private GuiImgButton symbolSwitch;

    public GuiPatternMulti(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerPatternMulti(inventoryPlayer, te));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.symbolSwitch = new GuiImgButton(this.field_147003_i + 22, this.field_147009_r + 53, Settings.ACTIONS, ActionItems.MULTIPLY);
        this.field_146292_n.add(this.symbolSwitch);
        this.amountTextField.x = this.field_147003_i + 48;
        this.amountTextField.w = 73;
        this.amountTextField.setText(String.valueOf(0));
        this.amountTextField.setCursorPositionEnd();
        this.amountTextField.setSelectionPos(0);
    }

    @Override
    protected void setOriginGUI(Object target) {
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof PartPatternTerminal) {
            Iterator iterator = parts.patternTerminal().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                ItemStack stack;
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        } else if (target instanceof PartPatternTerminalEx) {
            Iterator iterator = parts.patternTerminalEx().maybeStack(1).asSet().iterator();
            while (iterator.hasNext()) {
                ItemStack stack;
                this.myIcon = stack = (ItemStack)iterator.next();
            }
            this.originalGui = GuiBridge.GUI_PATTERN_TERMINAL_EX;
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.SelectAmount.getLocal(), 8, 6, GuiColors.CraftAmountSelectAmount.getColor());
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.nextBtn.field_146126_j = GuiText.Set.getLocal();
        try {
            int resultI = this.getAmount();
            this.symbolSwitch.set(resultI >= 0 ? ActionItems.MULTIPLY : ActionItems.DIVIDE);
            this.nextBtn.field_146124_l = resultI < -1 || resultI > 1;
        }
        catch (NumberFormatException e) {
            this.nextBtn.field_146124_l = false;
        }
        this.amountTextField.drawTextBox();
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        int resultI;
        super.func_146284_a(btn);
        try {
            if (btn == this.nextBtn && btn.field_146124_l && ((resultI = this.getAmount()) > 1 || resultI < -1)) {
                NetworkHandler.instance.sendToServer(new PacketPatternMultiSet(this.originalGui.ordinal(), resultI));
            }
        }
        catch (NumberFormatException e) {
            this.amountTextField.setText(String.valueOf(0));
        }
        if (btn == this.symbolSwitch) {
            resultI = -this.getAmount();
            this.amountTextField.setText(Integer.toString(resultI));
        }
    }

    @Override
    protected int getAmount() {
        String out = this.amountTextField.getText();
        double resultD = Calculator.conversion(out);
        if (Double.isNaN(resultD)) {
            return 0;
        }
        return (int)ArithHelper.round(resultD, 0);
    }

    @Override
    protected long addOrderAmount(int i) {
        return i + this.getAmount();
    }

    @Override
    protected String getBackground() {
        return "guis/patternMulti.png";
    }
}

