/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.statements.IActionExternal;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlockInventory;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FakeTank;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.sounds.SoundHelper;
import mods.railcraft.common.util.steam.ISteamUser;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSteamOven
extends TileMultiBlockInventory
implements IFluidHandler,
ISidedInventory,
ISteamUser,
IHasWork {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 9;
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    private static final int STEAM_PER_BATCH = 8000;
    private static final int TOTAL_COOK_TIME = 256;
    private static final int COOK_STEP = 16;
    private static final int ITEMS_SMELTED = 9;
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    private static final int TANK_CAPACITY = 8000;
    private static final List<MultiBlockPattern> patterns = new ArrayList<MultiBlockPattern>();
    private final TankManager tankManager = new TankManager();
    private final StandardTank tank;
    private final IInventory invInput = new InventoryMapper(this, 0, 9);
    private final IInventory invOutput = new InventoryMapper(this, 9, 9, false);
    private final Set<IActionExternal> actions = new HashSet<IActionExternal>();
    public int cookTime;
    public boolean finishedCycle = false;
    private ForgeDirection facing = ForgeDirection.NORTH;
    private boolean paused = false;

    public TileSteamOven() {
        super("railcraft.gui.steam.oven", 18, patterns);
        this.tank = new FilteredTank(8000, Fluids.STEAM.get(), this);
        this.tankManager.add(this.tank);
    }

    public static void placeSteamOven(World world, int x, int y, int z, List<ItemStack> input, List<ItemStack> output) {
        Iterator<MultiBlockPattern> iterator = patterns.iterator();
        if (iterator.hasNext()) {
            MultiBlockPattern pattern = iterator.next();
            HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
            blockMapping.put(Character.valueOf('B'), EnumMachineAlpha.STEAM_OVEN.ordinal());
            TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineAlpha(), blockMapping);
            if (tile instanceof TileSteamOven) {
                TileSteamOven master = (TileSteamOven)tile;
                for (int slot = 0; slot < 9; ++slot) {
                    if (input != null && slot < input.size()) {
                        master.inv.func_70299_a(0 + slot, input.get(slot));
                    }
                    if (output == null || slot >= output.size()) continue;
                    master.inv.func_70299_a(9 + slot, output.get(slot));
                }
            }
            return;
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.STEAM_OVEN;
    }

    public TankManager getTankManager() {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public IIcon getIcon(int side) {
        if (this.isStructureValid() && side == this.getFacing().ordinal()) {
            switch (side) {
                case 2: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionX() == 2) {
                            return Texture.DOOR_TL.getIcon();
                        }
                        return Texture.DOOR_TR.getIcon();
                    }
                    if (this.getPatternPositionX() == 2) {
                        return Texture.DOOR_BL.getIcon();
                    }
                    return Texture.DOOR_BR.getIcon();
                }
                case 3: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionX() == 1) {
                            return Texture.DOOR_TL.getIcon();
                        }
                        return Texture.DOOR_TR.getIcon();
                    }
                    if (this.getPatternPositionX() == 1) {
                        return Texture.DOOR_BL.getIcon();
                    }
                    return Texture.DOOR_BR.getIcon();
                }
                case 4: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionZ() == 1) {
                            return Texture.DOOR_TL.getIcon();
                        }
                        return Texture.DOOR_TR.getIcon();
                    }
                    if (this.getPatternPositionZ() == 1) {
                        return Texture.DOOR_BL.getIcon();
                    }
                    return Texture.DOOR_BR.getIcon();
                }
                case 5: {
                    if (this.getPatternPositionY() == 2) {
                        if (this.getPatternPositionZ() == 2) {
                            return Texture.DOOR_TL.getIcon();
                        }
                        return Texture.DOOR_TR.getIcon();
                    }
                    if (this.getPatternPositionZ() == 2) {
                        return Texture.DOOR_BL.getIcon();
                    }
                    return Texture.DOOR_BR.getIcon();
                }
            }
        }
        if (side > 1) {
            return Texture.SIDE.getIcon();
        }
        return Texture.CAP.getIcon();
    }

    public int getCookProgressScaled(int i) {
        int scale = this.getCookTime() * i / 256;
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    public int getCookTime() {
        TileSteamOven masterOven = (TileSteamOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.cookTime;
        }
        return -1;
    }

    public ForgeDirection getFacing() {
        TileSteamOven masterOven = (TileSteamOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.facing;
        }
        return this.facing;
    }

    public boolean hasFinishedCycle() {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        return mBlock != null && mBlock.finishedCycle;
    }

    public void setHasFinishedCycle(boolean finished) {
        if (this.finishedCycle != finished) {
            this.finishedCycle = finished;
            this.sendUpdateToClient();
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (Game.isNotHost(this.getWorld())) {
            if (this.hasFinishedCycle()) {
                EffectManager.instance.steamEffect(this.field_145850_b, this, 0.25);
            }
            return;
        }
        if (this.isMaster()) {
            if (this.clock % 16 == 0) {
                this.processActions();
            }
            if (this.clock % 16 == 0) {
                this.setHasFinishedCycle(false);
                if (!this.paused) {
                    if (this.hasRecipe()) {
                        if (this.cookTime <= 0 && this.drainSteam()) {
                            this.cookTime = 1;
                        } else if (this.cookTime > 0) {
                            this.cookTime += 16;
                            if (this.cookTime >= 256 && this.smeltItems()) {
                                this.cookTime = 0;
                                this.setHasFinishedCycle(true);
                                SoundHelper.playSound(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, "railcraft:machine.steamburst", 1.0f, (float)(1.0 + MiscTools.getRand().nextGaussian() * 0.1));
                            }
                        }
                    } else {
                        this.cookTime = 0;
                    }
                }
            }
        }
    }

    private boolean drainSteam() {
        FluidStack steam = this.tank.drain(8000, false);
        if (steam != null && steam.amount >= 8000) {
            this.tank.drain(8000, true);
            return true;
        }
        return false;
    }

    private boolean hasRecipe() {
        for (int slot = 0; slot < 9; ++slot) {
            ItemStack stack = this.invInput.func_70301_a(slot);
            if (stack == null || FurnaceRecipes.func_77602_a().func_151395_a(stack) == null) continue;
            return true;
        }
        return false;
    }

    private boolean smeltItems() {
        int count = 0;
        boolean changed = true;
        boolean smelted = false;
        while (count < 9 && changed) {
            changed = false;
            for (int slot = 0; slot < 9 && count < 9; ++slot) {
                ItemStack remainder;
                ItemStack output;
                ItemStack stack = this.invInput.func_70301_a(slot);
                if (stack == null || (output = FurnaceRecipes.func_77602_a().func_151395_a(stack)) == null || !InvTools.isRoomForStack(output, this.invOutput) || (remainder = InvTools.moveItemStack(output.func_77946_l(), this.invOutput)) != null) continue;
                this.invInput.func_70298_a(slot, 1);
                changed = true;
                ++count;
            }
            smelted |= changed;
        }
        return smelted;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityliving);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        TileSteamOven master = (TileSteamOven)this.getMasterBlock();
        if (master != null) {
            master.facing = master.facing == axis ? axis.getOpposite() : axis;
            master.scheduleMasterRetest();
            return true;
        }
        return false;
    }

    @Override
    public ForgeDirection[] getValidRotations() {
        return UP_DOWN_AXES;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock != null) {
            GuiHandler.openGui(EnumGui.STEAN_OVEN, player, this.field_145850_b, masterBlock.field_145851_c, masterBlock.field_145848_d, masterBlock.field_145849_e);
            return true;
        }
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tankManager.writeTanksToNBT(data);
        data.func_74768_a("cookTime", this.cookTime);
        data.func_74774_a("facing", (byte)this.facing.ordinal());
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readTanksFromNBT(data);
        this.cookTime = data.func_74762_e("cookTime");
        this.facing = ForgeDirection.getOrientation((int)data.func_74771_c("facing"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.facing.ordinal());
        data.writeBoolean(this.finishedCycle);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte f = data.readByte();
        this.finishedCycle = data.readBoolean();
        if (f != this.facing.ordinal()) {
            this.facing = ForgeDirection.getOrientation((int)f);
            this.markBlockForUpdate();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        TankManager tMan = this.getTankManager();
        if (tMan == null) {
            return 0;
        }
        return tMan.fill(0, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == null || Fluids.STEAM.is(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection dir) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTankInfo();
        }
        return FakeTank.INFO;
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return slot >= 9;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!super.func_94041_b(slot, stack)) {
            return false;
        }
        if (stack == null) {
            return false;
        }
        if (slot >= 9) {
            return false;
        }
        return FurnaceRecipes.func_77602_a().func_151395_a(stack) != null;
    }

    @Override
    public boolean hasWork() {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.cookTime > 0;
        }
        return false;
    }

    private void processActions() {
        this.paused = false;
        for (IActionExternal action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IActionExternal action) {
        TileSteamOven mBlock = (TileSteamOven)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.actions.add(action);
        }
    }

    static {
        char[][][] map = new char[][][]{new char[][]{{'*', 'O', 'O', '*'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'*', 'O', 'O', '*'}}, new char[][]{{'*', 'O', 'O', '*'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'*', 'O', 'O', '*'}}, new char[][]{{'*', 'O', 'O', '*'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'*', 'O', 'O', '*'}}, new char[][]{{'*', 'O', 'O', '*'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'*', 'O', 'O', '*'}}};
        patterns.add(new MultiBlockPattern(map));
    }

    static enum Texture {
        DOOR_TL(6),
        DOOR_TR(7),
        DOOR_BL(8),
        DOOR_BR(9),
        SIDE(2),
        CAP(0);

        private final int index;

        private Texture(int index) {
            this.index = index;
        }

        public IIcon getIcon() {
            return EnumMachineAlpha.STEAM_OVEN.getTexture(this.index);
        }
    }
}

