/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util.log;

import com.github.weisj.darklaf.util.StringUtil;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_BLACK = "\u001b[30m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    public static final String ANSI_PURPLE = "\u001b[35m";
    public static final String ANSI_CYAN = "\u001b[36m";
    public static final String ANSI_WHITE = "\u001b[37m";
    public static final String ANSI_BOLD_ON = "\u001b[01m";
    public static final String ANSI_BOLD_OFF = "\u001b[2m";
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.UK).withZone(ZoneId.systemDefault());

    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder();
        builder.append(ANSI_BLUE);
        String time = this.calculateDateString(record.getMillis());
        builder.append("[");
        builder.append(time);
        builder.append("]");
        builder.append(ANSI_YELLOW);
        builder.append(" [");
        builder.append(record.getLevel().getName());
        builder.append("]");
        builder.append(ANSI_RESET);
        builder.append(this.getMessageColor(record));
        builder.append(" ");
        builder.append(record.getMessage());
        builder.append(ANSI_RESET);
        builder.append(ANSI_BOLD_ON);
        builder.append(" [at ");
        builder.append(record.getSourceClassName());
        builder.append("]");
        builder.append(ANSI_BOLD_OFF);
        Object[] params = record.getParameters();
        int spaceLength = time.length() + 3 + record.getLevel().getName().length() + 3;
        String space = StringUtil.repeat(" ", spaceLength);
        if (params != null) {
            builder.append("\n");
            builder.append(StringUtil.repeat(" ", spaceLength - 10));
            builder.append(ANSI_YELLOW);
            builder.append("[Details] ");
            builder.append(this.getMessageColor(record));
            for (int i = 0; i < params.length; ++i) {
                builder.append(params[i]);
                if (i >= params.length - 1) continue;
                builder.append(",\n");
                builder.append(space);
            }
        }
        builder.append(ANSI_RESET);
        builder.append("\n");
        if (record.getThrown() != null) {
            builder.append(this.getMessageColor(record));
            this.appendExceptionMessage(builder, record.getThrown());
        }
        return builder.toString();
    }

    private void appendExceptionMessage(StringBuilder builder, Throwable throwable) {
        StackTraceElement[] trace;
        builder.append(throwable.getClass().getCanonicalName()).append(": ");
        builder.append(throwable.getMessage());
        builder.append('\n');
        for (StackTraceElement element : trace = throwable.getStackTrace()) {
            builder.append("\tat ").append(element).append('\n');
        }
        Set<Throwable> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        for (Throwable se : throwable.getSuppressed()) {
            this.printEnclosedStackTrace(builder, se, trace, "Suppressed: ", "\t", dejaVu);
        }
        Throwable cause = throwable.getCause();
        if (cause != null) {
            this.printEnclosedStackTrace(builder, cause, trace, "Caused by: ", "", dejaVu);
        }
    }

    private void printEnclosedStackTrace(StringBuilder builder, Throwable throwable, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu) {
        if (dejaVu.contains(throwable)) {
            builder.append(prefix).append(caption).append("[CIRCULAR REFERENCE: ").append(this).append("]\n");
        } else {
            dejaVu.add(throwable);
            StackTraceElement[] trace = throwable.getStackTrace();
            int m = trace.length - 1;
            for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
            }
            int framesInCommon = trace.length - 1 - m;
            builder.append(prefix).append(caption).append(throwable).append('\n');
            for (int i = 0; i <= m; ++i) {
                builder.append(prefix).append("\tat ").append(trace[i]);
            }
            if (framesInCommon != 0) {
                builder.append(prefix).append("\t... ").append(framesInCommon).append(" more\n");
            }
            for (Throwable se : throwable.getSuppressed()) {
                this.printEnclosedStackTrace(builder, se, trace, "Suppressed: ", prefix + "\t", dejaVu);
            }
            Throwable cause = throwable.getCause();
            if (cause != null) {
                this.printEnclosedStackTrace(builder, cause, trace, "Caused by: ", prefix, dejaVu);
            }
        }
    }

    private String calculateDateString(long milliseconds) {
        return this.dateTimeFormatter.format(Instant.ofEpochMilli(milliseconds));
    }

    private String getMessageColor(LogRecord record) {
        if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
            return ANSI_RED;
        }
        if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
            return ANSI_YELLOW;
        }
        return ANSI_BLACK;
    }
}

