/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows;

import com.github.weisj.darklaf.platform.CustomTitlePane;
import com.github.weisj.darklaf.platform.DecorationsProvider;
import com.github.weisj.darklaf.platform.SystemInfo;
import com.github.weisj.darklaf.platform.TitlePaneLayoutInfo;
import com.github.weisj.darklaf.platform.UnsupportedProviderException;
import com.github.weisj.darklaf.platform.windows.JNIDecorationsWindows;
import com.github.weisj.darklaf.platform.windows.PointerUtil;
import com.github.weisj.darklaf.platform.windows.WindowsLibrary;
import com.github.weisj.darklaf.platform.windows.ui.WindowsTitlePane;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;

public class WindowsDecorationsProvider
implements DecorationsProvider {
    public WindowsDecorationsProvider() throws UnsupportedProviderException {
        if (!SystemInfo.isWindows10OrGreater) {
            throw new UnsupportedProviderException("Only supported on Windows 10 or later");
        }
        if (!WindowsLibrary.get().canLoad()) {
            throw new UnsupportedProviderException("Native components aren't supported");
        }
    }

    @Override
    public CustomTitlePane createTitlePane(JRootPane rootPane, int decorationStyle, Window window) {
        return new WindowsTitlePane(rootPane, decorationStyle, window);
    }

    @Override
    public boolean isCustomDecorationSupported() {
        return WindowsLibrary.get().isLoaded();
    }

    @Override
    public void initialize() {
        WindowsLibrary.get().updateLibrary();
    }

    @Override
    public void installPopupWindow(Window window) {
        PointerUtil.WindowPointer hwnd;
        if (!window.isDisplayable()) {
            window.addNotify();
        }
        if ((hwnd = PointerUtil.getHWND(window)).isValid()) {
            JNIDecorationsWindows.installPopupMenuDecorations(hwnd.value());
            if (window instanceof RootPaneContainer) {
                Color bg;
                JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
                Color color = bg = rootPane != null ? rootPane.getBackground() : null;
                if (bg != null) {
                    JNIDecorationsWindows.setBackground(hwnd.value(), bg.getRed(), bg.getGreen(), bg.getBlue());
                }
            }
        }
    }

    @Override
    public void uninstallPopupWindow(Window window) {
        if (window.isDisplayable()) {
            PointerUtil.WindowPointer hwnd = PointerUtil.getHWND(window);
            if (hwnd.isValid()) {
                JNIDecorationsWindows.uninstallDecorations(hwnd.value(), false);
            }
            window.dispose();
        }
    }

    @Override
    public void adjustContentArea(JRootPane root, Rectangle rect) {
        Border border = root.getBorder();
        if (border != null) {
            Insets ins = border.getBorderInsets(root);
            rect.x -= ins.left;
            rect.y -= ins.top;
        }
    }

    @Override
    public TitlePaneLayoutInfo titlePaneLayoutInfo(CustomTitlePane customTitlePane) {
        if (!(customTitlePane instanceof WindowsTitlePane)) {
            throw new IllegalStateException();
        }
        WindowsTitlePane titlePane = (WindowsTitlePane)customTitlePane;
        return new TitlePaneLayoutInfo(titlePane.windowButtonRect());
    }

    @Override
    public List<String> getPropertyResourcePaths() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("windows_icons");
        properties.add("windows_decorations");
        if (SystemInfo.isWindows11()) {
            properties.add("windows_11_decorations");
        }
        return properties;
    }
}

