/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.treetable;

import com.github.weisj.darklaf.components.treetable.JTreeTable;
import com.github.weisj.darklaf.components.treetable.TreeTableTree;
import com.github.weisj.darklaf.ui.tree.DarkTreeUI;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeTableCellRenderer
extends JComponent
implements TableCellRenderer {
    private final JTreeTable treeTable;
    private final RendererTree rendererTree = new RendererTree();
    private int paintingRow;

    public DefaultTreeTableCellRenderer(JTreeTable treeTable, TreeModel model) {
        this.treeTable = treeTable;
        this.rendererTree.setRowHeight(this.rendererTree.getRowHeight());
        this.rendererTree.setModel(model);
        this.rendererTree.setBounds(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    protected void paintComponent(Graphics g) {
        DarkTreeUI ui = DarkUIUtil.getUIOfType(this.rendererTree.getUI(), DarkTreeUI.class);
        if (ui != null) {
            ui.paintRow(g, this.paintingRow);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.paintingRow = row;
        this.rendererTree.setFocus(hasFocus || table.hasFocus());
        this.rendererTree.setSelectable(!hasFocus);
        return this;
    }

    public TreeTableTree getTree() {
        return this.rendererTree;
    }

    protected class RendererTree
    extends TreeTableTree {
        private boolean focus;
        private boolean selectable;

        protected RendererTree() {
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (DefaultTreeTableCellRenderer.this.treeTable != null && DefaultTreeTableCellRenderer.this.treeTable.getRowHeight() != rowHeight) {
                    DefaultTreeTableCellRenderer.this.treeTable.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void repaint(int x, int y, int width, int height) {
            DefaultTreeTableCellRenderer.this.treeTable.repaint(x, y, DefaultTreeTableCellRenderer.this.treeTable.getColumnModel().getColumn(0).getWidth(), height);
        }

        @Override
        public boolean isRowSelected(int row) {
            return this.selectable && super.isRowSelected(row);
        }

        @Override
        public boolean isPathSelected(TreePath path) {
            return this.selectable && super.isPathSelected(path);
        }

        @Override
        public void scrollRectToVisible(Rectangle aRect) {
            DefaultTreeTableCellRenderer.this.treeTable.scrollRectToVisible(aRect);
        }

        public void setFocus(boolean focus) {
            this.focus = focus;
        }

        public void setSelectable(boolean selectable) {
            this.selectable = selectable;
        }

        @Override
        public boolean hasFocus() {
            return this.focus;
        }

        @Override
        public boolean isFocusOwner() {
            return super.hasFocus();
        }
    }
}

