/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.armor.ArmorProxyCommon;
import tconstruct.armor.ArmorTickHandler;
import tconstruct.armor.TinkerArmor;
import tconstruct.armor.gui.ArmorExtendedGui;
import tconstruct.armor.gui.KnapsackGui;
import tconstruct.armor.items.TravelGear;
import tconstruct.armor.model.BeltModel;
import tconstruct.armor.model.BootBump;
import tconstruct.armor.model.HiddenPlayerModel;
import tconstruct.armor.model.WingModel;
import tconstruct.armor.player.ArmorExtended;
import tconstruct.armor.player.KnapsackInventory;
import tconstruct.armor.player.TPlayerStats;
import tconstruct.client.ArmorControls;
import tconstruct.client.HealthBarRenderer;
import tconstruct.client.tabs.InventoryTabArmorExtended;
import tconstruct.client.tabs.InventoryTabKnapsack;
import tconstruct.client.tabs.InventoryTabVanilla;
import tconstruct.client.tabs.TabRegistry;
import tconstruct.common.TProxyCommon;
import tconstruct.library.accessory.IAccessoryModel;
import tconstruct.library.client.TConstructClientRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.world.TinkerWorld;

public class ArmorProxyClient
extends ArmorProxyCommon {
    Minecraft mc = Minecraft.func_71410_x();
    public static WingModel wings = new WingModel();
    public static BootBump bootbump = new BootBump();
    public static HiddenPlayerModel glove = new HiddenPlayerModel(0.25f, 4);
    public static HiddenPlayerModel vest = new HiddenPlayerModel(0.25f, 1);
    public static BeltModel belt = new BeltModel();
    public static TPlayerStats playerStats = new TPlayerStats();
    public static KnapsackInventory knapsack = new KnapsackInventory();
    public static ArmorExtended armorExtended = new ArmorExtended();
    public static ArmorControls controlInstance;
    private static int translucentID;

    @Override
    public void preInit() {
        controlInstance = new ArmorControls();
        MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
    }

    @Override
    public void initialize() {
        this.registerGuiHandler();
        this.registerKeys();
        this.registerManualIcons();
        this.registerManualRecipes();
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (PHConstruct.coloredHeartRender) {
            HealthBarRenderer healthBarRenderer = new HealthBarRenderer();
            MinecraftForge.EVENT_BUS.register((Object)healthBarRenderer);
            FMLCommonHandler.instance().bus().register((Object)healthBarRenderer);
        }
    }

    private void registerManualIcons() {
        MantleClientRegistry.registerManualIcon((String)"travelgoggles", (ItemStack)TinkerArmor.travelGoggles.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelvest", (ItemStack)TinkerArmor.travelVest.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelwings", (ItemStack)TinkerArmor.travelWings.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelboots", (ItemStack)TinkerArmor.travelBoots.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelbelt", (ItemStack)TinkerArmor.travelBelt.getDefaultItem());
        MantleClientRegistry.registerManualIcon((String)"travelglove", (ItemStack)TinkerArmor.travelGlove.getDefaultItem());
    }

    private void registerManualRecipes() {
        ItemStack feather = new ItemStack(Items.field_151008_G);
        ItemStack redstone = new ItemStack(Items.field_151137_ax);
        ItemStack goggles = TinkerArmor.travelGoggles.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("nightvision", goggles.func_77946_l(), new ItemStack(Items.field_151033_d), new ItemStack((Item)Items.field_151068_bn, 1, 8198), new ItemStack(Items.field_151150_bK), null);
        ItemStack vest = TinkerArmor.travelVest.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("dodge", vest.func_77946_l(), new ItemStack(Items.field_151061_bv), new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151102_aT), null);
        TConstructClientRegistry.registerManualModifier("stealth", vest.func_77946_l(), new ItemStack(Items.field_151071_bq), new ItemStack(Items.field_151061_bv), new ItemStack((Item)Items.field_151068_bn, 1, 8206), new ItemStack(Items.field_151150_bK));
        ItemStack wings = TinkerArmor.travelWings.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("doublejumpwings", wings.func_77946_l(), new ItemStack(Items.field_151073_bk), new ItemStack(TinkerWorld.slimeGel, 1, 0), new ItemStack((Block)Blocks.field_150331_J), null);
        ItemStack[] recipe = new ItemStack[]{new ItemStack(TinkerWorld.slimeGel, 1, 0), new ItemStack(Items.field_151079_bi), feather, feather, feather, feather, feather, feather};
        ItemStack modWings = ModifyBuilder.instance.modifyItem(wings, recipe);
        MantleClientRegistry.registerManualLargeRecipe((String)"featherfall", (ItemStack)modWings.func_77946_l(), (ItemStack[])new ItemStack[]{feather, new ItemStack(TinkerWorld.slimeGel, 1, 0), feather, feather, wings.func_77946_l(), feather, feather, new ItemStack(Items.field_151079_bi), feather});
        ItemStack boots = TinkerArmor.travelBoots.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("doublejumpboots", boots.func_77946_l(), new ItemStack(Items.field_151073_bk), new ItemStack(TinkerWorld.slimeGel, 1, 1), new ItemStack((Block)Blocks.field_150331_J), null);
        TConstructClientRegistry.registerManualModifier("waterwalk", boots.func_77946_l(), new ItemStack(Blocks.field_150392_bi), new ItemStack(Blocks.field_150392_bi));
        TConstructClientRegistry.registerManualModifier("leadboots", boots.func_77946_l(), new ItemStack(Blocks.field_150339_S));
        TConstructClientRegistry.registerManualModifier("slimysoles", boots.func_77946_l(), new ItemStack(TinkerWorld.slimePad, 1, 0), new ItemStack(TinkerWorld.slimePad, 1, 0));
        ItemStack gloves = TinkerArmor.travelGlove.getDefaultItem();
        TConstructClientRegistry.registerManualModifier("glovehaste", gloves.func_77946_l(), redstone, new ItemStack(Blocks.field_150451_bX));
        TConstructClientRegistry.registerManualModifier("gloveknuckles", gloves.func_77946_l(), new ItemStack(Items.field_151128_bU), new ItemStack(Blocks.field_150371_ca, 1, Short.MAX_VALUE));
        ItemStack moss = new ItemStack(TinkerTools.materials, 1, 6);
        TConstructClientRegistry.registerManualModifier("mossgoggles", goggles.func_77946_l(), moss.func_77946_l());
        TConstructClientRegistry.registerManualModifier("mossvest", vest.func_77946_l(), moss.func_77946_l());
        TConstructClientRegistry.registerManualModifier("mosswings", wings.func_77946_l(), moss.func_77946_l());
        TConstructClientRegistry.registerManualModifier("mossboots", boots.func_77946_l(), moss.func_77946_l());
    }

    @Override
    protected void registerGuiHandler() {
        super.registerGuiHandler();
        TProxyCommon.registerClientGuiHandler(100, this);
        TProxyCommon.registerClientGuiHandler(101, this);
        TProxyCommon.registerClientGuiHandler(102, this);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (ID == 100) {
            return new GuiInventory(player);
        }
        if (ID == 101) {
            armorExtended.init((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return new ArmorExtendedGui(player.field_71071_by, armorExtended);
        }
        if (ID == 102) {
            knapsack.init((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return new KnapsackGui(player.field_71071_by, knapsack);
        }
        return null;
    }

    @Override
    public void registerTickHandler() {
        FMLCommonHandler.instance().bus().register((Object)new ArmorTickHandler());
    }

    @Override
    public void registerKeys() {
        controlInstance.registerKeys();
        TabRegistry.registerTab(new InventoryTabVanilla());
        TabRegistry.registerTab(new InventoryTabArmorExtended());
        TabRegistry.registerTab(new InventoryTabKnapsack());
    }

    @SubscribeEvent
    public void goggleZoom(FOVUpdateEvent event) {
        ItemStack helmet;
        if (ArmorControls.zoom && (helmet = event.entity.func_82169_q(3)) != null && helmet.func_77973_b() instanceof TravelGear) {
            event.newfov = 0.3f;
        }
    }

    @SubscribeEvent
    public void adjustArmor(RenderPlayerEvent.SetArmorModel event) {
        switch (event.slot) {
            case 1: {
                ArmorProxyClient.vest.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.vest.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.vest.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.vest.field_78117_n = event.renderer.field_77109_a.field_78117_n;
            }
            case 2: {
                ArmorProxyClient.wings.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.wings.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.wings.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.wings.field_78117_n = event.renderer.field_77109_a.field_78117_n;
                ArmorProxyClient.glove.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.glove.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.glove.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.glove.field_78117_n = event.renderer.field_77109_a.field_78117_n;
                ArmorProxyClient.glove.field_78119_l = event.renderer.field_77109_a.field_78119_l;
                ArmorProxyClient.glove.field_78120_m = event.renderer.field_77109_a.field_78120_m;
                ArmorProxyClient.belt.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.belt.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.belt.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.belt.field_78117_n = event.renderer.field_77109_a.field_78117_n;
                if (!PHConstruct.showTravellerAccessories) break;
                this.renderArmorExtras(event);
                break;
            }
            case 3: {
                ArmorProxyClient.bootbump.field_78095_p = event.renderer.field_77109_a.field_78095_p;
                ArmorProxyClient.bootbump.field_78093_q = event.renderer.field_77109_a.field_78093_q;
                ArmorProxyClient.bootbump.field_78091_s = event.renderer.field_77109_a.field_78091_s;
                ArmorProxyClient.bootbump.field_78117_n = event.renderer.field_77109_a.field_78117_n;
            }
        }
    }

    public static int getTranslucentID() {
        if (translucentID == -6) {
            ArmorProxyClient.setTranslucentID();
        }
        return translucentID;
    }

    private static void setTranslucentID() {
        for (Enchantment ench : Enchantment.field_77331_b) {
            if (ench == null || !ench.func_77320_a().equals("enchantment.wg.invisibleGear")) continue;
            translucentID = ench.field_77352_x;
            return;
        }
        translucentID = -1;
    }

    public static int getTranslucencyLevel(ItemStack stack) {
        int translucent = ArmorProxyClient.getTranslucentID();
        if (translucent > 0) {
            return EnchantmentHelper.func_77506_a((int)translucent, (ItemStack)stack);
        }
        return 0;
    }

    void renderArmorExtras(RenderPlayerEvent.SetArmorModel event) {
        ModelBiped model;
        Item item;
        float pitch;
        EntityPlayer player = event.entityPlayer;
        if (player != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        float partialTick = event.partialRenderTick;
        float yawOffset = this.interpolateRotation(player.field_70760_ar, player.field_70761_aq, partialTick);
        float yawRotation = this.interpolateRotation(player.field_70758_at, player.field_70759_as, partialTick);
        float zeropointsixtwofive = 0.0625f;
        if (player.func_70115_ae() && player.field_70154_o instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase1 = (EntityLivingBase)player.field_70154_o;
            yawOffset = this.interpolateRotation(entitylivingbase1.field_70760_ar, entitylivingbase1.field_70761_aq, partialTick);
            pitch = MathHelper.func_76142_g((float)(yawRotation - yawOffset));
            if (pitch < -85.0f) {
                pitch = -85.0f;
            }
            if (pitch >= 85.0f) {
                pitch = 85.0f;
            }
            yawOffset = yawRotation - pitch;
            if (pitch * pitch > 2500.0f) {
                yawOffset += pitch * 0.2f;
            }
        }
        pitch = this.handleRotationFloat((EntityLivingBase)player, partialTick);
        float bodyRotation = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTick;
        float limbSwing = player.field_70722_aY + (player.field_70721_aZ - player.field_70722_aY) * partialTick;
        float limbSwingMod = player.field_70754_ba - player.field_70721_aZ * (1.0f - partialTick);
        ArmorExtended armor = armorExtended;
        if (!(armor == null || armor.inventory[1] == null || ArmorProxyClient.getTranslucencyLevel(armor.inventory[1]) == 2 || player.func_82150_aj() && ArmorProxyClient.getTranslucencyLevel(armor.inventory[1]) > 0)) {
            item = armor.inventory[1].func_77973_b();
            model = item.getArmorModel((EntityLivingBase)player, armor.inventory[1], 4);
            if (item instanceof IAccessoryModel) {
                this.mc.func_110434_K().func_110577_a(((IAccessoryModel)item).getWearbleTexture((Entity)player, armor.inventory[1], 1));
                model.func_78086_a((EntityLivingBase)player, limbSwingMod, limbSwing, partialTick);
                model.func_78088_a((Entity)player, limbSwingMod, limbSwing, pitch, yawRotation - yawOffset, bodyRotation, 0.0625f);
            }
        }
        if (!(armor == null || armor.inventory[3] == null || ArmorProxyClient.getTranslucencyLevel(armor.inventory[3]) == 2 || player.func_82150_aj() && ArmorProxyClient.getTranslucencyLevel(armor.inventory[3]) > 0)) {
            item = armor.inventory[3].func_77973_b();
            model = item.getArmorModel((EntityLivingBase)player, armor.inventory[3], 5);
            if (item instanceof IAccessoryModel) {
                this.mc.func_110434_K().func_110577_a(((IAccessoryModel)item).getWearbleTexture((Entity)player, armor.inventory[1], 1));
                model.func_78086_a((EntityLivingBase)player, limbSwingMod, limbSwing, partialTick);
                model.func_78088_a((Entity)player, limbSwingMod, limbSwing, pitch, yawRotation - yawOffset, bodyRotation, 0.0625f);
            }
        }
    }

    private float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    protected float handleRotationFloat(EntityLivingBase par1EntityLivingBase, float par2) {
        return (float)par1EntityLivingBase.field_70173_aa + par2;
    }

    @Override
    public void updatePlayerStats(TPlayerStats stats) {
        playerStats.copyFrom(stats, false);
        armorExtended = stats.armor;
        knapsack = stats.knapsack;
    }

    static {
        translucentID = -6;
    }
}

