/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.network.packets;

import com.google.common.base.Throwables;
import com.rwtema.extrautils.network.XUPacketBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.C08PacketPlayerBlockPlacement;

public class PacketUseItemAlt
extends XUPacketBase {
    private int x;
    private int y;
    private int z;
    private int face;
    private ItemStack item;
    private float hitX;
    private float hitY;
    private float hitZ;
    private EntityPlayerMP player;
    public static final ThreadLocal<Boolean> altPlace = new ThreadLocal();

    public PacketUseItemAlt(int x, int y, int z, int face, ItemStack item, float hitX, float hitY, float hitZ) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.face = face;
        this.item = item;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
    }

    public PacketUseItemAlt() {
    }

    @Override
    public void writeData(ByteBuf data) throws Exception {
        data.writeInt(this.x);
        data.writeInt(this.y);
        data.writeInt(this.z);
        data.writeByte(this.face);
        this.writeItemStack(data, this.item);
        data.writeByte((int)((byte)(this.hitX * 16.0f)));
        data.writeByte((int)((byte)(this.hitY * 16.0f)));
        data.writeByte((int)((byte)(this.hitZ * 16.0f)));
    }

    @Override
    public void readData(EntityPlayer player, ByteBuf data) {
        this.x = data.readInt();
        this.y = data.readInt();
        this.z = data.readInt();
        this.face = data.readByte();
        this.item = this.readItemStack(data);
        this.hitX = (float)data.readByte() * 0.0625f;
        this.hitY = (float)data.readByte() * 0.0625f;
        this.hitZ = (float)data.readByte() * 0.0625f;
        this.player = (EntityPlayerMP)player;
    }

    @Override
    public synchronized void doStuffServer(ChannelHandlerContext ctx) {
        C08PacketPlayerBlockPlacement placement;
        try {
            PacketBuffer packetbuffer = new PacketBuffer(Unpooled.buffer());
            packetbuffer.writeInt(this.x);
            packetbuffer.writeByte(this.y);
            packetbuffer.writeInt(this.z);
            packetbuffer.writeByte(this.face);
            packetbuffer.func_150788_a(this.item);
            packetbuffer.writeByte((int)(this.hitX * 16.0f));
            packetbuffer.writeByte((int)(this.hitY * 16.0f));
            packetbuffer.writeByte((int)(this.hitZ * 16.0f));
            placement = new C08PacketPlayerBlockPlacement();
            placement.func_148837_a(packetbuffer);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        altPlace.set(true);
        this.player.field_71135_a.func_147346_a(placement);
        altPlace.set(false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void doStuffClient() {
    }

    @Override
    public boolean isValidSenderSide(Side properSenderSide) {
        return properSenderSide == Side.CLIENT;
    }
}

