/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.modintegration;

import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.modintegration.TConIntegration;
import com.rwtema.extrautils.texture.TextureBedrockLava;
import com.rwtema.extrautils.texture.TextureDerived;
import com.rwtema.extrautils.texture.TextureUnstableLava;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.event.SmelteryCastedEvent;
import tconstruct.library.event.ToolBuildEvent;
import tconstruct.library.event.ToolCraftEvent;
import tconstruct.library.event.ToolCraftedEvent;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.util.IToolPart;
import tconstruct.tools.TinkerTools;

public class TConEvents {
    public final double SPEED_REDUCTION = -0.1;
    public static final String TAG_DEADLINE = "XUDeadline";
    public final String TAG_LOCALDEADLINE = "XULocalDeadline";
    public final String TAG_LOCALDIM = "XULocalDim";
    public static final int TICKSTILDESTRUCTION = 200;
    public static final UUID uuid = UUID.fromString("52ca0342-0a6b-11e5-a6c0-1697f925ec7b");
    public final String TAG_PREFIX = "[TCon]";
    public static final String iconName = "extrautils:unstableFluid";
    public static final String iconName2 = "extrautils:bedrockFluid";
    int curDim;

    @SubscribeEvent
    public void getCurrentWorldTicking(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            this.curDim = event.world.field_73011_w.field_76574_g;
        }
    }

    @SubscribeEvent
    public void addUnstableTimer(SmelteryCastedEvent.CastingTable event) {
        if (ExtraUtils.tcon_unstable_material_id <= 0) {
            return;
        }
        ItemStack output = event.output;
        if (output == null || !(output.func_77973_b() instanceof IToolPart)) {
            return;
        }
        IToolPart part = (IToolPart)output.func_77973_b();
        if (part.getMaterialID(output) != ExtraUtils.tcon_unstable_material_id) {
            return;
        }
        NBTTagCompound tag = TConEvents.getOrInitTag(output);
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null) {
            return;
        }
        tag.func_74772_a(TAG_DEADLINE, world.func_82737_E());
        WorldServer localWorld = DimensionManager.getWorld((int)this.curDim);
        if (localWorld != null) {
            tag.func_74772_a("XULocalDeadline", localWorld.func_82737_E());
            tag.func_74768_a("XULocalDim", this.curDim);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void denyCraft(ToolBuildEvent event) {
        if (ExtraUtils.tcon_unstable_material_id <= 0) {
            return;
        }
        WorldServer world = DimensionManager.getWorld((int)0);
        if (world == null) {
            return;
        }
        if (TConEvents.isToolExpired(event.headStack, world) || TConEvents.isToolExpired(event.handleStack, world) || TConEvents.isToolExpired(event.accessoryStack, world) || TConEvents.isToolExpired(event.extraStack, world)) {
            event.headStack = null;
            event.handleStack = null;
            event.accessoryStack = null;
            event.extraStack = null;
        }
    }

    public ItemStack handleToolPart(ItemStack stack, WorldServer world) {
        return !TConEvents.isToolExpired(stack, world) ? stack : null;
    }

    public static boolean isToolExpired(ItemStack stack) {
        WorldServer world = DimensionManager.getWorld((int)0);
        return world != null && TConEvents.isToolExpired(stack, world);
    }

    public static boolean isToolExpired(ItemStack stack, WorldServer world) {
        NBTTagCompound tag;
        if (stack == null) {
            return false;
        }
        if (ToolBuilder.instance.getMaterialID(stack) == ExtraUtils.tcon_unstable_material_id && stack.func_77942_o() && (tag = stack.func_77978_p()).func_150297_b(TAG_DEADLINE, 4)) {
            long deadline = tag.func_74763_f(TAG_DEADLINE);
            if (world.func_82737_E() - deadline > 200L) {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void unstableTooltip(ItemTooltipEvent event) {
        if (event.itemStack == null || event.entityPlayer == null || event.entityPlayer.field_70170_p == null) {
            return;
        }
        if (ExtraUtils.tcon_unstable_material_id <= 0) {
            return;
        }
        if (ToolBuilder.instance.getMaterialID(event.itemStack) != ExtraUtils.tcon_unstable_material_id) {
            return;
        }
        NBTTagCompound tag = event.itemStack.func_77978_p();
        if (tag == null || !tag.func_74764_b("XULocalDeadline") || tag.func_74762_e("XULocalDim") != event.entityPlayer.field_70170_p.field_73011_w.field_76574_g) {
            event.toolTip.add(EnumChatFormatting.RED + "Unstable parts will denature after " + 10 + " seconds" + EnumChatFormatting.RESET);
            return;
        }
        long finalTime = tag.func_74763_f("XULocalDeadline") + 200L;
        long curTime = event.entityPlayer.field_70170_p.func_82737_E();
        if (curTime <= finalTime) {
            EnumChatFormatting col = EnumChatFormatting.RED;
            if (curTime >= finalTime - 100L && Minecraft.func_71386_F() % 200L < 100L) {
                col = EnumChatFormatting.YELLOW;
            }
            event.toolTip.add(col + "Part will denature in " + String.format(Locale.ENGLISH, "%.1f", Float.valueOf((float)(finalTime - curTime) / 20.0f)) + " seconds" + EnumChatFormatting.RESET);
            event.toolTip.add(col + "After that it will become useless" + EnumChatFormatting.RESET);
        } else {
            event.toolTip.add(EnumChatFormatting.RED + "Denatured" + EnumChatFormatting.RESET);
        }
    }

    @SubscribeEvent
    public void addBedrockiumPartSlowness(SmelteryCastedEvent.CastingTable event) {
        if (ExtraUtils.tcon_bedrock_material_id <= 0) {
            return;
        }
        ItemStack output = event.output;
        if (output == null || !(output.func_77973_b() instanceof IToolPart)) {
            return;
        }
        IToolPart part = (IToolPart)output.func_77973_b();
        if (part.getMaterialID(output) != ExtraUtils.tcon_bedrock_material_id) {
            return;
        }
        NBTTagCompound tag = TConEvents.getOrInitTag(output);
        this.assignAttribute(tag, SharedMonsterAttributes.field_111263_d, new AttributeModifier(uuid, "[TCon]Bedrockium Weight", -0.1, 2));
    }

    public static NBTTagCompound getOrInitTag(ItemStack output) {
        NBTTagCompound tag = output.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            output.func_77982_d(tag);
        }
        return tag;
    }

    @SubscribeEvent
    public void handleBedrockMod(ToolCraftedEvent event) {
        if (!(event.tool.func_77973_b() instanceof ToolCore)) {
            return;
        }
        NBTTagCompound tag = event.tool.func_77978_p();
        if (tag == null) {
            return;
        }
        this.assignProperSlowness(tag);
    }

    @SubscribeEvent
    public void handleBedrockModification(ToolCraftEvent.NormalTool event) {
        this.assignProperSlowness(event.toolTag);
    }

    public void assignProperSlowness(NBTTagCompound tag) {
        this.removeTags(tag);
        if (ExtraUtils.tcon_bedrock_material_id <= 0) {
            return;
        }
        int i = this.getNumMaterials(tag.func_74775_l("InfiTool"), ExtraUtils.tcon_bedrock_material_id);
        if (i == 0) {
            return;
        }
        this.assignAttribute(tag, SharedMonsterAttributes.field_111263_d, new AttributeModifier(uuid, "[TCon]Bedrockium Weight", -0.1 * (double)i, 2));
        this.assignAttribute(tag, SharedMonsterAttributes.field_111266_c, new AttributeModifier(uuid, "[TCon]Bedrockium Weight", 0.5 * (double)i, 2));
    }

    public void removeTags(NBTTagCompound tag) {
        NBTTagList nbttaglist = tag.func_150295_c("AttributeModifiers", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound tagAt = nbttaglist.func_150305_b(i);
            if (!tagAt.func_74779_i("Name").startsWith("[TCon]")) continue;
            nbttaglist.func_74744_a(i--);
        }
    }

    public void assignAttribute(NBTTagCompound tag, IAttribute attribute, AttributeModifier modifier) {
        NBTTagList nbttaglist = tag.func_150295_c("AttributeModifiers", 10);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74778_a("AttributeName", attribute.func_111108_a());
        nbttagcompound.func_74778_a("Name", modifier.func_111166_b());
        nbttagcompound.func_74780_a("Amount", modifier.func_111164_d());
        nbttagcompound.func_74768_a("Operation", modifier.func_111169_c());
        nbttagcompound.func_74772_a("UUIDMost", modifier.func_111167_a().getMostSignificantBits());
        nbttagcompound.func_74772_a("UUIDLeast", modifier.func_111167_a().getLeastSignificantBits());
        nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        tag.func_74782_a("AttributeModifiers", (NBTBase)nbttaglist);
    }

    @SubscribeEvent
    public void handleUnstableCrafting(ToolCraftEvent.NormalTool event) {
        if (ExtraUtils.tcon_unstable_material_id <= 0) {
            return;
        }
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        if (!this.isUniformTool(toolTag, ExtraUtils.tcon_unstable_material_id)) {
            return;
        }
        toolTag.func_74768_a("Unbreaking", 10);
    }

    @SubscribeEvent
    public void handleMagicWood(ToolCraftEvent.NormalTool event) {
        if (ExtraUtils.tcon_magical_wood_id <= 0) {
            return;
        }
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        int modifiers = toolTag.func_74762_e("Modifiers");
        if (!this.isUniformTool(toolTag, ExtraUtils.tcon_magical_wood_id)) {
            int bonusModifiers = this.getNumMaterials(toolTag, ExtraUtils.tcon_magical_wood_id);
            toolTag.func_74768_a("Modifiers", modifiers += bonusModifiers);
        } else {
            if (event.tool == TinkerTools.battlesign) {
                modifiers += 3;
            }
            toolTag.func_74768_a("Modifiers", modifiers + 8);
        }
    }

    public int getNumMaterials(NBTTagCompound toolTag, int materialID) {
        int bonusModifiers = 0;
        if (toolTag.func_74762_e("Head") == materialID) {
            ++bonusModifiers;
        }
        if (toolTag.func_74762_e("Handle") == materialID) {
            ++bonusModifiers;
        }
        if (toolTag.func_74762_e("Accessory") == materialID) {
            ++bonusModifiers;
        }
        if (toolTag.func_74762_e("Extra") == materialID) {
            ++bonusModifiers;
        }
        return bonusModifiers;
    }

    public boolean isUniformTool(NBTTagCompound toolTag, int materialId) {
        return toolTag.func_74762_e("Head") == materialId && toolTag.func_74762_e("Handle") == materialId && this.valid(toolTag.func_74762_e("Accessory"), materialId) && this.valid(toolTag.func_74762_e("Extra"), materialId);
    }

    public boolean valid(int i, int materialId) {
        return i == materialId || i == -1 || i == 0;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleStich(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() != 0) {
            return;
        }
        TConIntegration.bedrock.setIcons(event.map.func_94245_a("TConIntegration.bedrock"));
        TextureDerived sprite = new TextureBedrockLava(iconName2, "lava_still");
        event.map.setTextureEntry(iconName2, (TextureAtlasSprite)sprite);
        if (TConIntegration.bedrock != null) {
            TConIntegration.bedrock.setIcons((IIcon)sprite);
        }
        if (event.map.setTextureEntry("extrautils:bedrockFluid_flowing", (TextureAtlasSprite)(sprite = new TextureBedrockLava("extrautils:bedrockFluid_flowing", "lava_flow"))) && TConIntegration.bedrock != null) {
            TConIntegration.bedrock.setFlowingIcon((IIcon)sprite);
        }
        sprite = new TextureUnstableLava(iconName, "water_still");
        event.map.setTextureEntry(iconName, (TextureAtlasSprite)sprite);
        if (TConIntegration.unstable != null) {
            TConIntegration.unstable.setIcons((IIcon)sprite);
        }
        if (event.map.setTextureEntry("extrautils:unstableFluid_flowing", (TextureAtlasSprite)(sprite = new TextureUnstableLava("extrautils:unstableFluid_flowing", "water_flow"))) && TConIntegration.unstable != null) {
            TConIntegration.unstable.setFlowingIcon((IIcon)sprite);
        }
    }
}

