/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.gui;

import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import com.glodblock.github.inventory.gui.IGuiFactory;
import com.glodblock.github.inventory.item.IItemInventory;
import com.glodblock.github.util.Util;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ItemGuiFactory<T>
implements IGuiFactory {
    protected final Class<T> invClass;

    ItemGuiFactory(Class<T> invClass) {
        this.invClass = invClass;
    }

    @Nullable
    protected T getInventory(Object inv) {
        return this.invClass.isInstance(inv) ? (T)this.invClass.cast(inv) : null;
    }

    @Override
    @Nullable
    public Object createServerGui(EntityPlayer player, World world, int x, int y, int z, ForgeDirection face) {
        ItemStack item = Util.getWirelessTerminal(player, x);
        if (item == null || !(item.func_77973_b() instanceof IItemInventory)) {
            return null;
        }
        T inv = this.getInventory(((IItemInventory)item.func_77973_b()).getInventory(item, world, x, y, z, player));
        if (inv == null) {
            return null;
        }
        Object gui = this.createServerGui(player, inv);
        if (gui instanceof AEBaseContainer) {
            ContainerOpenContext ctx = new ContainerOpenContext(inv);
            ctx.setWorld(world);
            ctx.setX(x);
            ctx.setY(y);
            ctx.setZ(z);
            ctx.setSide(face);
            ((AEBaseContainer)gui).setOpenContext(ctx);
        }
        return gui;
    }

    @Nullable
    protected abstract Object createServerGui(EntityPlayer var1, T var2);

    @Override
    @Nullable
    public Object createClientGui(EntityPlayer player, World world, int x, int y, int z, ForgeDirection face) {
        ItemStack item = Util.getWirelessTerminal(player, x);
        if (item == null || !(item.func_77973_b() instanceof IItemInventory)) {
            return null;
        }
        T inv = this.getInventory(((IItemInventory)item.func_77973_b()).getInventory(item, world, x, y, z, player));
        if (inv == null && Minecraft.func_71410_x().field_71462_r != null) {
            player.func_71053_j();
        }
        return inv != null ? this.createClientGui(player, inv) : null;
    }

    @Nullable
    protected abstract Object createClientGui(EntityPlayer var1, T var2);
}

