/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.item;

import com.cleanroommc.modularui.utils.item.IItemStackLong;
import com.google.common.primitives.Ints;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackLong
implements IItemStackLong {
    private long stackSize;
    private long maxStackSize;
    private Item item;
    private int damage;
    private NBTTagCompound nbt;

    public ItemStackLong(@Nonnull ItemStack item) {
        this(item.func_77973_b(), item.func_77976_d(), item.func_77960_j(), item.field_77994_a, item.func_77978_p());
    }

    public ItemStackLong(@Nonnull Item item) {
        this(item, 64L, 0, 0L, null);
    }

    public ItemStackLong(@Nonnull Item item, long maxStackSize) {
        this(item, maxStackSize, 0, 0L, null);
    }

    public ItemStackLong(@Nonnull Item item, long maxStackSize, int damage) {
        this(item, maxStackSize, damage, 0L, null);
    }

    public ItemStackLong(@Nonnull Item item, long maxStackSize, int damage, long stackSize) {
        this(item, maxStackSize, damage, stackSize, null);
    }

    public ItemStackLong(@Nonnull Item item, long maxStackSize, int damage, long stackSize, @Nullable NBTTagCompound nbt) {
        this.item = item;
        this.maxStackSize = maxStackSize;
        this.stackSize = stackSize;
        this.damage = damage;
        this.nbt = nbt;
    }

    @Override
    public long getStackSize() {
        return this.stackSize;
    }

    @Override
    public long getMaxStackSize() {
        return this.maxStackSize;
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public int getItemDamage() {
        return this.damage;
    }

    @Override
    @Nullable
    public NBTTagCompound getTagCompound() {
        return this.nbt;
    }

    @Override
    public void setStackSize(long newStackSize) {
        this.stackSize = newStackSize;
    }

    @Override
    @Nonnull
    public ItemStack getAsItemStack() {
        return new ItemStack(this.item, Ints.saturatedCast((long)this.stackSize), this.damage);
    }

    @Override
    public boolean isItemEqual(IItemStackLong other) {
        return this.getItem() == other.getItem();
    }

    @Override
    public boolean hasTagCompound() {
        return this.getTagCompound() != null;
    }

    @Override
    public boolean isStackable() {
        return this.item.getItemStackLimit(this.getAsItemStack()) > 1;
    }

    @Override
    public boolean getHasSubtypes() {
        return this.item.func_77614_k();
    }

    @Override
    @Nonnull
    public IItemStackLong copy() {
        return new ItemStackLong(this.item, this.maxStackSize, this.damage, this.stackSize, this.nbt);
    }

    @Override
    @Nonnull
    public IItemStackLong splitStack(long toSplit) {
        ItemStackLong split = new ItemStackLong(this.item, this.maxStackSize, this.damage, toSplit, this.nbt);
        this.setStackSize(this.getStackSize() - toSplit);
        return split;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound nbt) {
        ItemStack itemStack = this.getAsItemStack();
        itemStack.func_77982_d(this.getTagCompound());
        itemStack.func_77955_b(nbt);
        nbt.func_74772_a("stackSizeLong", this.getStackSize());
        nbt.func_74772_a("maxStackSizeLong", this.getMaxStackSize());
        return nbt;
    }

    @Nonnull
    public static ItemStackLong loadFromNBT(@Nonnull NBTTagCompound nbt) {
        ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)nbt);
        return new ItemStackLong(itemStack.func_77973_b(), nbt.func_74763_f("maxStackSizeLong"), itemStack.func_77960_j(), nbt.func_74763_f("stackSizeLong"), itemStack.func_77978_p());
    }

    public static boolean areItemStacksEqual(@Nullable IItemStackLong a, @Nullable IItemStackLong b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getItem() != b.getItem()) {
            return false;
        }
        if (a.getItemDamage() != b.getItemDamage()) {
            return false;
        }
        if (a.getStackSize() != b.getStackSize()) {
            return false;
        }
        if (a.getTagCompound() == null && b.getTagCompound() == null) {
            return true;
        }
        if (a.getTagCompound() == null || b.getTagCompound() == null) {
            return false;
        }
        return a.getTagCompound().equals((Object)b.getTagCompound());
    }
}

