/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.nodes.AbstractGradient;
import com.github.weisj.jsvg.nodes.Stop;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.parser.AttributeNode;
import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ElementCategories(value={Category.Gradient})
@PermittedContent(categories={Category.Descriptive}, anyOf={Stop.class})
public final class RadialGradient
extends AbstractGradient<RadialGradient> {
    public static final String TAG = "radialgradient";
    private Length cx;
    private Length cy;
    private Length r;
    private Length fr;
    private Length fx;
    private Length fy;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    protected void buildGradient(@NotNull AttributeNode attributeNode, @Nullable RadialGradient template) {
        this.cx = attributeNode.getLength("cx", template != null ? template.cx : Unit.PERCENTAGE.valueOf(50.0f));
        this.cy = attributeNode.getLength("cy", template != null ? template.cy : Unit.PERCENTAGE.valueOf(50.0f));
        this.r = attributeNode.getLength("r", template != null ? template.r : Unit.PERCENTAGE.valueOf(50.0f));
        this.fr = attributeNode.getLength("fr", template != null ? template.fr : Unit.PERCENTAGE.valueOf(0.0f));
        this.fx = attributeNode.getLength("fx", template != null ? template.fx : this.cx);
        this.fy = attributeNode.getLength("fy", template != null ? template.fy : this.cy);
    }

    @Override
    @NotNull
    protected Paint gradientForBounds(@NotNull MeasureContext measure, @NotNull Rectangle2D bounds, float[] gradOffsets, @NotNull Color[] gradColors) {
        Point2D.Float center = new Point2D.Float(this.cx.resolveWidth(measure), this.cy.resolveHeight(measure));
        Point2D.Float focusCenter = new Point2D.Float(this.fx.resolveWidth(measure), this.fy.resolveHeight(measure));
        float radius = this.r.resolveLength(measure);
        float focusRadius = this.fr.resolveLength(measure);
        float[] offsets = gradOffsets;
        Color[] offsetColors = gradColors;
        if (focusRadius > 0.0f) {
            float[] newOffsets = new float[offsets.length + 1];
            newOffsets[0] = Math.nextAfter(focusRadius / radius, Double.NEGATIVE_INFINITY);
            float offset = focusRadius / radius;
            float factor = 1.0f - offset;
            for (int i = 1; i < newOffsets.length; ++i) {
                newOffsets[i] = offset + offsets[i - 1] * factor;
            }
            offsets = newOffsets;
            Color[] newColors = new Color[gradColors.length + 1];
            System.arraycopy(offsetColors, 0, newColors, 1, gradColors.length);
            offsetColors = newColors;
            newColors[0] = gradColors[0];
        }
        return new RadialGradientPaint(center, radius, focusCenter, offsets, offsetColors, this.spreadMethod.cycleMethod(), MultipleGradientPaint.ColorSpaceType.SRGB, this.computeViewTransform(bounds));
    }

    @Override
    public String toString() {
        return "RadialGradient{spreadMethod=" + (Object)((Object)this.spreadMethod) + ", gradientTransform=" + this.gradientTransform + ", cx=" + this.cx + ", cy=" + this.cy + ", r=" + this.r + ", fr=" + this.fr + ", fx=" + this.fx + ", fy=" + this.fy + ", colors=" + Arrays.toString(this.colors()) + ", offsets=" + Arrays.toString(this.offsets()) + '}';
    }
}

