/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tooltip;

import com.github.weisj.darklaf.components.border.BubbleBorder;
import com.github.weisj.darklaf.components.border.DropShadowBorder;
import com.github.weisj.darklaf.components.tooltip.ToolTipStyle;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.tooltip.AlignableTooltipBorder;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.Alignment;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class DarkTooltipBorder
implements Border,
AlignableTooltipBorder {
    private final DropShadowBorder shadowBorder;
    private final BubbleBorder bubbleBorder;
    private final boolean paintShadow;
    private Insets margin = UIManager.getInsets("ToolTip.borderInsets");
    private Alignment alignment;
    private boolean showPointer;

    public DarkTooltipBorder() {
        if (this.margin == null) {
            this.margin = new Insets(0, 0, 0, 0);
        }
        this.bubbleBorder = new BubbleBorder(UIManager.getColor("ToolTip.borderColor"));
        this.bubbleBorder.setThickness(1);
        this.bubbleBorder.setPointerSize(8);
        this.bubbleBorder.setPointerWidth(12);
        int borderRadius = UIManager.getInt("Tooltip.borderRadius");
        this.bubbleBorder.setRadius(borderRadius);
        this.bubbleBorder.setPointerSide(Alignment.CENTER);
        int shadowSize = UIManager.getInt("ToolTip.shadowSize");
        float opacity = (float)UIManager.getInt("ToolTip.shadowOpacity") / 100.0f;
        Color shadowColor = UIManager.getColor("ToolTip.borderShadowColor");
        this.shadowBorder = new DropShadowBorder(shadowColor, shadowSize, opacity, borderRadius);
        this.paintShadow = UIManager.getBoolean("ToolTip.paintShadow");
    }

    public Shape[] getBackgroundShapes(Component c, int width, int height) {
        if (this.isPlain(c)) {
            return new Area[]{new Area(new Rectangle(0, 0, width, height))};
        }
        Insets ins = this.shadowBorder.getBorderInsets(null);
        this.adjustInsets(ins);
        return this.bubbleBorder.getBubbleShapes(ins.left, ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom, (float)this.bubbleBorder.getThickness() / 3.0f);
    }

    private int getPointerOffset(Component c, Dimension dimension, int thicknessFactor) {
        if (!this.showPointer || this.isPlain(c)) {
            return 0;
        }
        int offset = (int)this.bubbleBorder.getOffset(dimension.width - 2 * this.shadowBorder.getShadowSize(), dimension.height) + this.shadowBorder.getShadowSize();
        int thickness = this.bubbleBorder.getThickness();
        Alignment align = this.bubbleBorder.getPointerSide();
        if (align.isWest(false)) {
            offset += thicknessFactor * thickness;
        }
        return offset;
    }

    @Override
    public void adjustContentSize(JToolTip toolTip, Dimension dim, Alignment align) {
        if (align == Alignment.EAST || align == Alignment.WEST) {
            dim.height -= this.getShadowSize(toolTip);
        }
    }

    private void adjustInsets(Insets si) {
        Alignment align = this.bubbleBorder.getPointerSide();
        int pointerSize = this.bubbleBorder.getPointerSize();
        if (align.isSouth()) {
            si.bottom -= pointerSize;
        } else if (align == Alignment.EAST) {
            si.right -= pointerSize;
        } else if (align == Alignment.WEST) {
            si.left -= pointerSize;
        } else if (align.isNorth()) {
            si.top -= pointerSize;
        }
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (c instanceof JToolTip && ((JToolTip)c).getTipText() == null) {
            return;
        }
        GraphicsContext context = new GraphicsContext(g);
        if (this.isPlain(c)) {
            g.setColor(this.bubbleBorder.getColor());
            PaintUtil.drawRect(g, x, y, width, height, 1);
            return;
        }
        Insets ins = this.shadowBorder.getBorderInsets(c);
        this.adjustInsets(ins);
        Area innerArea = this.bubbleBorder.getBubbleArea(x + ins.left, y + ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom, this.bubbleBorder.getThickness());
        if (this.paintShadow) {
            this.paintShadow(c, g, x, y, width, height, innerArea);
        }
        Area outerArea = this.bubbleBorder.getBubbleArea(x + ins.left, y + ins.top, width - ins.left - ins.right, height - ins.top - ins.bottom, 0.0f);
        outerArea.subtract(innerArea);
        this.bubbleBorder.paintBorder(g, outerArea);
        context.restore();
    }

    public void paintShadow(Component c, Graphics g, int x, int y, int width, int height, Area bubbleArea) {
        Shape oldClip = g.getClip();
        if (bubbleArea.contains(oldClip.getBounds())) {
            return;
        }
        Area clip = new Area(new Rectangle2D.Double(x, y, width, height));
        clip.subtract(bubbleArea);
        ((Graphics2D)g).clip(clip);
        int bw = 1 + this.bubbleBorder.getThickness();
        this.shadowBorder.paintBorder(c, g, x + bw, y + bw, width - 2 * bw, height - 2 * bw);
        g.setClip(oldClip);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        Insets uIns = this.getUserInsets(c);
        if (this.isPlain(c)) {
            return new Insets(1 + uIns.top, 1 + uIns.left, 1 + uIns.bottom, 1 + uIns.right);
        }
        Insets ins = new Insets(0, 0, 0, 0);
        Insets bi = this.bubbleBorder.getBorderInsets(c);
        Insets si = this.shadowBorder.getBorderInsets(c);
        ins.bottom = Math.max(bi.bottom, si.bottom) + uIns.bottom;
        ins.left = Math.max(bi.left, si.left) + uIns.left;
        ins.right = Math.max(bi.right, si.right) + uIns.right;
        ins.top = Math.max(bi.top, si.top) + uIns.top;
        return ins;
    }

    @Override
    @NotNull
    public Insets getAlignmentInsets(JToolTip c) {
        Insets shadowInsets = this.shadowBorder.getBorderInsets(c);
        return DarkUIUtil.addInsets(shadowInsets, DarkUIUtil.invert(this.bubbleBorder.getBorderInsets(c)));
    }

    protected Insets getUserInsets(Component c) {
        return PropertyUtil.getObject(c, "JToolTip.insets", Insets.class, this.margin);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void setPointerLocation(Alignment side, boolean showPointer) {
        if (showPointer) {
            this.bubbleBorder.setPointerSide(side);
        }
        this.showPointer = showPointer;
        this.alignment = side;
    }

    public void setPointerWidth(int width) {
        this.bubbleBorder.setPointerWidth(width);
    }

    public void setPointerHeight(int height) {
        this.bubbleBorder.setPointerSize(height);
    }

    protected boolean isPlain(Component c) {
        if (!(c instanceof JComponent)) {
            return false;
        }
        Object prop = ((JComponent)c).getClientProperty("JToolTip.style");
        return prop == ToolTipStyle.PLAIN || "plain".equals(prop);
    }

    public int getShadowSize(Component c) {
        if (this.isPlain(c)) {
            return 0;
        }
        return this.shadowBorder.getShadowSize();
    }

    @Override
    public Point alignTooltip(Component c, Point p, Alignment align, Dimension dim, boolean outside) {
        int factor = outside ? 1 : -1;
        int pointerDist = this.getDistanceToPointer();
        if (align == Alignment.EAST) {
            p.x -= factor * pointerDist;
            p.y -= factor * pointerDist;
        } else if (align == Alignment.WEST) {
            p.x += factor * pointerDist;
            p.y -= factor * pointerDist;
        } else if (align.isNorth()) {
            p.y += factor * pointerDist;
        } else if (align.isSouth()) {
            p.y -= factor * pointerDist;
        }
        if (align.isEast(false)) {
            p.x -= factor * this.getPointerOffset(c, dim, factor);
        } else if (align.isWest(false)) {
            p.x += factor * this.getPointerOffset(c, dim, factor);
        }
        return p;
    }

    private int getDistanceToPointer() {
        if (this.alignment == Alignment.CENTER) {
            return 0;
        }
        return Math.max(0, this.shadowBorder.getShadowSize() - this.bubbleBorder.getPointerSize()) + this.bubbleBorder.getThickness();
    }
}

