/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme.event;

import com.github.weisj.darklaf.theme.event.ThemeEvent;
import com.github.weisj.darklaf.theme.event.ThemeEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

public class ThemeEventSupport<E extends ThemeEvent, T extends ThemeEventListener<E>> {
    private final List<T> listenerList = Collections.synchronizedList(new ArrayList());

    public void addListener(T listener) {
        this.listenerList.add(listener);
    }

    public void removeListener(T listener) {
        this.listenerList.remove(listener);
    }

    public void dispatchEvent(E event) {
        this.dispatchEvent(event, ThemeEventListener::onEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(E event, BiConsumer<T, E> consumer) {
        List<T> list = this.listenerList;
        synchronized (list) {
            new ArrayList<T>(this.listenerList).forEach(listener -> {
                if (listener != null) {
                    consumer.accept(listener, event);
                }
            });
        }
    }
}

