/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.data;

import com.carpentersblocks.tileentity.TEBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class Hinge {
    public static final byte TYPE_GLASS_TOP = 0;
    public static final byte TYPE_GLASS_TALL = 1;
    public static final byte TYPE_PANELS = 2;
    public static final byte TYPE_SCREEN_TALL = 3;
    public static final byte TYPE_FRENCH_GLASS = 4;
    public static final byte TYPE_HIDDEN = 5;
    public static final byte FACING_XP = 0;
    public static final byte FACING_ZP = 1;
    public static final byte FACING_XN = 2;
    public static final byte FACING_ZN = 3;
    public static final byte HINGE_LEFT = 0;
    public static final byte HINGE_RIGHT = 1;
    public static final byte STATE_CLOSED = 0;
    public static final byte STATE_OPEN = 1;
    public static final byte PIECE_BOTTOM = 0;
    public static final byte PIECE_TOP = 1;
    public static final byte HINGED_NONRIGID = 0;
    public static final byte HINGED_RIGID = 1;

    public static int getType(TEBase TE) {
        return TE.getData() & 7;
    }

    public static void setType(TEBase TE, int type) {
        int temp = TE.getData() & 0xFFFFFFF8 | type;
        TE.setData(temp);
    }

    public static int getHinge(TEBase TE) {
        return (TE.getData() & 8) >> 3;
    }

    public static void setHingeSide(TEBase TE, int hingeSide) {
        int temp = TE.getData() & 0xFFFFFFF7 | hingeSide << 3;
        TE.setData(temp);
    }

    public static int getFacing(TEBase TE) {
        return (TE.getData() & 0x30) >> 4;
    }

    public static void setFacing(TEBase TE, int facing) {
        int temp = TE.getData() & 0xFFFFFFCF | facing << 4;
        TE.setData(temp);
    }

    public static int getState(TEBase TE) {
        return (TE.getData() & 0x40) >> 6;
    }

    public static void setState(TEBase TE, int state, boolean playSound) {
        int temp = TE.getData() & 0xFFFFFFBF | state << 6;
        World world = TE.func_145831_w();
        if (!world.field_72995_K && playSound) {
            world.func_72889_a((EntityPlayer)null, 1003, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, 0);
        }
        TE.setData(temp);
    }

    public static int getPiece(TEBase TE) {
        return (TE.getData() & 0x80) >> 7;
    }

    public static void setPiece(TEBase TE, int piece) {
        int temp = TE.getData() & 0xFFFFFF7F | piece << 7;
        TE.setData(temp);
    }

    public static int getRigidity(TEBase TE) {
        return (TE.getData() & 0x100) >> 8;
    }

    public static void setRigidity(TEBase TE, int rigid) {
        int temp = TE.getData() & 0xFFFFFEFF | rigid << 8;
        TE.setData(temp);
    }
}

