/*
 * Decompiled with CFR 0.152.
 */
package li.cil.repack.org.luaj.vm2;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import li.cil.repack.org.luaj.vm2.Buffer;
import li.cil.repack.org.luaj.vm2.LuaDouble;
import li.cil.repack.org.luaj.vm2.LuaInteger;
import li.cil.repack.org.luaj.vm2.LuaNumber;
import li.cil.repack.org.luaj.vm2.LuaValue;
import li.cil.repack.org.luaj.vm2.lib.MathLib;

public class LuaString
extends LuaValue {
    public static LuaValue s_metatable;
    public final byte[] m_bytes;
    public final int m_offset;
    public final int m_length;
    private final int m_hashcode;
    static final int RECENT_STRINGS_CACHE_SIZE = 128;
    static final int RECENT_STRINGS_MAX_LENGTH = 32;

    public static LuaString valueOf(String string) {
        char[] c = string.toCharArray();
        byte[] b = new byte[LuaString.lengthAsUtf8(c)];
        LuaString.encodeToUtf8(c, c.length, b, 0);
        return LuaString.valueUsing(b, 0, b.length);
    }

    public static LuaString valueOf(byte[] bytes, int off, int len2) {
        LuaString s;
        if (len2 > 32) {
            return LuaString.valueFromCopy(bytes, off, len2);
        }
        int hash = LuaString.hashCode(bytes, off, len2);
        int bucket = hash & 0x7F;
        LuaString t = RecentShortStrings.recent_short_strings[bucket];
        if (t != null && t.m_hashcode == hash && t.byteseq(bytes, off, len2)) {
            return t;
        }
        RecentShortStrings.recent_short_strings[bucket] = s = LuaString.valueFromCopy(bytes, off, len2);
        return s;
    }

    private static LuaString valueFromCopy(byte[] bytes, int off, int len2) {
        byte[] copy2 = new byte[len2];
        System.arraycopy(bytes, off, copy2, 0, len2);
        return new LuaString(copy2, 0, len2);
    }

    public static LuaString valueUsing(byte[] bytes, int off, int len2) {
        LuaString s;
        if (bytes.length > 32) {
            return new LuaString(bytes, off, len2);
        }
        int hash = LuaString.hashCode(bytes, off, len2);
        int bucket = hash & 0x7F;
        LuaString t = RecentShortStrings.recent_short_strings[bucket];
        if (t != null && t.m_hashcode == hash && t.byteseq(bytes, off, len2)) {
            return t;
        }
        RecentShortStrings.recent_short_strings[bucket] = s = new LuaString(bytes, off, len2);
        return s;
    }

    public static LuaString valueOf(char[] bytes) {
        return LuaString.valueOf(bytes, 0, bytes.length);
    }

    public static LuaString valueOf(char[] bytes, int off, int len2) {
        byte[] b = new byte[len2];
        for (int i = 0; i < len2; ++i) {
            b[i] = (byte)bytes[i + off];
        }
        return LuaString.valueUsing(b, 0, len2);
    }

    public static LuaString valueOf(byte[] bytes) {
        return LuaString.valueOf(bytes, 0, bytes.length);
    }

    public static LuaString valueUsing(byte[] bytes) {
        return LuaString.valueUsing(bytes, 0, bytes.length);
    }

    private LuaString(byte[] bytes, int offset, int length) {
        this.m_bytes = bytes;
        this.m_offset = offset;
        this.m_length = length;
        this.m_hashcode = LuaString.hashCode(bytes, offset, length);
    }

    @Override
    public boolean isstring() {
        return true;
    }

    @Override
    public LuaValue getmetatable() {
        return s_metatable;
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public String typename() {
        return "string";
    }

    @Override
    public String tojstring() {
        return LuaString.decodeAsUtf8(this.m_bytes, this.m_offset, this.m_length);
    }

    @Override
    public LuaValue neg() {
        double d = this.scannumber();
        return Double.isNaN(d) ? super.neg() : LuaString.valueOf(-d);
    }

    @Override
    public LuaValue add(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(ADD, rhs) : rhs.add(d);
    }

    @Override
    public LuaValue add(double rhs) {
        return LuaString.valueOf(this.checkarith() + rhs);
    }

    @Override
    public LuaValue add(int rhs) {
        return LuaString.valueOf(this.checkarith() + (double)rhs);
    }

    @Override
    public LuaValue sub(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(SUB, rhs) : rhs.subFrom(d);
    }

    @Override
    public LuaValue sub(double rhs) {
        return LuaString.valueOf(this.checkarith() - rhs);
    }

    @Override
    public LuaValue sub(int rhs) {
        return LuaString.valueOf(this.checkarith() - (double)rhs);
    }

    @Override
    public LuaValue subFrom(double lhs) {
        return LuaString.valueOf(lhs - this.checkarith());
    }

    @Override
    public LuaValue mul(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(MUL, rhs) : rhs.mul(d);
    }

    @Override
    public LuaValue mul(double rhs) {
        return LuaString.valueOf(this.checkarith() * rhs);
    }

    @Override
    public LuaValue mul(int rhs) {
        return LuaString.valueOf(this.checkarith() * (double)rhs);
    }

    @Override
    public LuaValue pow(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(POW, rhs) : rhs.powWith(d);
    }

    @Override
    public LuaValue pow(double rhs) {
        return MathLib.dpow(this.checkarith(), rhs);
    }

    @Override
    public LuaValue pow(int rhs) {
        return MathLib.dpow(this.checkarith(), rhs);
    }

    @Override
    public LuaValue powWith(double lhs) {
        return MathLib.dpow(lhs, this.checkarith());
    }

    @Override
    public LuaValue powWith(int lhs) {
        return MathLib.dpow(lhs, this.checkarith());
    }

    @Override
    public LuaValue div(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(DIV, rhs) : rhs.divInto(d);
    }

    @Override
    public LuaValue div(double rhs) {
        return LuaDouble.ddiv(this.checkarith(), rhs);
    }

    @Override
    public LuaValue div(int rhs) {
        return LuaDouble.ddiv(this.checkarith(), rhs);
    }

    @Override
    public LuaValue divInto(double lhs) {
        return LuaDouble.ddiv(lhs, this.checkarith());
    }

    @Override
    public LuaValue mod(LuaValue rhs) {
        double d = this.scannumber();
        return Double.isNaN(d) ? this.arithmt(MOD, rhs) : rhs.modFrom(d);
    }

    @Override
    public LuaValue mod(double rhs) {
        return LuaDouble.dmod(this.checkarith(), rhs);
    }

    @Override
    public LuaValue mod(int rhs) {
        return LuaDouble.dmod(this.checkarith(), rhs);
    }

    @Override
    public LuaValue modFrom(double lhs) {
        return LuaDouble.dmod(lhs, this.checkarith());
    }

    @Override
    public LuaValue lt(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) > 0 ? LuaValue.TRUE : FALSE) : super.lt(rhs);
    }

    @Override
    public boolean lt_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) > 0 : super.lt_b(rhs);
    }

    @Override
    public boolean lt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean lt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue lteq(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) >= 0 ? LuaValue.TRUE : FALSE) : super.lteq(rhs);
    }

    @Override
    public boolean lteq_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) >= 0 : super.lteq_b(rhs);
    }

    @Override
    public boolean lteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean lteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue gt(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) < 0 ? LuaValue.TRUE : FALSE) : super.gt(rhs);
    }

    @Override
    public boolean gt_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) < 0 : super.gt_b(rhs);
    }

    @Override
    public boolean gt_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean gt_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue gteq(LuaValue rhs) {
        return rhs.isstring() ? (rhs.strcmp(this) <= 0 ? LuaValue.TRUE : FALSE) : super.gteq(rhs);
    }

    @Override
    public boolean gteq_b(LuaValue rhs) {
        return rhs.isstring() ? rhs.strcmp(this) <= 0 : super.gteq_b(rhs);
    }

    @Override
    public boolean gteq_b(int rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public boolean gteq_b(double rhs) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    @Override
    public LuaValue concat(LuaValue rhs) {
        return rhs.concatTo(this);
    }

    @Override
    public Buffer concat(Buffer rhs) {
        return rhs.concatTo(this);
    }

    @Override
    public LuaValue concatTo(LuaNumber lhs) {
        return this.concatTo(lhs.strvalue());
    }

    @Override
    public LuaValue concatTo(LuaString lhs) {
        byte[] b = new byte[lhs.m_length + this.m_length];
        System.arraycopy(lhs.m_bytes, lhs.m_offset, b, 0, lhs.m_length);
        System.arraycopy(this.m_bytes, this.m_offset, b, lhs.m_length, this.m_length);
        return LuaString.valueUsing(b, 0, b.length);
    }

    @Override
    public int strcmp(LuaValue lhs) {
        return -lhs.strcmp(this);
    }

    @Override
    public int strcmp(LuaString rhs) {
        int i = 0;
        for (int j = 0; i < this.m_length && j < rhs.m_length; ++i, ++j) {
            if (this.m_bytes[this.m_offset + i] == rhs.m_bytes[rhs.m_offset + j]) continue;
            return this.m_bytes[this.m_offset + i] - rhs.m_bytes[rhs.m_offset + j];
        }
        return this.m_length - rhs.m_length;
    }

    private double checkarith() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            this.aritherror();
        }
        return d;
    }

    @Override
    public int checkint() {
        return (int)this.checkdouble();
    }

    @Override
    public LuaInteger checkinteger() {
        return LuaString.valueOf(this.checkint());
    }

    @Override
    public long checklong() {
        return (long)this.checkdouble();
    }

    @Override
    public double checkdouble() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            this.argerror("number");
        }
        return d;
    }

    @Override
    public LuaNumber checknumber() {
        return LuaString.valueOf(this.checkdouble());
    }

    @Override
    public LuaNumber checknumber(String msg) {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            LuaString.error(msg);
        }
        return LuaString.valueOf(d);
    }

    @Override
    public boolean isnumber() {
        double d = this.scannumber();
        return !Double.isNaN(d);
    }

    @Override
    public boolean isint() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            return false;
        }
        int i = (int)d;
        return (double)i == d;
    }

    @Override
    public boolean islong() {
        double d = this.scannumber();
        if (Double.isNaN(d)) {
            return false;
        }
        long l = (long)d;
        return (double)l == d;
    }

    @Override
    public byte tobyte() {
        return (byte)this.toint();
    }

    @Override
    public char tochar() {
        return (char)this.toint();
    }

    @Override
    public double todouble() {
        double d = this.scannumber();
        return Double.isNaN(d) ? 0.0 : d;
    }

    @Override
    public float tofloat() {
        return (float)this.todouble();
    }

    @Override
    public int toint() {
        return (int)this.tolong();
    }

    @Override
    public long tolong() {
        return (long)this.todouble();
    }

    @Override
    public short toshort() {
        return (short)this.toint();
    }

    @Override
    public double optdouble(double defval) {
        return this.checkdouble();
    }

    @Override
    public int optint(int defval) {
        return this.checkint();
    }

    @Override
    public LuaInteger optinteger(LuaInteger defval) {
        return this.checkinteger();
    }

    @Override
    public long optlong(long defval) {
        return this.checklong();
    }

    @Override
    public LuaNumber optnumber(LuaNumber defval) {
        return this.checknumber();
    }

    @Override
    public LuaString optstring(LuaString defval) {
        return this;
    }

    @Override
    public LuaValue tostring() {
        return this;
    }

    @Override
    public String optjstring(String defval) {
        return this.tojstring();
    }

    @Override
    public LuaString strvalue() {
        return this;
    }

    public LuaString substring(int beginIndex, int endIndex) {
        int off = this.m_offset + beginIndex;
        int len2 = endIndex - beginIndex;
        return len2 >= this.m_length / 2 ? LuaString.valueUsing(this.m_bytes, off, len2) : LuaString.valueOf(this.m_bytes, off, len2);
    }

    public int hashCode() {
        return this.m_hashcode;
    }

    public static int hashCode(byte[] bytes, int offset, int length) {
        int h = length;
        int step = (length >> 5) + 1;
        for (int l1 = length; l1 >= step; l1 -= step) {
            h ^= (h << 5) + (h >> 2) + (bytes[offset + l1 - 1] & 0xFF);
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LuaString) {
            return this.raweq((LuaString)o);
        }
        return false;
    }

    @Override
    public LuaValue eq(LuaValue val) {
        return val.raweq(this) ? TRUE : FALSE;
    }

    @Override
    public boolean eq_b(LuaValue val) {
        return val.raweq(this);
    }

    @Override
    public boolean raweq(LuaValue val) {
        return val.raweq(this);
    }

    @Override
    public boolean raweq(LuaString s) {
        if (this == s) {
            return true;
        }
        if (s.m_length != this.m_length) {
            return false;
        }
        if (s.m_bytes == this.m_bytes && s.m_offset == this.m_offset) {
            return true;
        }
        if (s.hashCode() != this.hashCode()) {
            return false;
        }
        for (int i = 0; i < this.m_length; ++i) {
            if (s.m_bytes[s.m_offset + i] == this.m_bytes[this.m_offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(LuaString a, int i, LuaString b, int j, int n) {
        return LuaString.equals(a.m_bytes, a.m_offset + i, b.m_bytes, b.m_offset + j, n);
    }

    private boolean byteseq(byte[] bytes, int off, int len2) {
        return this.m_length == len2 && LuaString.equals(this.m_bytes, this.m_offset, bytes, off, len2);
    }

    public static boolean equals(byte[] a, int i, byte[] b, int j, int n) {
        if (a.length < i + n || b.length < j + n) {
            return false;
        }
        while (--n >= 0) {
            if (a[i++] == b[j++]) continue;
            return false;
        }
        return true;
    }

    public void write(DataOutputStream writer, int i, int len2) throws IOException {
        writer.write(this.m_bytes, this.m_offset + i, len2);
    }

    @Override
    public LuaValue len() {
        return LuaInteger.valueOf(this.m_length);
    }

    @Override
    public int length() {
        return this.m_length;
    }

    @Override
    public int rawlen() {
        return this.m_length;
    }

    public int luaByte(int index) {
        return this.m_bytes[this.m_offset + index] & 0xFF;
    }

    public int charAt(int index) {
        if (index < 0 || index >= this.m_length) {
            throw new IndexOutOfBoundsException();
        }
        return this.luaByte(index);
    }

    @Override
    public String checkjstring() {
        return this.tojstring();
    }

    @Override
    public LuaString checkstring() {
        return this;
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.m_bytes, this.m_offset, this.m_length);
    }

    public void copyInto(int strOffset, byte[] bytes, int arrayOffset, int len2) {
        System.arraycopy(this.m_bytes, this.m_offset + strOffset, bytes, arrayOffset, len2);
    }

    public int indexOfAny(LuaString accept) {
        int ilimit = this.m_offset + this.m_length;
        int jlimit = accept.m_offset + accept.m_length;
        for (int i = this.m_offset; i < ilimit; ++i) {
            for (int j = accept.m_offset; j < jlimit; ++j) {
                if (this.m_bytes[i] != accept.m_bytes[j]) continue;
                return i - this.m_offset;
            }
        }
        return -1;
    }

    public int indexOf(byte b, int start2) {
        for (int i = start2; i < this.m_length; ++i) {
            if (this.m_bytes[this.m_offset + i] != b) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(LuaString s, int start2) {
        int slen = s.length();
        int limit = this.m_length - slen;
        for (int i = start2; i <= limit; ++i) {
            if (!LuaString.equals(this.m_bytes, this.m_offset + i, s.m_bytes, s.m_offset, slen)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(LuaString s) {
        int limit;
        int slen = s.length();
        for (int i = limit = this.m_length - slen; i >= 0; --i) {
            if (!LuaString.equals(this.m_bytes, this.m_offset + i, s.m_bytes, s.m_offset, slen)) continue;
            return i;
        }
        return -1;
    }

    public static String decodeAsUtf8(byte[] bytes, int offset, int length) {
        int i = offset;
        int j = offset + length;
        int n = 0;
        while (i < j) {
            byte v;
            if (((v = bytes[i++]) & 0xC0) == 192) {
                ++i;
                if ((v & 0xE0) == 224) {
                    ++i;
                    if ((v & 0xF0) == 240) {
                        ++i;
                    }
                }
            }
            ++n;
        }
        char[] chars = new char[n];
        i = offset;
        j = offset + length;
        n = 0;
        while (i < j) {
            int b;
            chars[n++] = (char)((b = bytes[i++]) >= 0 || i >= j ? b : (b < -32 || i + 1 >= j ? (b & 0x3F) << 6 | bytes[i++] & 0x3F : (b & 0xF) << 12 | (bytes[i++] & 0x3F) << 6 | bytes[i++] & 0x3F));
        }
        return new String(chars);
    }

    public static int lengthAsUtf8(char[] chars) {
        int b = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < '\u0080' || c >= '\udc00' && c < '\ue000') {
                ++b;
                continue;
            }
            if (c < '\u0800') {
                b += 2;
                continue;
            }
            if (c >= '\ud800' && c < '\udc00') {
                if (i + 1 < chars.length && chars[i + 1] >= '\udc00' && chars[i + 1] < '\ue000') {
                    b += 4;
                    ++i;
                    continue;
                }
                ++b;
                continue;
            }
            b += 3;
        }
        return b;
    }

    public static int encodeToUtf8(char[] chars, int nchars, byte[] bytes, int off) {
        int j = off;
        for (int i = 0; i < nchars; ++i) {
            char c = chars[i];
            if (c < '\u0080') {
                bytes[j++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                bytes[j++] = (byte)(0xC0 | c >> 6);
                bytes[j++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= '\ud800' && c < '\udc00') {
                if (i + 1 < nchars && chars[i + 1] >= '\udc00' && chars[i + 1] < '\ue000') {
                    int uc = 65536 + ((c & 0x3FF) << 10 | chars[++i] & 0x3FF);
                    bytes[j++] = (byte)(0xF0 | uc >> 18);
                    bytes[j++] = (byte)(0x80 | uc >> 12 & 0x3F);
                    bytes[j++] = (byte)(0x80 | uc >> 6 & 0x3F);
                    bytes[j++] = (byte)(0x80 | uc & 0x3F);
                    continue;
                }
                bytes[j++] = 63;
                continue;
            }
            if (c >= '\udc00' && c < '\ue000') {
                bytes[j++] = 63;
                continue;
            }
            bytes[j++] = (byte)(0xE0 | c >> 12);
            bytes[j++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[j++] = (byte)(0x80 | c & 0x3F);
        }
        return j - off;
    }

    public boolean isValidUtf8() {
        int i = this.m_offset;
        int j = this.m_offset + this.m_length;
        while (i < j) {
            byte c;
            if ((c = this.m_bytes[i++]) >= 0 || (c & 0xE0) == 192 && i < j && (this.m_bytes[i++] & 0xC0) == 128 || (c & 0xF0) == 224 && i + 1 < j && (this.m_bytes[i++] & 0xC0) == 128 && (this.m_bytes[i++] & 0xC0) == 128 || (c & 0xF8) == 240 && i + 2 < j && (this.m_bytes[i++] & 0xC0) == 128 && (this.m_bytes[i++] & 0xC0) == 128 && (this.m_bytes[i++] & 0xC0) == 128) continue;
            return false;
        }
        return true;
    }

    @Override
    public LuaValue tonumber() {
        double d = this.scannumber();
        return Double.isNaN(d) ? NIL : LuaString.valueOf(d);
    }

    public LuaValue tonumber(int base) {
        double d = this.scannumber(base);
        return Double.isNaN(d) ? NIL : LuaString.valueOf(d);
    }

    private boolean isspace(byte c) {
        return c == 32 || c >= 9 && c <= 13;
    }

    private boolean isdigit(byte c) {
        return c >= 48 && c <= 57;
    }

    private boolean isxdigit(byte c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private int hexvalue(byte c) {
        return c <= 57 ? c - 48 : (c <= 70 ? c + 10 - 65 : c + 10 - 97);
    }

    public double scannumber() {
        int i;
        int j = this.m_offset + this.m_length;
        for (i = this.m_offset; i < j && this.isspace(this.m_bytes[i]); ++i) {
        }
        while (i < j && this.isspace(this.m_bytes[j - 1])) {
            --j;
        }
        if (i >= j) {
            return Double.NaN;
        }
        if (this.indexOf((byte)120, i - this.m_offset) != -1 || this.indexOf((byte)88, i - this.m_offset) != -1) {
            return this.strx2number(i, j);
        }
        return this.scandouble(i, j);
    }

    private double strx2number(int start2, int end) {
        double sgn;
        double d = sgn = this.m_bytes[start2] == 45 ? -1.0 : 1.0;
        if (sgn == -1.0 || this.m_bytes[start2] == 43) {
            ++start2;
        }
        if (start2 + 2 >= end) {
            return Double.NaN;
        }
        if (this.m_bytes[start2++] != 48) {
            return Double.NaN;
        }
        if (this.m_bytes[start2] != 120 && this.m_bytes[start2] != 88) {
            return Double.NaN;
        }
        double m = 0.0;
        int e = 0;
        boolean i = this.isxdigit(this.m_bytes[++start2]);
        while (start2 < end && this.isxdigit(this.m_bytes[start2])) {
            m = m * 16.0 + (double)this.hexvalue(this.m_bytes[start2++]);
        }
        if (start2 < end && this.m_bytes[start2] == 46) {
            ++start2;
            while (start2 < end && this.isxdigit(this.m_bytes[start2])) {
                m = m * 16.0 + (double)this.hexvalue(this.m_bytes[start2++]);
                e -= 4;
            }
        }
        if (!i && e == 0) {
            return Double.NaN;
        }
        if (start2 < end && (this.m_bytes[start2] == 112 || this.m_bytes[start2] == 80)) {
            int exp1 = 0;
            boolean neg1 = false;
            if (++start2 < end) {
                if (this.m_bytes[start2] == 45) {
                    neg1 = true;
                }
                if (neg1 || this.m_bytes[start2] == 43) {
                    ++start2;
                }
            }
            if (start2 >= end || !this.isdigit(this.m_bytes[start2])) {
                return Double.NaN;
            }
            while (start2 < end && this.isdigit(this.m_bytes[start2])) {
                exp1 = exp1 * 10 + this.m_bytes[start2++] - 48;
            }
            if (neg1) {
                exp1 = -exp1;
            }
            e += exp1;
        }
        if (start2 != end) {
            return Double.NaN;
        }
        return sgn * m * MathLib.dpow_d(2.0, e);
    }

    public double scannumber(int base) {
        int i;
        if (base < 2 || base > 36) {
            return Double.NaN;
        }
        int j = this.m_offset + this.m_length;
        for (i = this.m_offset; i < j && this.isspace(this.m_bytes[i]); ++i) {
        }
        while (i < j && this.isspace(this.m_bytes[j - 1])) {
            --j;
        }
        if (i >= j) {
            return Double.NaN;
        }
        return this.scanlong(base, i, j);
    }

    private double scanlong(int base, int start2, int end) {
        boolean neg;
        long x = 0L;
        boolean bl = neg = this.m_bytes[start2] == 45;
        if (neg || this.m_bytes[start2] == 43) {
            ++start2;
        }
        for (int i = start2; i < end; ++i) {
            int digit = this.m_bytes[i] - (base <= 10 || this.m_bytes[i] >= 48 && this.m_bytes[i] <= 57 ? 48 : (this.m_bytes[i] >= 65 && this.m_bytes[i] <= 90 ? 55 : 87));
            if (digit < 0 || digit >= base) {
                return Double.NaN;
            }
            if ((x = x * (long)base + (long)digit) >= 0L) continue;
            return Double.NaN;
        }
        return neg ? (double)(-x) : (double)x;
    }

    private double scandouble(int start2, int end) {
        if (end > start2 + 64) {
            end = start2 + 64;
        }
        block5: for (int i = start2; i < end; ++i) {
            switch (this.m_bytes[i]) {
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: 
                case 101: {
                    continue block5;
                }
                default: {
                    return Double.NaN;
                }
            }
        }
        char[] c = new char[end - start2];
        for (int i = start2; i < end; ++i) {
            c[i - start2] = (char)this.m_bytes[i];
        }
        try {
            return Double.parseDouble(new String(c));
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public void printToStream(PrintStream ps) {
        int n = this.m_length;
        for (int i = 0; i < n; ++i) {
            byte c = this.m_bytes[this.m_offset + i];
            ps.print((char)c);
        }
    }

    private static final class RecentShortStrings {
        private static final LuaString[] recent_short_strings = new LuaString[128];

        private RecentShortStrings() {
        }
    }
}

