/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.common.tileentity;

import bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.SimpleShutDownReason;
import gtnhlanth.common.beamline.BeamInformation;
import gtnhlanth.common.beamline.BeamLinePacket;
import gtnhlanth.common.beamline.Particle;
import gtnhlanth.common.hatch.MTEHatchInputBeamline;
import gtnhlanth.common.hatch.MTEHatchOutputBeamline;
import gtnhlanth.common.register.LanthItemList;
import gtnhlanth.common.tileentity.recipe.beamline.BeamlineRecipeLoader;
import gtnhlanth.util.DescTextLocalization;
import gtnhlanth.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MTELINAC
extends MTEEnhancedMultiBlockBase<MTELINAC>
implements ISurvivalConstructable {
    private static final IStructureDefinition<MTELINAC> STRUCTURE_DEFINITION;
    protected static final String STRUCTURE_PIECE_BASE = "base";
    protected static final String STRUCTURE_PIECE_LAYER = "layer";
    protected static final String STRUCTURE_PIECE_END = "end";
    private byte glassTier;
    private boolean onEndInnerLayer = false;
    private int machineTemp = 0;
    private final ArrayList<MTEHatchInputBeamline> mInputBeamline = new ArrayList();
    private final ArrayList<MTEHatchOutputBeamline> mOutputBeamline = new ArrayList();
    private static final int CASING_INDEX;
    private static final byte MIN_GLASS_TIER = 6;
    private float outputEnergy;
    private int outputRate;
    private int outputParticle;
    private float outputFocus;
    private int length;

    public MTELINAC(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public MTELINAC(String name) {
        super(name);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity te) {
        return new MTELINAC(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Particle Accelerator").addInfo("Controller block for the LINAC").addInfo("Accelerates charged particles to higher energies").addInfo("Increasing length increases output energy, but decreases focus").addInfo("Use a lower temperature coolant to improve output focus").addInfo("Output energy does not scale for input energies higher than 7500 keV").addInfo(DescTextLocalization.BEAMLINE_SCANNER_INFO).addInfo("Valid Coolants:");
        for (String fluidName : BeamlineRecipeLoader.coolantMap.keySet()) {
            tt.addInfo("- " + FluidRegistry.getFluid((String)fluidName).getLocalizedName(null));
        }
        tt.addInfo("Requires (length + 1)kL/s of coolant").beginVariableStructureBlock(7, 7, 7, 7, 19, 83, false).addController("Front bottom").addCasingInfoRange(LanthItemList.SHIELDED_ACCELERATOR_CASING.func_149732_F(), 325, 1285, false).addCasingInfoRange(LanthItemList.COOLANT_DELIVERY_CASING.func_149732_F(), 148, 852, false).addCasingInfoRange(LanthItemList.SHIELDED_ACCELERATOR_GLASS.func_149732_F(), 127, 703, false).addCasingInfoRange("Superconducting Coil Block", 56, 312, false).addCasingInfoRange(LanthItemList.ELECTRODE_CASING.func_149732_F(), 156, 732, false).addCasingInfoExactly("Grate Machine Casing", 47, false).addCasingInfoExactly("Borosilicate Glass (LuV+)", 48, false).addEnergyHatch(DescTextLocalization.addDotText(1)).addMaintenanceHatch(DescTextLocalization.addDotText(1)).addInputHatch(DescTextLocalization.addDotText(2)).addOutputHatch(DescTextLocalization.addDotText(2)).addOtherStructurePart("Beamline Input Hatch", DescTextLocalization.addDotText(3)).addOtherStructurePart("Beamline Output Hatch", DescTextLocalization.addDotText(4)).toolTipFinisher(new String[0]);
        return tt;
    }

    private boolean addBeamLineInputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEHatchInputBeamline) {
            return this.mInputBeamline.add((MTEHatchInputBeamline)mte);
        }
        return false;
    }

    private boolean addBeamLineOutputHatch(IGregTechTileEntity te, int casingIndex) {
        if (te == null) {
            return false;
        }
        IMetaTileEntity mte = te.getMetaTileEntity();
        if (mte == null) {
            return false;
        }
        if (mte instanceof MTEHatchOutputBeamline) {
            return this.mOutputBeamline.add((MTEHatchOutputBeamline)mte);
        }
        return false;
    }

    @Override
    public boolean checkRecipe(ItemStack itemStack) {
        float tempFactor = 0.0f;
        float machineFocus = 0.0f;
        float inputFocus = 0.0f;
        this.outputFocus = 0.0f;
        float voltageFactor = 0.0f;
        float inputEnergy = 0.0f;
        this.machineTemp = 0;
        float machineEnergy = 0.0f;
        this.outputEnergy = 0.0f;
        int particleId = 0;
        this.outputParticle = 0;
        int inputRate = 0;
        this.outputRate = 0;
        ArrayList<FluidStack> tFluidInputs = this.getStoredFluids();
        if (tFluidInputs.isEmpty()) {
            this.doRandomMaintenanceDamage();
            this.stopMachine(SimpleShutDownReason.ofCritical("gtnhlanth.nocoolant"));
            return false;
        }
        FluidStack primFluid = tFluidInputs.get(0);
        int fluidConsumed = 1000 * this.length;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.getInputInformation() == null) {
            return false;
        }
        if (this.getInputInformation().getEnergy() == 0.0f) {
            return false;
        }
        particleId = this.getInputInformation().getParticleId();
        Particle inputParticle = Particle.getParticleFromId(particleId);
        if (!inputParticle.canAccelerate()) {
            this.stopMachine(SimpleShutDownReason.ofCritical("gtnhlanth.noaccel"));
            return false;
        }
        this.mMaxProgresstime = 20;
        this.mEUt = (int)(-GTValues.VP[(int)this.getInputVoltageTier()]);
        this.outputParticle = particleId;
        if (primFluid.isFluidEqual(new FluidStack(FluidRegistry.getFluid((String)"ic2coolant"), 1))) {
            tempFactor = MTELINAC.calculateTemperatureFactor(60);
            this.machineTemp = 60;
        } else {
            tempFactor = MTELINAC.calculateTemperatureFactor(primFluid.getFluid().getTemperature());
            this.machineTemp = primFluid.getFluid().getTemperature();
        }
        machineFocus = Math.max(-0.9f * (float)this.length * tempFactor + 110.0f, 5.0f);
        if (machineFocus > 90.0f) {
            machineFocus = 90.0f;
        }
        this.outputFocus = (inputFocus = this.getInputInformation().getFocus()) > machineFocus ? (inputFocus + machineFocus) / 2.0f : inputFocus * (machineFocus / 100.0f);
        long voltage = this.getMaxInputVoltage();
        machineEnergy = (float)Math.max((double)(this.length / 4) * Math.pow(voltage, 0.3333333333333333), 50.0);
        inputEnergy = this.getInputInformation().getEnergy();
        inputEnergy = Math.min(inputEnergy, 7500.0f);
        this.outputEnergy = (float)Math.pow(10.0, 1.0f + inputEnergy / Particle.getParticleFromId(this.outputParticle).maxSourceEnergy()) * machineEnergy;
        this.outputRate = inputRate = this.getInputInformation().getRate();
        if (Util.coolantFluidCheck(primFluid, fluidConsumed)) {
            this.stopMachine(SimpleShutDownReason.ofCritical("gtnhlanth.inscoolant"));
            return false;
        }
        primFluid.amount -= fluidConsumed;
        Fluid fluidOutput = BeamlineRecipeLoader.coolantMap.get(primFluid.getFluid().getName());
        if (Objects.isNull(fluidOutput)) {
            return false;
        }
        FluidStack fluidOutputStack = new FluidStack(fluidOutput, fluidConsumed);
        if (Objects.isNull(fluidOutputStack)) {
            return false;
        }
        this.addFluidOutputs(new FluidStack[]{fluidOutputStack});
        this.outputAfterRecipe();
        return true;
    }

    private void outputAfterRecipe() {
        if (!this.mOutputBeamline.isEmpty()) {
            BeamLinePacket packet = new BeamLinePacket(new BeamInformation(this.outputEnergy, this.outputRate, this.outputParticle, this.outputFocus));
            for (MTEHatchOutputBeamline o : this.mOutputBeamline) {
                o.q = packet;
            }
        }
    }

    @Override
    public void stopMachine() {
        this.outputFocus = 0.0f;
        this.outputEnergy = 0.0f;
        this.outputParticle = 0;
        this.outputRate = 0;
        this.machineTemp = 0;
        super.stopMachine();
    }

    @Override
    public void stopMachine(ShutDownReason reason) {
        this.outputFocus = 0.0f;
        this.outputEnergy = 0.0f;
        this.outputParticle = 0;
        this.outputRate = 0;
        this.machineTemp = 0;
        super.stopMachine(reason);
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (MTEHatchEnergy tHatch : this.mEnergyHatches) {
            if (!tHatch.isValid()) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        BeamInformation information = this.getInputInformation();
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GTUtility.formatNumbers(this.getActualEnergyUsage()) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.info") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.temperature") + ": " + EnumChatFormatting.DARK_RED + this.machineTemp + EnumChatFormatting.RESET + " K", StatCollector.func_74838_a((String)"beamline.coolusage") + ": " + EnumChatFormatting.AQUA + this.length + EnumChatFormatting.RESET + " kL/s", EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.in_pre") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.particle") + ": " + EnumChatFormatting.GOLD + Particle.getParticleFromId(information.getParticleId()).getLocalisedName() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.energy") + ": " + EnumChatFormatting.DARK_RED + information.getEnergy() + EnumChatFormatting.RESET + " keV", StatCollector.func_74838_a((String)"beamline.focus") + ": " + EnumChatFormatting.BLUE + information.getFocus() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.amount") + ": " + EnumChatFormatting.LIGHT_PURPLE + information.getRate(), EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"beamline.out_pre") + ": " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.particle") + ": " + EnumChatFormatting.GOLD + Particle.getParticleFromId(this.outputParticle).getLocalisedName() + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.energy") + ": " + EnumChatFormatting.DARK_RED + this.outputEnergy + EnumChatFormatting.RESET + " keV", StatCollector.func_74838_a((String)"beamline.focus") + ": " + EnumChatFormatting.BLUE + this.outputFocus + " " + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"beamline.amount") + ": " + EnumChatFormatting.LIGHT_PURPLE + this.outputRate};
    }

    private BeamInformation getInputInformation() {
        Iterator<MTEHatchInputBeamline> iterator = this.mInputBeamline.iterator();
        if (iterator.hasNext()) {
            MTEHatchInputBeamline in = iterator.next();
            if (in.q == null) {
                return new BeamInformation(0.0f, 0, 0, 0.0f);
            }
            return (BeamInformation)((BeamLinePacket)in.q).getContent();
        }
        return null;
    }

    private static float calculateTemperatureFactor(int fluidTemp) {
        return (float)Math.pow(1.1, 0.2 * (double)fluidTemp);
    }

    @Override
    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("LINAC.hint", 11);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity mte, ItemStack stack) {
        this.mInputBeamline.clear();
        this.mOutputBeamline.clear();
        this.outputEnergy = 0.0f;
        this.outputRate = 0;
        this.outputParticle = 0;
        this.outputFocus = 0.0f;
        this.glassTier = 0;
        this.onEndInnerLayer = false;
        this.length = 8;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 3, 6, 0)) {
            return false;
        }
        while (this.length < 128) {
            if (!this.checkPiece(STRUCTURE_PIECE_LAYER, 3, 6, -this.length)) {
                if (this.checkPiece(STRUCTURE_PIECE_END, 3, 6, -this.length)) break;
                return false;
            }
            this.length += 2;
        }
        this.length += 8;
        return this.mInputBeamline.size() == 1 && this.mOutputBeamline.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mEnergyHatches.size() <= 2 && this.glassTier >= 6;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 3, 6, 0);
        int lLength = Math.max(stackSize.field_77994_a + 7, 8);
        if (lLength % 2 != 0) {
            ++lLength;
        }
        for (int i = -8; i > -lLength - 1; i -= 2) {
            this.buildPiece(STRUCTURE_PIECE_LAYER, stackSize, hintsOnly, 3, 6, i);
        }
        this.buildPiece(STRUCTURE_PIECE_END, stackSize, hintsOnly, 3, 6, -(lLength + 2));
        StructureLib.addClientSideChatMessages((String[])new String[]{"Length: " + (11 + lLength) + " blocks."});
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        elementBudget = 200;
        if (this.mMachine) {
            return -1;
        }
        int build = 0;
        build = this.survivialBuildPiece(STRUCTURE_PIECE_BASE, stackSize, 3, 6, 0, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        int lLength = Math.max(stackSize.field_77994_a + 7, 8);
        if (lLength % 2 != 0) {
            ++lLength;
        }
        for (int i = -8; i > -lLength - 1; i -= 2) {
            build = this.survivialBuildPiece(STRUCTURE_PIECE_LAYER, stackSize, 3, 6, i, elementBudget, env, false, true);
            if (build < 0) continue;
            return build;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_END, stackSize, 3, 6, -(lLength + 2), elementBudget, env, false, true);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean active, boolean aRedstone) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47]};
    }

    @Override
    public IStructureDefinition<MTELINAC> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean addInputHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        this.onEndInnerLayer = true;
        return super.addInputHatchToMachineList(aTileEntity, aBaseCasingIndex);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    static {
        CASING_INDEX = GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings5, 14);
        STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_BASE, (String[][])new String[][]{{"ggggggg", "gbbbbbg", "gbbbbbg", "gbbibbg", "gbbbbbg", "gbbbbbg", "ggg~ggg"}, {"ggggggg", "gcccccg", "gcccccg", "gcc-ccg", "gcccccg", "gcccccg", "ggggggg"}, {"ccccccc", "cvvvvvc", "kvvvvvk", "kvv-vvk", "kvvvvvk", "cvvvvvc", "jcccccj"}, {"cckkkcc", "cdddddc", "kdyyydk", "kdy-ydk", "kdyyydk", "cdddddc", "jcccccj"}, {"cckkkcc", "cdvvvdc", "kvvvvvk", "kdv-vdk", "kvvvvvk", "cdvvvdc", "jcccccj"}, {"cckkkcc", "cdddddc", "kdyyydk", "kdy-ydk", "kdyyydk", "cdddddc", "jcccccj"}, {"cckkkcc", "cdvvvdc", "kvvvvvk", "kdv-vdk", "kvvvvvk", "cdvvvdc", "jcccccj"}, {"cckhkcc", "cdddddc", "kdyyydk", "kdy-ydk", "kdyyydk", "cdddddc", "jcccccj"}}).addShape(STRUCTURE_PIECE_LAYER, (String[][])new String[][]{{"cckkkcc", "cdvvvdc", "kvvvvvk", "kdv-vdk", "kvvvvvk", "cdvvvdc", "ccccccc"}, {"cckkkcc", "cdddddc", "kdyyydk", "kdy-ydk", "kdyyydk", "cdddddc", "ccccccc"}}).addShape(STRUCTURE_PIECE_END, (String[][])new String[][]{{"cckkkcc", "cdvvvdc", "kvvvvvk", "kdv-vdk", "kvvvvvk", "cdvvvdc", "ccccccc"}, {"cckhkcc", "cdddddc", "kdyyydk", "kdy-ydk", "kdyyydk", "cdddddc", "ccccccc"}, {"cckkkcc", "cdvvvdc", "kvvvvvk", "kdv-vdk", "kvvvvvk", "cdvvvdc", "ccccccc"}, {"cckkkcc", "cdddddc", "kdyyydk", "kdy-ydk", "kdyyydk", "cdddddc", "ccccccc"}, {"cckkkcc", "cdvvvdc", "kvvvvvk", "kdv-vdk", "kvvvvvk", "cdvvvdc", "ccccccc"}, {"cckkkcc", "cdddddc", "kdyyydk", "kdy-ydk", "kdyyydk", "cdddddc", "ccccccc"}, {"ccccccc", "cvvvvvc", "kvvvvvk", "kvv-vvk", "kvvvvvk", "cvvvvvc", "ccccccc"}, {"ccccccc", "ccccccc", "ccccccc", "ccc-ccc", "ccccccc", "ccccccc", "ccccccc"}, {"ccccccc", "cbbbbbc", "cbbbbbc", "cbbobbc", "cbbbbbc", "cbbbbbc", "ccccccc"}}).addElement('c', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_CASING, (int)0)).addElement('g', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10)).addElement('b', BorosilicateGlass.ofBoroGlass((byte)0, (byte)6, (byte)127, (te, t) -> {
            te.glassTier = t;
        }, te -> te.glassTier)).addElement('i', GTStructureUtility.buildHatchAdder(MTELINAC.class).hatchClass(MTEHatchInputBeamline.class).casingIndex(CASING_INDEX).dot(3).adder(MTELINAC::addBeamLineInputHatch).build()).addElement('o', GTStructureUtility.buildHatchAdder(MTELINAC.class).hatchClass(MTEHatchOutputBeamline.class).casingIndex(CASING_INDEX).dot(4).adder(MTELINAC::addBeamLineOutputHatch).build()).addElement('v', StructureUtility.ofBlock((Block)LanthItemList.ELECTRODE_CASING, (int)0)).addElement('k', StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_GLASS, (int)0)).addElement('d', StructureUtility.ofBlock((Block)LanthItemList.COOLANT_DELIVERY_CASING, (int)0)).addElement('y', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)15)).addElement('h', GTStructureUtility.buildHatchAdder(MTELINAC.class).atLeast(HatchElement.InputHatch, HatchElement.OutputHatch).casingIndex(CASING_INDEX).dot(2).build()).addElement('j', GTStructureUtility.buildHatchAdder(MTELINAC.class).atLeast(HatchElement.Maintenance, HatchElement.Energy).casingIndex(CASING_INDEX).dot(1).buildAndChain(StructureUtility.ofBlock((Block)LanthItemList.SHIELDED_ACCELERATOR_CASING, (int)0))).build();
    }
}

