/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.general;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityInfiniteFluid
extends TileEntity
implements IFluidHandler {
    public FluidTank tank = new FluidTank(Integer.MAX_VALUE);
    private boolean needsUpdate = false;
    private int updateTimer = 0;

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        this.needsUpdate = true;
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        this.needsUpdate = true;
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        this.needsUpdate = true;
        FluidStack fluid = this.tank.getFluid();
        if (fluid == null) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0) {
                fluid = null;
            }
            FluidEvent.fireEvent((FluidEvent)new FluidEvent.FluidDrainingEvent(fluid, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, (IFluidTank)this.tank, 0));
        }
        return stack;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public float getAdjustedVolume() {
        this.needsUpdate = true;
        float amount = this.tank.getFluidAmount();
        float capacity = this.tank.getCapacity();
        return amount / capacity * 0.8f;
    }

    public void func_145845_h() {
        FluidStack bigStorage;
        if (this.tank.getFluid() != null) {
            bigStorage = this.tank.getFluid();
            bigStorage.amount = this.tank.getCapacity();
            this.tank.setFluid(bigStorage);
        }
        if (this.needsUpdate) {
            if (this.tank.getFluid() != null) {
                bigStorage = this.tank.getFluid();
                bigStorage.amount = this.tank.getCapacity();
                this.tank.setFluid(bigStorage);
            }
            if (this.updateTimer == 0) {
                this.updateTimer = 10;
            } else {
                --this.updateTimer;
                if (this.updateTimer == 0) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.needsUpdate = false;
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.tank.readFromNBT(tag);
        super.func_145839_a(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        super.func_145841_b(tag);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }
}

