/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multitileentity.multiblock.base;

import gregtech.api.multitileentity.WeakTargetRef;
import gregtech.api.multitileentity.interfaces.IMultiBlockController;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class WallShareablePart
extends MultiBlockPart {
    protected List<WeakTargetRef<IMultiBlockController>> targets = new ArrayList<WeakTargetRef<IMultiBlockController>>();

    @Override
    public void setTarget(IMultiBlockController newController, int allowedModes) {
        if (!this.targets.isEmpty()) {
            this.allowedModes = 0;
            this.setMode(0);
            this.controller.invalidate();
        } else {
            this.allowedModes = allowedModes;
            this.controller.setTarget(newController);
        }
        if (newController == null) {
            return;
        }
        this.targets.add(new WeakTargetRef<Class<IMultiBlockController>>(IMultiBlockController.class, true));
    }

    @Override
    public UUID getLockedInventory() {
        if (this.targets.size() > 1) {
            return null;
        }
        return super.getLockedInventory();
    }

    @Override
    public IMultiBlockController getTarget(boolean aCheckValidity) {
        if (this.targets.size() != 1) {
            return null;
        }
        this.controller.setTarget(this.targets.get(0).get());
        return super.getTarget(aCheckValidity);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multiTileEntity.casing.wallSharable";
    }

    @Override
    public boolean onBlockBroken() {
        for (WeakTargetRef<IMultiBlockController> tar : this.targets) {
            IMultiBlockController target = this.getTarget(tar.getPosition(), false);
            if (target == null) continue;
            target.onStructureChange();
        }
        return false;
    }

    @Override
    public void onBlockAdded() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity te = this.getTileEntityAtSide(side);
            if (te instanceof MultiBlockPart) {
                MultiBlockPart part = (MultiBlockPart)te;
                IMultiBlockController tController = part.getTarget(false);
                if (tController == null) continue;
                tController.onStructureChange();
                continue;
            }
            if (!(te instanceof IMultiBlockController)) continue;
            IMultiBlockController tController = (IMultiBlockController)te;
            tController.onStructureChange();
        }
    }

    public IMultiBlockController getTarget(ChunkCoordinates coordinates, boolean aCheckValidity) {
        TileEntity te;
        IMultiBlockController target = null;
        if (coordinates == null) {
            return null;
        }
        if (this.field_145850_b.func_72899_e(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c) && (te = this.field_145850_b.func_147438_o(coordinates.field_71574_a, coordinates.field_71572_b, coordinates.field_71573_c)) instanceof IMultiBlockController) {
            target = (IMultiBlockController)te;
        }
        if (aCheckValidity) {
            return target != null && target.checkStructure(false) ? target : null;
        }
        return target;
    }
}

