/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.netherportalfix;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;

public class BetterTeleporter
extends Teleporter {
    private static final int PORTAL_RANGE_SQR = 9;
    private static final String NBT_RETURN_PORTALS = "ReturnPortals";
    private static final String NBT_FROM_X = "FromX";
    private static final String NBT_FROM_Y = "FromY";
    private static final String NBT_FROM_Z = "FromZ";
    private static final String NBT_FROM_DIM = "FromDim";
    private static final String NBT_TO_X = "ToX";
    private static final String NBT_TO_Y = "ToY";
    private static final String NBT_TO_Z = "ToZ";
    private static final String NBT_TO_DIM = "ToDim";
    private final WorldServer world;

    public BetterTeleporter(WorldServer world) {
        super(world);
        this.world = world;
    }

    public void func_77185_a(Entity entity, double oldX, double oldY, double oldZ, float rotationYaw) {
        if (entity instanceof EntityPlayer) {
            PortalPositionAndDimension from = new PortalPositionAndDimension((int)oldX, (int)oldY, (int)oldZ);
            super.func_77185_a(entity, oldX, oldY, oldZ, rotationYaw);
            PortalPositionAndDimension to = new PortalPositionAndDimension(((EntityPlayer)entity).func_82114_b());
            NBTTagCompound tagCompound = entity.getEntityData().func_74775_l("PlayerPersisted");
            NBTTagList tagList = tagCompound.func_150295_c(NBT_RETURN_PORTALS, 10);
            for (int i = tagList.func_74745_c() - 1; i >= 0; --i) {
                NBTTagCompound portalCompound = tagList.func_150305_b(i);
                int toX = portalCompound.func_74762_e(NBT_TO_X);
                int toY = portalCompound.func_74762_e(NBT_TO_Y);
                int toZ = portalCompound.func_74762_e(NBT_TO_Z);
                PortalPositionAndDimension testTo = new PortalPositionAndDimension(toX, toY, toZ, portalCompound.func_74762_e(NBT_TO_DIM));
                if (testTo.dimensionId != entity.field_70170_p.field_73011_w.field_76574_g || !(testTo.func_82371_e((ChunkCoordinates)to) <= 9.0f)) continue;
                tagList.func_74744_a(i);
            }
            NBTTagCompound portalCompound = new NBTTagCompound();
            portalCompound.func_74768_a(NBT_FROM_X, from.field_71574_a);
            portalCompound.func_74768_a(NBT_FROM_Y, from.field_71572_b);
            portalCompound.func_74768_a(NBT_FROM_Z, from.field_71573_c);
            portalCompound.func_74768_a(NBT_FROM_DIM, from.dimensionId);
            portalCompound.func_74768_a(NBT_TO_X, to.field_71574_a);
            portalCompound.func_74768_a(NBT_TO_Y, to.field_71572_b);
            portalCompound.func_74768_a(NBT_TO_Z, to.field_71573_c);
            portalCompound.func_74768_a(NBT_TO_DIM, to.dimensionId);
            tagList.func_74742_a((NBTBase)portalCompound);
            tagCompound.func_74782_a(NBT_RETURN_PORTALS, (NBTBase)tagList);
            entity.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tagCompound);
        } else {
            super.func_77185_a(entity, oldX, oldY, oldZ, rotationYaw);
        }
    }

    public boolean func_77184_b(Entity entity, double oldX, double oldY, double oldZ, float rotationYaw) {
        if (entity instanceof EntityPlayer) {
            NBTTagCompound tagCompound = entity.getEntityData().func_74775_l("PlayerPersisted");
            NBTTagList tagList = tagCompound.func_150295_c(NBT_RETURN_PORTALS, 10);
            for (int i = tagList.func_74745_c() - 1; i >= 0; --i) {
                NBTTagCompound portalCompound = tagList.func_150305_b(i);
                int toX = portalCompound.func_74762_e(NBT_TO_X);
                int toY = portalCompound.func_74762_e(NBT_TO_Y);
                int toZ = portalCompound.func_74762_e(NBT_TO_Z);
                PortalPositionAndDimension to = new PortalPositionAndDimension(toX, toY, toZ, portalCompound.func_74762_e(NBT_TO_DIM));
                Teleporter.PortalPosition lastPortalPosition = new Teleporter.PortalPosition((Teleporter)this, (int)oldX, (int)oldY, (int)oldZ, this.world.func_82737_E());
                if (to.dimensionId != entity.field_70170_p.field_73011_w.field_76574_g || !(to.func_82371_e((ChunkCoordinates)lastPortalPosition) <= 9.0f)) continue;
                int x = MathHelper.func_76128_c((double)entity.field_70165_t);
                int y = MathHelper.func_76128_c((double)entity.field_70161_v);
                long key = ChunkCoordIntPair.func_77272_a((int)x, (int)y);
                Teleporter.PortalPosition oldValue = (Teleporter.PortalPosition)this.field_85191_c.func_76164_a(key);
                int fromX = portalCompound.func_74762_e(NBT_FROM_X);
                int fromY = portalCompound.func_74762_e(NBT_FROM_Y);
                int fromZ = portalCompound.func_74762_e(NBT_FROM_Z);
                PortalPositionAndDimension from = new PortalPositionAndDimension(fromX, fromY, fromZ, portalCompound.func_74762_e(NBT_FROM_DIM));
                this.field_85191_c.func_76163_a(key, (Object)from);
                if (!this.field_85190_d.contains(key)) {
                    this.field_85190_d.add(key);
                }
                boolean result = super.func_77184_b(entity, oldX, oldY, oldZ, rotationYaw);
                if (oldValue != null) {
                    this.field_85191_c.func_76163_a(key, (Object)oldValue);
                }
                tagList.func_74744_a(i);
                tagCompound.func_74782_a(NBT_RETURN_PORTALS, (NBTBase)tagList);
                entity.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tagCompound);
                return result;
            }
        }
        return super.func_77184_b(entity, oldX, oldY, oldZ, rotationYaw);
    }

    public class PortalPositionAndDimension
    extends Teleporter.PortalPosition {
        public final int dimensionId;

        public PortalPositionAndDimension(ChunkCoordinates pos) {
            this(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c, ((BetterTeleporter)this$0).world.field_73011_w.field_76574_g);
        }

        public PortalPositionAndDimension(int x, int y, int z) {
            this(x, y, z, ((BetterTeleporter)this$0).world.field_73011_w.field_76574_g);
        }

        public PortalPositionAndDimension(int x, int y, int z, int dimensionId) {
            super((Teleporter)BetterTeleporter.this, x, y, z, BetterTeleporter.this.world.func_72820_D());
            this.dimensionId = dimensionId;
        }
    }
}

