/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.tileentity;

import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.energy.EnergyValues;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.savedata.types.EnergySavefile;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityAbstractTable;
import chylex.hee.tileentity.TileEntityEnergyCluster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntityExtractionTable
extends TileEntityAbstractTable {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsSides = new int[]{1, 2};
    private static final float maxStoredEnergy = 1.8f;
    private byte leakTimer = (byte)100;

    @Override
    protected float getDrainAmount() {
        return this.time < 1000 ? 0.03f : 0.0f;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.leakTimer < 0 || (this.leakTimer = (byte)(this.leakTimer - (this.items[2] == null || this.items[2].func_77973_b() != ItemList.instability_orb ? 16 : Math.max(0, 16 - this.items[2].field_77994_a)))) < 0) {
            this.leakTimer = (byte)100;
            if (this.storedEnergy >= 1.0E-4f) {
                float release = 0.0095999995f + (float)Math.sqrt(this.storedEnergy) * 0.005f;
                this.storedEnergy = Math.max(this.storedEnergy - release, 0.0f);
                ArrayList<TileEntityEnergyCluster> clusters = new ArrayList<TileEntityEnergyCluster>();
                int chunkX = this.field_145851_c >> 4;
                int chunkZ = this.field_145849_e >> 4;
                for (int a = 0; a < 9; ++a) {
                    Map tiles = this.field_145850_b.func_72964_e((int)(chunkX + TileEntityExtractionTable.chunkOffX[a]), (int)(chunkZ + TileEntityExtractionTable.chunkOffZ[a])).field_150816_i;
                    int cx = chunkX * 16 + chunkOffX[a] * 16;
                    int cz = chunkZ * 16 + chunkOffZ[a] * 16;
                    for (Map.Entry entry : tiles.entrySet()) {
                        ChunkPosition pos = (ChunkPosition)entry.getKey();
                        if (((TileEntity)entry.getValue()).getClass() != TileEntityEnergyCluster.class || !(MathUtil.distance(cx + pos.field_151329_a - this.field_145851_c, pos.field_151327_b - this.field_145848_d, cz + pos.field_151328_c - this.field_145849_e) <= 16.0)) continue;
                        clusters.add((TileEntityEnergyCluster)((Object)entry.getValue()));
                    }
                }
                if (!clusters.isEmpty()) {
                    Collections.shuffle(clusters);
                    Iterator iter = clusters.iterator();
                    while (iter.hasNext()) {
                        float f;
                        release = ((TileEntityEnergyCluster)((Object)iter.next())).addEnergy(release, this);
                        if (!(f < 1.0E-4f)) continue;
                    }
                }
                if (release >= 1.0E-4f && this.field_145850_b.field_73011_w.field_76574_g == 1) {
                    release = ((EnergySavefile)WorldDataHandler.get(EnergySavefile.class)).getFromBlockCoords(this.field_145850_b, this.field_145851_c, this.field_145849_e, true).addEnergy(release);
                }
                if (release >= 1.0E-4f) {
                    BlockPosM tmpPos = BlockPosM.tmp();
                    int placed = 0;
                    for (int attempt = 0; attempt < 8 && placed < 4; ++attempt) {
                        tmpPos.set(this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(7) - 3, this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(7) - 3, this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(7) - 3);
                        if (!tmpPos.isAir(this.field_145850_b)) continue;
                        tmpPos.setBlock(this.field_145850_b, BlockList.corrupted_energy_low, 3 + MathUtil.floor(release * 4.5f));
                        ++placed;
                    }
                }
            }
        }
    }

    @Override
    public void invalidateInventory() {
        float energy;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.requiredStardust == 0 || this.items[0] == null) {
            this.resetTable();
        }
        if (this.items[0] != null && (energy = EnergyValues.getItemEnergy(this.items[0])) > 0.0f) {
            this.requiredStardust = (byte)(1.0 + 1.5 * Math.sqrt(energy * 4.0f / 0.12f));
            this.timeStep = (short)Math.max(1, 20 - (this.requiredStardust >> 1));
            this.updateComparatorStatus();
        }
    }

    @Override
    protected boolean onWorkFinished() {
        float energy = EnergyValues.getItemEnergy(this.items[0]);
        if (this.storedEnergy + energy > 1.8f) {
            return false;
        }
        this.storedEnergy += energy;
        if (--this.items[0].field_77994_a <= 0) {
            this.items[0] = null;
        }
        if ((this.items[1].field_77994_a -= this.requiredStardust) <= 0) {
            this.items[1] = null;
        }
        return true;
    }

    @Override
    public float getMaxStoredEnergy() {
        return 1.8f;
    }

    @Override
    public int getHoldingStardust() {
        return this.items[1] == null ? 0 : this.items[1].field_77994_a;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("leakTimer", this.leakTimer);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.leakTimer = nbt.func_74771_c("leakTimer");
        this.invalidateInventory();
    }

    public int func_70302_i_() {
        return 3;
    }

    @Override
    public void func_70299_a(int slot, ItemStack is) {
        super.func_70299_a(slot, is);
        if (slot == 0) {
            this.invalidateInventory();
        }
    }

    public boolean func_94041_b(int slot, ItemStack is) {
        return slot == 1 ? is.func_77973_b() == ItemList.stardust : (slot == 2 ? is.func_77973_b() == ItemList.instability_orb : true);
    }

    public int[] func_94128_d(int side) {
        return side == 0 ? ArrayUtils.EMPTY_INT_ARRAY : (side == 1 ? slotsTop : slotsSides);
    }

    @Override
    protected String getContainerDefaultName() {
        return "container.extractionTable";
    }
}

