/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import java.io.IOException;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class ItemPacket
extends CoordinatesPacket {
    private ItemStack stack;

    public ItemPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        super.writeData(data);
        if (this.getStack() != null) {
            data.writeInt(Item.func_150891_b((Item)this.getStack().func_77973_b()));
            data.writeInt(this.getStack().field_77994_a);
            data.writeInt(this.getStack().func_77960_j());
            data.writeNBTTagCompound(this.getStack().func_77978_p());
        } else {
            data.writeInt(0);
        }
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        super.readData(data);
        int itemID = data.readInt();
        if (itemID != 0) {
            int stackSize = data.readInt();
            int damage = data.readInt();
            this.setStack(new ItemStack(Item.func_150899_d((int)itemID), stackSize, damage));
            this.getStack().func_77982_d(data.readNBTTagCompound());
        } else {
            this.setStack(null);
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemPacket setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }
}

