/*
 * Decompiled with CFR 0.152.
 */
package shukaro.warptheory;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;
import shukaro.warptheory.block.WarpBlocks;
import shukaro.warptheory.entity.EntityDoppelganger;
import shukaro.warptheory.entity.EntityFakeCreeper;
import shukaro.warptheory.entity.EntityPassiveCreeper;
import shukaro.warptheory.entity.EntityPhantom;
import shukaro.warptheory.entity.EntitySafeTaintSheep;
import shukaro.warptheory.gui.WarpTab;
import shukaro.warptheory.handlers.ConfigHandler;
import shukaro.warptheory.handlers.WarpCommand;
import shukaro.warptheory.handlers.WarpEventHandler;
import shukaro.warptheory.handlers.WarpHandler;
import shukaro.warptheory.items.WarpItems;
import shukaro.warptheory.net.CommonProxy;
import shukaro.warptheory.recipe.WarpAspects;
import shukaro.warptheory.recipe.WarpRecipes;
import shukaro.warptheory.research.WarpResearch;
import shukaro.warptheory.util.NameGenerator;

@Mod(modid="WarpTheory", name="WarpTheory", version="1.4.2-GTNH", guiFactory="shukaro.warptheory.gui.GuiFactory", dependencies="required-after:Forge@[10.13.2,);required-after:Baubles;required-after:Thaumcraft@[4.2.3.5,);")
public class WarpTheory {
    @SidedProxy(clientSide="shukaro.warptheory.net.ClientProxy", serverSide="shukaro.warptheory.net.CommonProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static CreativeTabs mainTab;
    public static NameGenerator normalNames;
    @Mod.Instance(value="WarpTheory")
    public static WarpTheory instance;

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new WarpCommand());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        try {
            File normalFile;
            File folder = new File(event.getModConfigurationDirectory() + "/warptheory/");
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (!(normalFile = new File(event.getModConfigurationDirectory() + "/warptheory/normal.txt")).exists()) {
                InputStream in = WarpTheory.class.getResourceAsStream("/assets/warptheory/names/normal.txt");
                Files.copy(in, normalFile.getAbsoluteFile().toPath(), new CopyOption[0]);
            }
            normalNames = new NameGenerator(normalFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ConfigHandler.init(event.getSuggestedConfigurationFile());
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
        WarpBlocks.initBlocks();
        WarpItems.initItems();
        MinecraftForge.EVENT_BUS.register((Object)new WarpEventHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        WarpAspects.init();
        WarpRecipes.init();
        WarpHandler.initEvents();
        EntityRegistry.registerModEntity(EntityPassiveCreeper.class, (String)"creeperPassive", (int)0, (Object)this, (int)160, (int)4, (boolean)true);
        EntityRegistry.registerModEntity(EntityFakeCreeper.class, (String)"creeperFake", (int)1, (Object)this, (int)160, (int)4, (boolean)true);
        EntityRegistry.registerModEntity(EntityDoppelganger.class, (String)"doppelganger", (int)2, (Object)this, (int)160, (int)4, (boolean)true);
        EntityRegistry.registerModEntity(EntityPhantom.class, (String)"phantom", (int)3, (Object)this, (int)160, (int)4, (boolean)true);
        EntityRegistry.registerModEntity(EntitySafeTaintSheep.class, (String)"taintSheepSafe", (int)4, (Object)this, (int)160, (int)4, (boolean)true);
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        WarpResearch.init();
    }

    static {
        mainTab = new WarpTab(StatCollector.func_74838_a((String)"warptheory.tab"));
    }
}

