/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ClientHandler;
import codechicken.nei.ItemStackMap;
import codechicken.nei.api.IStackStringifyHandler;
import codechicken.nei.recipe.stackinfo.DefaultStackStringifyHandler;
import codechicken.nei.recipe.stackinfo.GTFluidStackStringifyHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class StackInfo {
    public static final ArrayList<IStackStringifyHandler> stackStringifyHandlers = new ArrayList();
    private static final HashMap<String, HashMap<String, String[]>> guidfilters = new HashMap();
    private static final ItemStackMap<String> guidcache = new ItemStackMap();
    private static final LinkedHashMap<ItemStack, FluidStack> fluidcache = new LinkedHashMap<ItemStack, FluidStack>(){
        private static final long serialVersionUID = 1042213947848622164L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<ItemStack, FluidStack> eldest) {
            return this.size() > 20;
        }
    };

    public static NBTTagCompound itemStackToNBT(ItemStack stack) {
        return StackInfo.itemStackToNBT(stack, true);
    }

    public static NBTTagCompound itemStackToNBT(ItemStack stack, boolean saveStackSize) {
        NBTTagCompound nbTag = null;
        for (int i = stackStringifyHandlers.size() - 1; i >= 0 && nbTag == null; --i) {
            nbTag = stackStringifyHandlers.get(i).convertItemStackToNBT(stack, saveStackSize);
        }
        return nbTag;
    }

    public static ItemStack loadFromNBT(NBTTagCompound nbtTag, long customCount) {
        if (nbtTag != null) {
            nbtTag = (NBTTagCompound)nbtTag.func_74737_b();
            nbtTag.func_74768_a("Count", (int)Math.max(Math.min(customCount, Integer.MAX_VALUE), 0L));
            return StackInfo.loadFromNBT(nbtTag);
        }
        return null;
    }

    public static ItemStack loadFromNBT(NBTTagCompound nbtTag) {
        ItemStack stack = null;
        if (nbtTag != null) {
            for (int i = stackStringifyHandlers.size() - 1; i >= 0 && stack == null; --i) {
                stack = stackStringifyHandlers.get(i).convertNBTToItemStack(nbtTag);
            }
        }
        return stack;
    }

    public static boolean equalItemAndNBT(ItemStack stackA, ItemStack stackB, boolean useNBT) {
        if (!stackA.func_77969_a(stackB)) {
            return false;
        }
        if (useNBT) {
            NBTTagCompound tagCompoundA = StackInfo.itemStackToNBT(stackA, false);
            NBTTagCompound tagCompoundB = StackInfo.itemStackToNBT(stackB, false);
            return tagCompoundA == null && tagCompoundB == null || tagCompoundA != null && tagCompoundB != null && tagCompoundA.equals((Object)tagCompoundB);
        }
        return true;
    }

    public static FluidStack getFluid(ItemStack stack) {
        FluidStack fluid = fluidcache.get(stack);
        if (fluid == null && !fluidcache.containsKey(stack)) {
            for (int i = stackStringifyHandlers.size() - 1; i >= 0 && fluid == null; --i) {
                fluid = stackStringifyHandlers.get(i).getFluid(stack);
            }
            fluidcache.put(stack, fluid);
        }
        return fluid;
    }

    public static boolean isFluidContainer(ItemStack stack) {
        return stack.func_77973_b() instanceof IFluidContainerItem || FluidContainerRegistry.isContainer((ItemStack)stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getItemStackGUID(ItemStack stack) {
        String guid = guidcache.get(stack);
        if (guid != null) {
            return guid;
        }
        NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack, false);
        if (nbTag == null) {
            return null;
        }
        nbTag.func_82580_o("Count");
        if (nbTag.func_74765_d("Damage") == 0) {
            nbTag.func_82580_o("Damage");
        }
        if (nbTag.func_74764_b("tag") && nbTag.func_74775_l("tag").func_82582_d()) {
            nbTag.func_82580_o("tag");
        }
        if (nbTag.func_74764_b("strId") && guidfilters.containsKey(nbTag.func_74779_i("strId"))) {
            ArrayList<String> keys = new ArrayList<String>();
            String strId = nbTag.func_74779_i("strId");
            keys.add(strId);
            guidfilters.get(strId).forEach((key, rule) -> {
                Object local = nbTag;
                for (int i = 0; i < ((String[])rule).length; ++i) {
                    try {
                        if (local instanceof NBTTagCompound) {
                            local = local.func_74781_a(rule[i]);
                            continue;
                        }
                        if (!(local instanceof NBTTagList)) break;
                        local = ((NBTTagList)local).field_74747_a.get(Integer.parseInt(rule[i]));
                        continue;
                    }
                    catch (Throwable e) {
                        break;
                    }
                }
                if (local instanceof NBTBase) {
                    keys.add(((NBTBase)local).toString());
                } else if (local != null) {
                    keys.add(String.valueOf(local));
                }
            });
            ItemStackMap<String> itemStackMap = guidcache;
            synchronized (itemStackMap) {
                guidcache.put(stack, keys.toString());
            }
        }
        ItemStackMap<String> itemStackMap = guidcache;
        synchronized (itemStackMap) {
            guidcache.put(stack, nbTag.toString());
        }
        return guidcache.get(stack);
    }

    public static void loadGuidFilters() {
        guidfilters.clear();
        ClientHandler.loadSettingsFile("guidfilters.cfg", lines -> lines.forEach(guidStr -> {
            String[] parts = guidStr.split(",");
            HashMap<String, String[]> rules = new HashMap<String, String[]>();
            for (int j = 1; j < parts.length; ++j) {
                rules.put(parts[j], parts[j].split("\\."));
            }
            guidfilters.put(parts[0], rules);
        }));
    }

    public static ItemStack getItemStackWithMinimumDamage(ItemStack[] stacks) {
        int damage = Short.MAX_VALUE;
        ItemStack result = stacks[0];
        if (stacks.length > 1) {
            for (ItemStack stack : stacks) {
                if (stack.func_77973_b() == null || stack.func_77960_j() >= damage) continue;
                damage = stack.func_77960_j();
                result = stack;
            }
        }
        return result.func_77946_l();
    }

    static {
        stackStringifyHandlers.add(new DefaultStackStringifyHandler());
        stackStringifyHandlers.add(new GTFluidStackStringifyHandler());
    }
}

