/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.items;

import appeng.api.config.AccessRestriction;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.util.IConfigManager;
import appeng.items.tools.powered.powersink.AERootPoweredItem;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.base.Optional;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTerminalItem;
import net.p455w0rd.wirelesscraftingterminal.api.WCTApi;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.handlers.LocaleHandler;
import net.p455w0rd.wirelesscraftingterminal.integration.EnderIO;
import net.p455w0rd.wirelesscraftingterminal.items.ItemInfinityBooster;
import net.p455w0rd.wirelesscraftingterminal.items.ItemMagnet;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;
import org.lwjgl.input.Keyboard;

public class ItemWirelessCraftingTerminal
extends AERootPoweredItem
implements IWirelessCraftingTerminalItem,
IWirelessTermHandler,
IBauble {
    public static final String LINK_KEY_STRING = "key";
    public static double GLOBAL_POWER_MULTIPLIER = PowerMultiplier.CONFIG.multiplier;
    private static final String POWER_NBT_KEY = "internalCurrentPower";
    private static final String BOOSTER_SLOT_NBT = "BoosterSlot";
    private static final String MAGNET_SLOT_NBT = "MagnetSlot";
    private EntityPlayer entityPlayer;

    public ItemWirelessCraftingTerminal() {
        super((double)Reference.WCT_MAX_POWER, Optional.absent());
        this.func_77655_b("wirelessCraftingTerminal");
        this.func_111206_d("ae2wct:wirelessCraftingTerminal");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack is, int pass) {
        return this.checkForBooster(is);
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return EnderIO.isSoulBound(itemstack2);
    }

    @Override
    public boolean checkForBooster(ItemStack wirelessTerminal) {
        ItemStack boosterCard;
        NBTTagCompound boosterTagCompound;
        NBTTagList boosterNBTList;
        if (wirelessTerminal.func_77942_o() && (boosterNBTList = wirelessTerminal.func_77978_p().func_150295_c(BOOSTER_SLOT_NBT, 10)) != null && (boosterTagCompound = boosterNBTList.func_150305_b(0)) != null && (boosterCard = ItemStack.func_77949_a((NBTTagCompound)boosterTagCompound)) != null) {
            return boosterCard.func_77973_b() instanceof ItemInfinityBooster && Reference.WCT_BOOSTER_ENABLED;
        }
        return false;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    private boolean isMagnetInstalled(ItemStack wirelessTerminal) {
        ItemStack magnetCard;
        NBTTagCompound magnetTagCompound;
        NBTTagList magnetNBTList;
        if (wirelessTerminal.func_77942_o() && (magnetNBTList = wirelessTerminal.func_77978_p().func_150295_c(MAGNET_SLOT_NBT, 10)) != null && (magnetTagCompound = magnetNBTList.func_150305_b(0)) != null && (magnetCard = ItemStack.func_77949_a((NBTTagCompound)magnetTagCompound)) != null) {
            return magnetCard.func_77973_b() instanceof ItemMagnet;
        }
        return false;
    }

    @Override
    public boolean isWirelessCraftingEnabled(ItemStack wirelessTerminal) {
        return true;
    }

    public void func_77663_a(ItemStack is, World w, Entity e, int i, boolean f) {
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)e;
        if (this.entityPlayer == null) {
            this.entityPlayer = p;
        }
        ItemStack wirelessTerminal = null;
        InventoryPlayer inv = p.field_71071_by;
        wirelessTerminal = RandomUtils.getWirelessTerm(inv);
        if (wirelessTerminal == null || !(wirelessTerminal.func_77973_b() instanceof IWirelessCraftingTerminalItem)) {
            return;
        }
        this.checkForBooster(wirelessTerminal);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            WCTApi.instance().interact().openWirelessCraftingTerminalGui(player);
        }
        return itemStack;
    }

    public String getEncryptionKey(ItemStack wirelessTerminal) {
        String sourceKey;
        if (wirelessTerminal == null) {
            return null;
        }
        if (wirelessTerminal.func_77942_o() && (sourceKey = wirelessTerminal.func_77978_p().func_74779_i(LINK_KEY_STRING)) != null && !sourceKey.isEmpty()) {
            return sourceKey;
        }
        return "";
    }

    public void setEncryptionKey(ItemStack wirelessTerminal, String sourceKey, String name) {
        NBTTagCompound tag = this.ensureTagCompound(wirelessTerminal);
        tag.func_74778_a(LINK_KEY_STRING, sourceKey);
    }

    @Override
    public boolean canHandle(ItemStack is) {
        return is != null && is.func_77973_b() instanceof IWirelessCraftingTerminalItem;
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount) >= amount - 0.5;
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    @Override
    public IConfigManager getConfigManager(final ItemStack target) {
        ConfigManager out = new ConfigManager(new IConfigManagerHost(){

            public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
                NBTTagCompound data = Platform.openNbtData((ItemStack)target);
                manager.writeToNBT(data);
            }
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData((ItemStack)target).func_74737_b());
        return out;
    }

    public void getCheckedSubItems(Item item, CreativeTabs creativeTab, List itemList) {
        List itemList2 = itemList;
        itemList2.add(new ItemStack(item));
        ItemStack is = new ItemStack(item);
        this.injectAEPower(is, Reference.WCT_MAX_POWER);
        itemList2.add(is);
    }

    public boolean showDurabilityBar(ItemStack is) {
        double aeMaxPower;
        double aeCurrPower = this.getAECurrentPower(is);
        return (int)aeCurrPower < (int)(aeMaxPower = this.getAEMaxPower(is));
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack is, EntityPlayer player, List list, boolean displayMore) {
        String shift = LocaleHandler.PressShift.getLocal().replace("Shift", this.color("yellow") + "" + this.color("bold") + "" + this.color("italics") + "Shift" + this.color("gray"));
        NBTTagCompound tag = this.ensureTagCompound(is);
        String encKey = tag.func_74779_i(LINK_KEY_STRING);
        String pctTxtColor = this.color("white") + "";
        double aeCurrPower = this.getAECurrentPower(is);
        double aeCurrPowerPct = (double)((int)Math.floor(aeCurrPower / (double)Reference.WCT_MAX_POWER * 10000.0)) / 100.0;
        if ((int)aeCurrPowerPct >= 75) {
            pctTxtColor = this.color("green") + "";
        }
        if ((int)aeCurrPowerPct <= 5) {
            pctTxtColor = this.color("red") + "";
        }
        list.add(this.color("aqua") + "==============================");
        list.add(StatCollector.func_74838_a((String)"gui.appliedenergistics2.StoredEnergy") + ": " + pctTxtColor + (int)aeCurrPower + " AE - " + aeCurrPowerPct + "%");
        if (ItemWirelessCraftingTerminal.isShiftKeyDown()) {
            String magnetStatus;
            String linked = this.color("red") + StatCollector.func_74838_a((String)"gui.appliedenergistics2.Unlinked");
            if (encKey != null && !encKey.isEmpty()) {
                linked = this.color("blue") + StatCollector.func_74838_a((String)"gui.appliedenergistics2.Linked");
            }
            list.add(LocaleHandler.LinkStatus.getLocal() + ": " + linked);
            String boosterStatus = this.checkForBooster(is) ? this.color("green") + "" + LocaleHandler.Installed.getLocal() : this.color("red") + "" + LocaleHandler.NotInstalled.getLocal();
            String string = magnetStatus = this.isMagnetInstalled(is) ? this.color("green") + "" + LocaleHandler.Installed.getLocal() : this.color("red") + "" + LocaleHandler.NotInstalled.getLocal();
            if (Reference.WCT_BOOSTER_ENABLED) {
                list.add(ItemWirelessCraftingTerminal.getItemName("infinityBoosterCard") + ": " + boosterStatus);
            }
            list.add(ItemWirelessCraftingTerminal.getItemName("magnetCard") + ": " + magnetStatus);
        } else {
            list.add(shift);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String color(String color) {
        return RandomUtils.color(color);
    }

    @SideOnly(value=Side.CLIENT)
    private static String getItemName(String item) {
        return StatCollector.func_74838_a((String)("item." + item + ".name"));
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    private double getInternalBattery(ItemStack is, batteryOperation op, double adjustment) {
        NBTTagCompound data = this.ensureTagCompound(is);
        double currentStorage = data.func_74769_h(POWER_NBT_KEY);
        double maxStorage = this.getAEMaxPower(is);
        switch (op) {
            case INJECT: {
                currentStorage += adjustment;
                if (currentStorage > maxStorage) {
                    double diff = currentStorage - maxStorage;
                    data.func_74780_a(POWER_NBT_KEY, maxStorage);
                    return diff;
                }
                data.func_74780_a(POWER_NBT_KEY, currentStorage);
                return 0.0;
            }
            case EXTRACT: {
                if (currentStorage > adjustment) {
                    data.func_74780_a(POWER_NBT_KEY, currentStorage -= adjustment);
                    return adjustment;
                }
                data.func_74780_a(POWER_NBT_KEY, 0.0);
                return currentStorage;
            }
        }
        return currentStorage;
    }

    public double getDurabilityForDisplay(ItemStack is) {
        return 1.0 - this.getAECurrentPower(is) / this.getAEMaxPower(is);
    }

    private NBTTagCompound ensureTagCompound(ItemStack is) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        return is.func_77978_p();
    }

    public double getAECurrentPower(ItemStack is) {
        return this.getInternalBattery(is, batteryOperation.STORAGE, 0.0);
    }

    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    public double injectAEPower(ItemStack is, double amt) {
        return this.getInternalBattery(is, batteryOperation.INJECT, amt);
    }

    public double extractAEPower(ItemStack is, double amt) {
        int finalAmt = 0;
        if (this.entityPlayer != null) {
            finalAmt = (int)(this.entityPlayer.field_71075_bZ.field_75098_d ? 0.0 : amt);
        }
        return this.getInternalBattery(is, batteryOperation.EXTRACT, finalAmt);
    }

    public double getAEMaxPower(ItemStack is) {
        return Reference.WCT_MAX_POWER;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean isRepairable() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    public int func_77612_l() {
        return 0;
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container == null) {
            return 0;
        }
        if (simulate) {
            double current = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(container));
            double max = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(container));
            if (max - current >= (double)maxReceive) {
                return maxReceive;
            }
            return (int)(max - current);
        }
        double currentAEPower = this.getAECurrentPower(container);
        if ((int)currentAEPower < Reference.WCT_MAX_POWER) {
            int leftOver = (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.injectAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxReceive)));
            return maxReceive - leftOver;
        }
        return 0;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container == null) {
            return 0;
        }
        if (simulate) {
            if (this.getEnergyStored(container) >= maxExtract) {
                return maxExtract;
            }
            return this.getEnergyStored(container);
        }
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.extractAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxExtract)));
    }

    public int getEnergyStored(ItemStack container) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(container));
    }

    public int getMaxEnergyStored(ItemStack container) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(container));
    }

    private static enum batteryOperation {
        STORAGE,
        INJECT,
        EXTRACT;

    }
}

