/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.splicer;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.machine.AdvGeneticMachine;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.splicer.IndividualInoculateValidator;
import binnie.genetics.machine.splicer.SerumSlotValidator;
import binnie.genetics.machine.splicer.Splicer;
import binnie.genetics.machine.splicer.SplicerComponentFX;
import binnie.genetics.machine.splicer.SplicerComponentLogic;
import net.minecraft.item.ItemStack;

public class SplicerPackage
extends AdvGeneticMachine.PackageAdvGeneticBase
implements IMachineInformation {
    public SplicerPackage() {
        super("splicer", GeneticsTexture.Splicer, 14819893, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.Splicer);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        SerumSlotValidator serumValid = new SerumSlotValidator();
        InventorySlot serumSlot = inventory.addSlot(0, "serum.active");
        serumSlot.forbidInteraction();
        serumSlot.setReadOnly();
        serumSlot.setValidator(serumValid);
        inventory.addSlotArray(Splicer.SLOT_SERUM_RESERVE, "serum.input");
        for (InventorySlot slot : inventory.getSlots(Splicer.SLOT_SERUM_RESERVE)) {
            slot.setValidator(serumValid);
            slot.forbidExtraction();
        }
        inventory.addSlotArray(Splicer.SLOT_SERUM_EXPENDED, "serum.output");
        for (InventorySlot slot : inventory.getSlots(Splicer.SLOT_SERUM_EXPENDED)) {
            slot.setValidator(serumValid);
            slot.setReadOnly();
        }
        inventory.addSlotArray(Splicer.SLOT_RESERVE, "input");
        for (InventorySlot slot : inventory.getSlots(Splicer.SLOT_RESERVE)) {
            slot.forbidExtraction();
            slot.setValidator(new IndividualInoculateValidator());
        }
        InventorySlot targetSlot = inventory.addSlot(9, "process");
        targetSlot.setValidator(new IndividualInoculateValidator());
        targetSlot.setReadOnly();
        targetSlot.forbidInteraction();
        inventory.addSlotArray(Splicer.SLOT_FINISHED, "output");
        for (InventorySlot slot : inventory.getSlots(Splicer.SLOT_FINISHED)) {
            slot.setReadOnly();
            slot.forbidInsertion();
            slot.setValidator(new IndividualInoculateValidator());
        }
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Splicer.SLOT_RESERVE, 9, 1);
        transfer.addRestock(Splicer.SLOT_SERUM_RESERVE, 0);
        transfer.addStorage(0, Splicer.SLOT_SERUM_EXPENDED, new ComponentInventoryTransfer.Condition(){

            @Override
            public boolean fufilled(ItemStack stack) {
                return Engineering.getCharges(stack) == 0;
            }
        });
        transfer.addStorage(9, Splicer.SLOT_FINISHED, new ComponentInventoryTransfer.Condition(){

            @Override
            public boolean fufilled(ItemStack stack) {
                return stack != null && this.transfer.getMachine().getMachineUtil().getStack(0) != null && this.transfer.getMachine().getInterface(SplicerComponentLogic.class).isValidSerum() != null;
            }
        });
        new ComponentPowerReceptor(machine, 20000);
        new SplicerComponentLogic(machine);
        new SplicerComponentFX(machine);
    }
}

