/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.model;

import com.gtnewhorizon.gtnhlib.client.model.GeometryHelper;
import com.gtnewhorizon.gtnhlib.client.model.Material;
import com.gtnewhorizon.gtnhlib.client.model.NormalHelper;
import com.gtnewhorizon.gtnhlib.client.model.TexHelper;
import com.gtnewhorizon.gtnhlib.client.model.json.FaceRewindHelper;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.Quad;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadBuilder;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.properties.ModelQuadFlags;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class NdQuadBuilder
extends Quad
implements QuadBuilder {
    private ForgeDirection nominalFace = ForgeDirection.UNKNOWN;
    private ForgeDirection lightFace = ForgeDirection.UP;
    private int geometryFlags = 0;
    private boolean isGeometryInvalid = true;
    private int tag = 0;
    final Vector3f faceNormal = new Vector3f();
    public final Material mat = new Material();
    private int drawMode = 7;
    final int MIN_X = 0;
    final int MIN_Y = 1;
    final int MIN_Z = 2;
    final int MAX_X = 3;
    final int MAX_Y = 4;
    final int MAX_Z = 5;

    @Override
    public QuadView build(QuadView out) {
        if (this.drawMode != 7) {
            this.quadrangulate();
        }
        this.computeGeometry();
        out.copyFrom(this);
        this.clear();
        return out;
    }

    @Override
    public QuadView build(QuadView out, Matrix4f rotMat) {
        this.pos(0, this.pos(0).mulPosition(rotMat));
        this.pos(1, this.pos(1).mulPosition(rotMat));
        this.pos(2, this.pos(2).mulPosition(rotMat));
        if (this.drawMode == 7) {
            this.pos(3, this.pos(3).mulPosition(rotMat));
        } else {
            this.quadrangulate();
        }
        this.computeGeometry();
        this.setCullFace();
        out.copyFrom(this);
        this.clear();
        return out;
    }

    private void clear() {
        Arrays.fill(this.data, 0);
        this.setCullFace(ForgeDirection.UNKNOWN);
        this.lightFace = ForgeDirection.UP;
        this.geometryFlags = 0;
        this.isGeometryInvalid = true;
        this.tag(0);
        this.setColorIndex(-1);
        this.mat.reset();
        this.drawMode = 7;
    }

    private void computeGeometry() {
        if (this.isGeometryInvalid) {
            this.isGeometryInvalid = false;
            NormalHelper.computeFaceNormal(this.faceNormal, this);
            this.lightFace = GeometryHelper.lightFace(this);
            this.geometryFlags = ModelQuadFlags.getQuadFlags(this);
        }
    }

    @Override
    public boolean isShade() {
        return this.mat.getDiffuse();
    }

    @Override
    @NotNull
    public ForgeDirection getLightFace() {
        this.computeGeometry();
        return this.lightFace;
    }

    @Override
    public void setCullFace(ForgeDirection dir) {
        super.setCullFace(dir);
        this.nominalFace(dir);
    }

    @Override
    public void setCullFace() {
        this.computeGeometry();
        if ((this.geometryFlags & 4) != 0) {
            this.setCullFace(this.lightFace);
        } else {
            this.setCullFace(ForgeDirection.UNKNOWN);
            this.nominalFace(this.lightFace);
        }
    }

    @Override
    public void nominalFace(@Nullable ForgeDirection face) {
        this.nominalFace = face;
    }

    @Override
    public ForgeDirection nominalFace() {
        return this.nominalFace;
    }

    @Override
    public void pos(int vertexIndex, float x, float y, float z) {
        this.setX(vertexIndex, x);
        this.setY(vertexIndex, y);
        this.setZ(vertexIndex, z);
        this.isGeometryInvalid = true;
    }

    @Override
    public void pos(int vertexIndex, Vector3f vec) {
        this.setX(vertexIndex, vec.x);
        this.setY(vertexIndex, vec.y);
        this.setZ(vertexIndex, vec.z);
        this.isGeometryInvalid = true;
    }

    @Override
    public Vector3f pos(int vertexIndex) {
        return new Vector3f(this.getX(vertexIndex), this.getY(vertexIndex), this.getZ(vertexIndex));
    }

    @Override
    public float posByIndex(int vertexIndex, int coordinateIndex) {
        return Float.intBitsToFloat(this.data[vertexIndex * 8 + 0 + coordinateIndex]);
    }

    public void rewind(float x, float y, float z, float X, float Y, float Z) {
        boolean[] blArray;
        switch (this.getLightFace()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                blArray = FaceRewindHelper.DOWN;
                break;
            }
            case UP: {
                blArray = FaceRewindHelper.UP;
                break;
            }
            case NORTH: {
                blArray = FaceRewindHelper.NORTH;
                break;
            }
            case SOUTH: {
                blArray = FaceRewindHelper.SOUTH;
                break;
            }
            case WEST: {
                blArray = FaceRewindHelper.WEST;
                break;
            }
            case EAST: {
                blArray = FaceRewindHelper.EAST;
                break;
            }
            case UNKNOWN: {
                throw new RuntimeException("Expected non-UNKNOWN face!");
            }
        }
        boolean[] targets = blArray;
        float ox = this.getX(0);
        float oy = this.getY(0);
        float oz = this.getZ(0);
        int iFirst = 0;
        for (int i = 0; i < 4; ++i) {
            float px = targets[i * 3] ? X : x;
            float py = targets[i * 3 + 1] ? Y : y;
            float pz = targets[i * 3 + 2] ? Z : z;
            this.pos(i, px, py, pz);
            if (px != ox || py != oy || pz != oz) continue;
            iFirst = i;
        }
        float[] uvs = new float[]{this.getTexU(0), this.getTexV(0), this.getTexU(1), this.getTexV(1), this.getTexU(2), this.getTexV(2), this.getTexU(3), this.getTexV(3)};
        for (int i = 0; i < 4; ++i) {
            this.uv((i + iFirst) % 4, uvs[i * 2], uvs[i * 2 + 1]);
        }
    }

    @Override
    public void spriteBake(String spriteName, int bakeFlags) {
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(spriteName);
        TexHelper.bakeSprite(this, (IIcon)icon, bakeFlags);
    }

    @Override
    public void spriteBake(IIcon sprite, int bakeFlags) {
        TexHelper.bakeSprite(this, sprite, bakeFlags);
    }

    @Override
    public void square(ForgeDirection nominalFace, float left, float bottom, float right, float top, float depth) {
        if (Math.abs(depth) < 1.0E-5f) {
            this.setCullFace(nominalFace);
            depth = 0.0f;
        } else {
            this.setCullFace(ForgeDirection.UNKNOWN);
        }
        this.nominalFace(nominalFace);
        switch (nominalFace) {
            case UP: {
                depth = 1.0f - depth;
                top = 1.0f - top;
                bottom = 1.0f - bottom;
            }
            case DOWN: {
                this.pos(0, left, depth, top);
                this.pos(1, left, depth, bottom);
                this.pos(2, right, depth, bottom);
                this.pos(3, right, depth, top);
                break;
            }
            case EAST: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case WEST: {
                this.pos(0, depth, top, left);
                this.pos(1, depth, bottom, left);
                this.pos(2, depth, bottom, right);
                this.pos(3, depth, top, right);
                break;
            }
            case SOUTH: {
                depth = 1.0f - depth;
                left = 1.0f - left;
                right = 1.0f - right;
            }
            case NORTH: {
                this.pos(0, 1.0f - left, top, depth);
                this.pos(1, 1.0f - left, bottom, depth);
                this.pos(2, 1.0f - right, bottom, depth);
                this.pos(3, 1.0f - right, top, depth);
            }
        }
    }

    @Override
    public int tag() {
        return this.tag;
    }

    @Override
    public void tag(int tag) {
        this.tag = tag;
    }

    @Override
    public void uv(int vertexIndex, float u, float v) {
        this.setTexU(vertexIndex, u);
        this.setTexV(vertexIndex, v);
    }

    @Override
    public int getFlags() {
        return this.geometryFlags;
    }

    @Override
    public TextureAtlasSprite rubidium$getSprite() {
        return null;
    }

    public void setDrawMode(int drawMode) {
        this.drawMode = drawMode;
    }
}

