/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.recipes.IFabricatorManager;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingManager;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.forestry.ForestryListAddition;
import modtweaker2.mods.forestry.ForestryListRemoval;
import modtweaker2.mods.forestry.recipes.DescriptiveRecipe;
import modtweaker2.mods.forestry.recipes.FabricatorRecipe;
import modtweaker2.mods.forestry.recipes.FabricatorSmeltingRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.ThermionicFabricator")
public class ThermionicFabricator {
    public static final String nameSmelting = "Forestry Thermionic Fabricator (Smelting)";
    public static final String nameCasting = "Forestry Thermionic Fabricator (Casting)";

    @ZenMethod
    public static void addSmelting(int fluidOutput, IItemStack itemInput, int meltingPoint) {
        MineTweakerAPI.apply((IUndoableAction)new AddSmelting(new FabricatorSmeltingRecipe(InputHelper.toStack(itemInput), FluidRegistry.getFluidStack((String)"glass", (int)fluidOutput), meltingPoint)));
    }

    @Deprecated
    @ZenMethod
    public static void addSmelting(IItemStack itemInput, int meltingPoint, int fluidOutput) {
        MineTweakerAPI.apply((IUndoableAction)new AddSmelting(new FabricatorSmeltingRecipe(InputHelper.toStack(itemInput), FluidRegistry.getFluidStack((String)"glass", (int)fluidOutput), meltingPoint)));
    }

    @ZenMethod
    public static void addCast(IItemStack output, IIngredient[][] ingredients, int fluidInput, @Optional IItemStack plan) {
        DescriptiveRecipe recipe = new DescriptiveRecipe(3, 3, InputHelper.toShapedObjects(ingredients), InputHelper.toStack(output), false);
        MineTweakerAPI.apply((IUndoableAction)new AddCast(new FabricatorRecipe(InputHelper.toStack(plan), FluidRegistry.getFluidStack((String)"glass", (int)fluidInput), recipe)));
    }

    @Deprecated
    @ZenMethod
    public static void addCast(ILiquidStack fluidInput, IIngredient[][] ingredients, IItemStack plan, IItemStack output) {
        DescriptiveRecipe recipe = new DescriptiveRecipe(3, 3, InputHelper.toShapedObjects(ingredients), InputHelper.toStack(output), false);
        MineTweakerAPI.apply((IUndoableAction)new AddCast(new FabricatorRecipe(InputHelper.toStack(plan), InputHelper.toFluid(fluidInput), recipe)));
    }

    @ZenMethod
    public static void removeSmelting(IIngredient itemInput) {
        LinkedList<IFabricatorSmeltingRecipe> recipes = new LinkedList<IFabricatorSmeltingRecipe>();
        for (IFabricatorSmeltingRecipe r : RecipeManagers.fabricatorSmeltingManager.recipes()) {
            if (r == null || r.getResource() == null || !StackHelper.matches(itemInput, InputHelper.toIItemStack(r.getResource()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveSmelting(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", nameSmelting, itemInput.toString()));
        }
    }

    @ZenMethod
    public static void removeCast(IIngredient product) {
        LinkedList<IFabricatorRecipe> recipes = new LinkedList<IFabricatorRecipe>();
        for (IFabricatorRecipe r : RecipeManagers.fabricatorManager.recipes()) {
            if (r == null || r.getRecipeOutput() == null || !StackHelper.matches(product, InputHelper.toIItemStack(r.getRecipeOutput()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveCasts(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", nameSmelting, product.toString()));
        }
    }

    @Deprecated
    @ZenMethod
    public static void removeCasts(IIngredient product) {
        LinkedList<IFabricatorRecipe> recipes = new LinkedList<IFabricatorRecipe>();
        for (IFabricatorRecipe r : RecipeManagers.fabricatorManager.recipes()) {
            if (r == null || r.getRecipeOutput() == null || !StackHelper.matches(product, InputHelper.toIItemStack(r.getRecipeOutput()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveCasts(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", nameSmelting, product.toString()));
        }
    }

    private static class RemoveCasts
    extends ForestryListRemoval<IFabricatorRecipe, IFabricatorManager> {
        public RemoveCasts(List<IFabricatorRecipe> recipes) {
            super(ThermionicFabricator.nameCasting, RecipeManagers.fabricatorManager, recipes);
        }

        @Override
        public String getRecipeInfo(IFabricatorRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getRecipeOutput());
        }
    }

    private static class RemoveSmelting
    extends ForestryListRemoval<IFabricatorSmeltingRecipe, IFabricatorSmeltingManager> {
        public RemoveSmelting(List<IFabricatorSmeltingRecipe> recipes) {
            super(ThermionicFabricator.nameSmelting, RecipeManagers.fabricatorSmeltingManager, recipes);
        }

        @Override
        public String getRecipeInfo(IFabricatorSmeltingRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getResource());
        }
    }

    private static class AddCast
    extends ForestryListAddition<IFabricatorRecipe, IFabricatorManager> {
        public AddCast(IFabricatorRecipe recipe) {
            super(ThermionicFabricator.nameCasting, RecipeManagers.fabricatorManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IFabricatorRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getRecipeOutput());
        }
    }

    private static class AddSmelting
    extends ForestryListAddition<IFabricatorSmeltingRecipe, IFabricatorSmeltingManager> {
        public AddSmelting(IFabricatorSmeltingRecipe recipe) {
            super(ThermionicFabricator.nameSmelting, RecipeManagers.fabricatorSmeltingManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IFabricatorSmeltingRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getResource());
        }
    }
}

