/*
 * Decompiled with CFR 0.152.
 */
package tectech.recipe;

import com.google.common.math.IntMath;
import gnu.trove.map.TMap;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gtneioreplugin.plugin.block.BlockDimensionDisplay;
import gtneioreplugin.util.GT5OreLayerHelper;
import gtneioreplugin.util.GT5OreSmallHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import tectech.recipe.EyeOfHarmonyRecipeStorage;
import tectech.util.FluidStackLong;
import tectech.util.ItemStackLong;

public class EyeOfHarmonyRecipe {
    static final FluidStackLong[] SPECIAL_FLUIDS = new FluidStackLong[]{new FluidStackLong(MaterialsUEVplus.WhiteDwarfMatter.getMolten(1152L), 1152L), new FluidStackLong(MaterialsUEVplus.WhiteDwarfMatter.getMolten(1152L), 1152L), new FluidStackLong(MaterialsUEVplus.WhiteDwarfMatter.getMolten(4608L), 4608L), new FluidStackLong(MaterialsUEVplus.WhiteDwarfMatter.getMolten(18432L), 18432L), new FluidStackLong(MaterialsUEVplus.BlackDwarfMatter.getMolten(1152L), 1152L), new FluidStackLong(MaterialsUEVplus.BlackDwarfMatter.getMolten(4608L), 4608L), new FluidStackLong(MaterialsUEVplus.BlackDwarfMatter.getMolten(18432L), 18432L), new FluidStackLong(MaterialsUEVplus.Universium.getMolten(1152L), 1152L), new FluidStackLong(MaterialsUEVplus.Universium.getMolten(4608L), 4608L), new FluidStackLong(MaterialsUEVplus.Universium.getMolten(18432L), 18432L)};
    HashingStrategy<ItemStack> itemStackHashingStrategy = new HashingStrategy<ItemStack>(){
        private static final long serialVersionUID = -3966004160368229212L;

        public int computeHashCode(ItemStack stack) {
            int result = stack.func_77973_b().hashCode();
            result = 31 * result + stack.func_77960_j();
            return result;
        }

        public boolean equals(ItemStack item1, ItemStack item2) {
            return item1.func_77977_a().equals(item2.func_77977_a());
        }
    };
    private final TMap<ItemStack, Double> itemStackToProbabilityMap = new TCustomHashMap(this.itemStackHashingStrategy);
    private final TMap<ItemStack, Long> itemStackToTrueStackSizeMap = new TCustomHashMap(this.itemStackHashingStrategy);
    private final ArrayList<ItemStackLong> outputItems;
    private final ArrayList<FluidStackLong> outputFluids;
    private final long hydrogenRequirement;
    private final long heliumRequirement;
    private final long euOutput;
    private final long euStartCost;
    private final double baseSuccessChance;
    private final long spacetimeCasingTierRequired;
    private final long miningTimeSeconds;
    private final double recipeEnergyEfficiency;
    private final ItemStack recipeTriggerItem;
    private final long sumOfItems;
    private final long rocketTier;
    private final long standardRecipeEUOutPerTick = 100L * EyeOfHarmonyRecipeStorage.BILLION;
    private static final double PRIMARY_MULTIPLIER = 0.2111111111111111;
    private static final double SECONDARY_MULTIPLIER = 0.1111111111111111;
    private static final double TERTIARY_MULTIPLIER = 0.1;
    private static final double QUATERNARY_MULTIPLIER = 0.7;
    private static final double[] ORE_MULTIPLIER = new double[]{0.2111111111111111, 0.1111111111111111, 0.1, 0.7};
    private static final List<Materials> VALID_PLASMAS = Stream.of(Materials.Helium, Materials.Iron, Materials.Calcium, Materials.Niobium, Materials.Nitrogen, Materials.Zinc, Materials.Silver, Materials.Titanium, Materials.Radon, Materials.Nickel, Materials.Boron, Materials.Sulfur, Materials.Americium, Materials.Bismuth, Materials.Oxygen, Materials.Tin).collect(Collectors.toList());
    private static final HashMap<String, Long> plasmaEnergyMap = new HashMap<String, Long>(){
        private static final long serialVersionUID = 7933945171103801933L;
        {
            VALID_PLASMAS.forEach((? super T material) -> this.put(material.getPlasma(1L).getFluid().getUnlocalizedName(), (long)((double)GTUtility.getPlasmaFuelValueInEUPerLiterFromMaterial(material) * EyeOfHarmonyRecipe.getMaxPlasmaTurbineEfficiency())));
        }
    };

    public TMap<ItemStack, Double> getItemStackToProbabilityMap() {
        return this.itemStackToProbabilityMap;
    }

    public TMap<ItemStack, Long> getItemStackToTrueStackSizeMap() {
        return this.itemStackToTrueStackSizeMap;
    }

    public double getRecipeEnergyEfficiency() {
        return this.recipeEnergyEfficiency;
    }

    public long getSumOfItems() {
        return this.sumOfItems;
    }

    public long getRocketTier() {
        return this.rocketTier;
    }

    public EyeOfHarmonyRecipe(ArrayList<Pair<Materials, Long>> materialList, BlockDimensionDisplay block, double recipeEnergyEfficiency, long hydrogenRequirement, long heliumRequirement, long miningTimeSeconds, long rocketTierOfRecipe, double baseSuccessChance) {
        this.rocketTier = rocketTierOfRecipe;
        this.spacetimeCasingTierRequired = Math.min(8L, rocketTierOfRecipe);
        this.recipeTriggerItem = new ItemStack((Block)block);
        this.outputItems = EyeOfHarmonyRecipe.validDustGenerator(materialList);
        this.sumOfItems = this.outputItems.stream().map(ItemStackLong::getStackSize).reduce(0L, Long::sum);
        this.outputItems.add(new ItemStackLong(this.getStoneDustType(block.getDimension()), this.sumOfItems * 3L));
        this.outputItems.sort(Comparator.comparingLong(ItemStackLong::getStackSize));
        Collections.reverse(this.outputItems);
        for (ItemStackLong itemStackLong : this.outputItems) {
            double stackSize = itemStackLong.getStackSize();
            double probability = (double)Math.round(100000.0 * stackSize / (double)this.sumOfItems) / 1000.0;
            this.itemStackToProbabilityMap.put((Object)itemStackLong.itemStack, (Object)probability);
            this.itemStackToTrueStackSizeMap.put((Object)itemStackLong.itemStack, (Object)itemStackLong.stackSize);
        }
        ArrayList<FluidStackLong> fluidStackLongArrayList = new ArrayList<FluidStackLong>();
        int plasmaAmount = (int)((this.spacetimeCasingTierRequired + 1L) * 8000000L);
        if (this.rocketTier == 9L) {
            for (Materials materials : VALID_PLASMAS) {
                fluidStackLongArrayList.add(new FluidStackLong(materials.getPlasma(plasmaAmount), plasmaAmount));
            }
        } else {
            ArrayList<FluidStack> fluidStackArrayList = new ArrayList<FluidStack>(EyeOfHarmonyRecipe.validPlasmaGenerator(materialList));
            for (FluidStack fluidStack : fluidStackArrayList) {
                fluidStack = new FluidStack(fluidStack, plasmaAmount);
                fluidStackLongArrayList.add(new FluidStackLong(fluidStack, plasmaAmount));
            }
        }
        fluidStackLongArrayList.add(new FluidStackLong(MaterialsUEVplus.RawStarMatter.getFluid((this.spacetimeCasingTierRequired + 1L) * 100000L), (this.spacetimeCasingTierRequired + 1L) * 100000L));
        int spacetimeTier = (int)rocketTierOfRecipe;
        if (spacetimeTier == 0 || spacetimeTier == 9) {
            --spacetimeTier;
        }
        fluidStackLongArrayList.add(SPECIAL_FLUIDS[spacetimeTier + 1]);
        this.outputFluids = fluidStackLongArrayList;
        this.hydrogenRequirement = hydrogenRequirement;
        this.heliumRequirement = heliumRequirement;
        this.baseSuccessChance = baseSuccessChance;
        this.miningTimeSeconds = miningTimeSeconds;
        this.recipeEnergyEfficiency = recipeEnergyEfficiency;
        long l = EyeOfHarmonyRecipe.plasmaCostCalculator(this.outputFluids);
        long VM3EU = miningTimeSeconds * (long)IntMath.pow((int)2, (int)19) * 20L;
        this.euStartCost = l + VM3EU + this.standardRecipeEUOutPerTick * 20L * miningTimeSeconds;
        this.euOutput = (long)((double)this.euStartCost * recipeEnergyEfficiency);
    }

    private ItemStack getStoneDustType(String key) {
        ItemStack itemStack;
        ItemStack placeholder = GTOreDictUnificator.get(OrePrefixes.dust, Materials.Stone, 1L);
        switch (key) {
            case "Ne": {
                itemStack = GTOreDictUnificator.get(OrePrefixes.dust, Materials.Netherrack, 1L);
                break;
            }
            case "ED": 
            case "VA": 
            case "EA": {
                itemStack = GTOreDictUnificator.get(OrePrefixes.dust, Materials.Endstone, 1L);
                break;
            }
            case "Mo": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MoonStoneDust", 1L, placeholder);
                break;
            }
            case "De": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.DeimosStoneDust", 1L, placeholder);
                break;
            }
            case "Ma": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MarsStoneDust", 1L, placeholder);
                break;
            }
            case "Ph": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PhobosStoneDust", 1L, placeholder);
                break;
            }
            case "As": 
            case "KB": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.AsteroidsStoneDust", 1L, placeholder);
                break;
            }
            case "Ca": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CallistoStoneDust", 1L, placeholder);
                break;
            }
            case "Ce": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CeresStoneDust", 1L, placeholder);
                break;
            }
            case "Eu": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EuropaStoneDust", 1L, placeholder);
                break;
            }
            case "Ga": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.GanymedeStoneDust", 1L, placeholder);
                break;
            }
            case "Io": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.IoStoneDust", 1L, placeholder);
                break;
            }
            case "Me": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MercuryStoneDust", 1L, placeholder);
                break;
            }
            case "Ve": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.VenusStoneDust", 1L, placeholder);
                break;
            }
            case "En": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EnceladusStoneDust", 1L, placeholder);
                break;
            }
            case "Mi": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MirandaStoneDust", 1L, placeholder);
                break;
            }
            case "Ob": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.OberonStoneDust", 1L, placeholder);
                break;
            }
            case "Ti": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TitanStoneDust", 1L, placeholder);
                break;
            }
            case "Pr": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.ProteusStoneDust", 1L, placeholder);
                break;
            }
            case "Tr": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TritonStoneDust", 1L, placeholder);
                break;
            }
            case "Ha": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.HaumeaStoneDust", 1L, placeholder);
                break;
            }
            case "MM": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.MakeMakeStoneDust", 1L, placeholder);
                break;
            }
            case "Pl": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.PlutoStoneDust", 1L, placeholder);
                break;
            }
            case "BE": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaEStoneDust", 1L, placeholder);
                break;
            }
            case "BF": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.BarnardaFStoneDust", 1L, placeholder);
                break;
            }
            case "CB": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.CentauriAStoneDust", 1L, placeholder);
                break;
            }
            case "TE": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.TCetiEStoneDust", 1L, placeholder);
                break;
            }
            case "VB": {
                itemStack = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.VegaBStoneDust", 1L, placeholder);
                break;
            }
            default: {
                itemStack = placeholder;
            }
        }
        return itemStack;
    }

    public EyeOfHarmonyRecipe(GT5OreLayerHelper.NormalOreDimensionWrapper normalOreDimensionWrapper, GT5OreSmallHelper.SmallOreDimensionWrapper smallOreDimensionWrapper, BlockDimensionDisplay block, double recipeEnergyEfficiency, long hydrogenRequirement, long heliumRequirement, long miningTimeSeconds, long spacetimeCasingTierRequired, double baseSuccessChance) {
        this(EyeOfHarmonyRecipe.processDimension(normalOreDimensionWrapper, smallOreDimensionWrapper, miningTimeSeconds), block, recipeEnergyEfficiency, hydrogenRequirement, heliumRequirement, miningTimeSeconds, spacetimeCasingTierRequired, baseSuccessChance);
    }

    public ArrayList<ItemStackLong> getOutputItems() {
        ArrayList<ItemStackLong> copyOutputList = new ArrayList<ItemStackLong>();
        for (ItemStackLong itemStackLong : this.outputItems) {
            copyOutputList.add(new ItemStackLong(itemStackLong));
        }
        return copyOutputList;
    }

    public ArrayList<FluidStackLong> getOutputFluids() {
        ArrayList<FluidStackLong> copyOutputList = new ArrayList<FluidStackLong>();
        for (FluidStackLong fluidStackLong : this.outputFluids) {
            copyOutputList.add(new FluidStackLong(fluidStackLong));
        }
        return copyOutputList;
    }

    public long getHydrogenRequirement() {
        return this.hydrogenRequirement;
    }

    public long getHeliumRequirement() {
        return this.heliumRequirement;
    }

    public long getEUOutput() {
        return this.euOutput;
    }

    public long getEUStartCost() {
        return this.euStartCost;
    }

    public long getRecipeTimeInTicks() {
        return this.miningTimeSeconds * 20L;
    }

    public double getBaseRecipeSuccessChance() {
        return this.baseSuccessChance;
    }

    public long getSpacetimeCasingTierRequired() {
        return this.spacetimeCasingTierRequired;
    }

    public ItemStack getRecipeTriggerItem() {
        return this.recipeTriggerItem;
    }

    public static void processHelper(HashMapHelper outputMap, Materials material, double mainMultiplier, double probability) {
        if (material == null) {
            return;
        }
        outputMap.add(material.mDirectSmelting, (double)(material.mOreMultiplier * 2) * mainMultiplier * probability);
        int index = 0;
        for (Materials byProductMaterial : material.mOreByProducts) {
            outputMap.add(byProductMaterial.mDirectSmelting, mainMultiplier * (ORE_MULTIPLIER[index++] * 2.0) * probability);
        }
    }

    private static ArrayList<Pair<Materials, Long>> processDimension(GT5OreLayerHelper.NormalOreDimensionWrapper normalOreDimWrapper, GT5OreSmallHelper.SmallOreDimensionWrapper smallOreDimWrapper, long timeInSeconds) {
        HashMapHelper outputMap = new HashMapHelper();
        double mainMultiplier = (double)timeInSeconds * 384.0;
        if (normalOreDimWrapper != null) {
            normalOreDimWrapper.oreVeinToProbabilityInDimension.forEach((veinInfo, probability) -> {
                EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.mPrimaryVeinMaterial, mainMultiplier, probability);
                EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.mSecondaryMaterial, mainMultiplier, probability);
                EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.mBetweenMaterial, mainMultiplier / 8.0, probability);
                EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.mSporadicMaterial, mainMultiplier / 8.0, probability);
            });
        }
        if (smallOreDimWrapper != null) {
            smallOreDimWrapper.oreVeinToProbabilityInDimension.forEach((veinInfo, probability) -> EyeOfHarmonyRecipe.processHelper(outputMap, veinInfo.getOreMaterial(), mainMultiplier, probability));
        }
        ArrayList<Pair<Materials, Long>> outputList = new ArrayList<Pair<Materials, Long>>();
        outputMap.forEach((material, quantity) -> outputList.add(Pair.of((Object)material, (Object)((long)Math.floor(quantity)))));
        return outputList;
    }

    private static ArrayList<FluidStack> validPlasmaGenerator(List<Pair<Materials, Long>> planetList) {
        ArrayList<FluidStack> plasmaList = new ArrayList<FluidStack>();
        for (Pair<Materials, Long> pair : planetList) {
            if (!VALID_PLASMAS.contains(pair.getLeft())) continue;
            plasmaList.add(((Materials)pair.getLeft()).getPlasma(1L));
        }
        return plasmaList;
    }

    private static ArrayList<ItemStackLong> validDustGenerator(ArrayList<Pair<Materials, Long>> planetList) {
        ArrayList<ItemStackLong> dustList = new ArrayList<ItemStackLong>();
        for (Pair<Materials, Long> pair : planetList) {
            ItemStack dust = GregTechAPI.getUnificatedOreDictStack(((Materials)pair.getLeft()).getDust(1));
            if (dust == null) continue;
            dustList.add(new ItemStackLong(dust, (Long)pair.getRight()));
        }
        return dustList;
    }

    private static long plasmaCostCalculator(ArrayList<FluidStackLong> plasmas) {
        long total = 0L;
        for (FluidStackLong plasma : plasmas) {
            FluidStack plasmaFluid = plasma.getRegularFluidStack(plasma, 1);
            try {
                String plasmaName = plasmaFluid.getFluid().getUnlocalizedName();
                total += plasmaEnergyMap.getOrDefault(plasmaName, 0L) * plasma.amount;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (long)((double)total * EyeOfHarmonyRecipe.getMaxPlasmaTurbineEfficiency());
    }

    private static double getMaxPlasmaTurbineEfficiency() {
        return 3.85;
    }

    public static class HashMapHelper
    extends HashMap<Materials, Double> {
        private static final long serialVersionUID = 2297018142561480614L;

        void add(Materials material, double value) {
            if (this.containsKey(material)) {
                this.put(material, value + (Double)this.get(material));
                return;
            }
            this.put(material, value);
        }
    }
}

