/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GTValues;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraftforge.common.FishingHooks;

public class FishPondFakeRecipe {
    public static final ArrayList<ItemStack> fish = new ArrayList();
    public static final ArrayList<ItemStack> junk = new ArrayList();
    public static final ArrayList<ItemStack> treasure = new ArrayList();

    public static void generateFishPondRecipes() {
        try {
            ArrayList fishList = (ArrayList)GTUtility.getField(FishingHooks.class, "fish").get(null);
            ArrayList junkList = (ArrayList)GTUtility.getField(FishingHooks.class, "junk").get(null);
            ArrayList treasureList = (ArrayList)GTUtility.getField(FishingHooks.class, "treasure").get(null);
            Field stackField = GTUtility.getField(WeightedRandomFishable.class, "field_150711_b");
            FishPondFakeRecipe.generateRecipesFor(14, fish, fishList, stackField);
            FishPondFakeRecipe.generateRecipesFor(15, junk, junkList, stackField);
            FishPondFakeRecipe.generateRecipesFor(16, treasure, treasureList, stackField);
        }
        catch (Exception e) {
            Logger.INFO("Error reading the vanilla fishing loot table.");
            e.printStackTrace();
        }
    }

    private static void generateRecipesFor(int circuitType, ArrayList<ItemStack> listToFill, ArrayList<WeightedRandomFishable> lootTable, Field stackField) {
        for (WeightedRandomFishable fishable : lootTable) {
            try {
                ItemStack stack = (ItemStack)stackField.get(fishable);
                listToFill.add(stack.func_77946_l());
                GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(circuitType)).itemOutputs(stack).duration(100).eut(0).ignoreCollision().addTo(GTPPRecipeMaps.fishPondRecipes);
            }
            catch (IllegalAccessException | IllegalArgumentException e1) {
                Logger.INFO("Error generating Fish Pond Recipes");
                e1.printStackTrace();
            }
        }
        listToFill.trimToSize();
    }
}

