/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.ingameinfo.client.gui.Info;
import com.github.lunatrius.ingameinfo.client.gui.InfoIcon;
import com.github.lunatrius.ingameinfo.client.gui.InfoText;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.List;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;

public abstract class TagMisc
extends Tag {
    protected static final ResourcePackRepository resourcePackRepository = minecraft.func_110438_M();

    @Override
    public String getCategory() {
        return "misc";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new MemoryMaximum().setName("memmax"));
        TagRegistry.INSTANCE.register(new MemoryTotal().setName("memtotal"));
        TagRegistry.INSTANCE.register(new MemoryFree().setName("memfree"));
        TagRegistry.INSTANCE.register(new MemoryUsed().setName("memused"));
        TagRegistry.INSTANCE.register(new FPS().setName("fps"));
        TagRegistry.INSTANCE.register(new ResourcePack().setName("resourcepack"));
        TagRegistry.INSTANCE.register(new EntitiesRendered().setName("entitiesrendered"));
        TagRegistry.INSTANCE.register(new EntitiesTotal().setName("entitiestotal"));
        TagRegistry.INSTANCE.register(new LoadedChunks().setName("loadedchunks"));
        TagRegistry.INSTANCE.register(new Server().setName("server"));
        TagRegistry.INSTANCE.register(new ServerName().setName("servername"));
        TagRegistry.INSTANCE.register(new ServerIP().setName("serverip"));
        TagRegistry.INSTANCE.register(new ServerPort().setName("serverport"));
        TagRegistry.INSTANCE.register(new Ping().setName("ping"));
        TagRegistry.INSTANCE.register(new PingIcon().setName("pingicon"));
    }

    public static class MemoryMaximum
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(Runtime.getRuntime().maxMemory());
        }
    }

    public static class MemoryTotal
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(Runtime.getRuntime().totalMemory());
        }
    }

    public static class MemoryFree
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(Runtime.getRuntime().freeMemory());
        }
    }

    public static class MemoryUsed
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        }
    }

    public static class FPS
    extends TagMisc {
        @Override
        public String getValue() {
            return FPS.minecraft.field_71426_K.substring(0, FPS.minecraft.field_71426_K.indexOf(" fps"));
        }
    }

    public static class ResourcePack
    extends TagMisc {
        @Override
        public String getValue() {
            List repositoryEntries = resourcePackRepository.func_110613_c();
            if (!repositoryEntries.isEmpty()) {
                return ((ResourcePackRepository.Entry)repositoryEntries.get(0)).func_110515_d();
            }
            return ResourcePack.resourcePackRepository.field_110620_b.func_130077_b();
        }
    }

    public static class EntitiesRendered
    extends TagMisc {
        @Override
        public String getValue() {
            String str = minecraft.func_71408_n();
            return str.substring(str.indexOf(32) + 1, str.indexOf(47));
        }
    }

    public static class EntitiesTotal
    extends TagMisc {
        @Override
        public String getValue() {
            String str = minecraft.func_71408_n();
            return str.substring(str.indexOf(47) + 1, str.indexOf(46));
        }
    }

    public static class LoadedChunks
    extends TagMisc {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72863_F().func_73152_e());
        }
    }

    public static class Server
    extends TagMisc {
        @Override
        public String getValue() {
            String str = Server.player.field_71174_a.func_147298_b().func_74430_c().toString();
            int i = str.indexOf("/");
            int j = str.indexOf(":");
            if (i < 0) {
                return "localhost";
            }
            String name = i == 0 ? str.substring(i + 1, j) : str.substring(0, i);
            String port = str.substring(j + 1);
            return name + (port.equals("25565") ? "" : ":" + port);
        }
    }

    public static class ServerName
    extends TagMisc {
        @Override
        public String getValue() {
            String str = ServerName.player.field_71174_a.func_147298_b().func_74430_c().toString();
            int i = str.indexOf("/");
            if (i < 0) {
                return "localhost";
            }
            if (i == 0) {
                return str.substring(i + 1, str.indexOf(":"));
            }
            return str.substring(0, i);
        }
    }

    public static class ServerIP
    extends TagMisc {
        @Override
        public String getValue() {
            String str = ServerIP.player.field_71174_a.func_147298_b().func_74430_c().toString();
            int i = str.indexOf("/");
            if (i < 0) {
                return "127.0.0.1";
            }
            return str.substring(i + 1, str.indexOf(":"));
        }
    }

    public static class ServerPort
    extends TagMisc {
        @Override
        public String getValue() {
            String str = ServerPort.player.field_71174_a.func_147298_b().func_74430_c().toString();
            int i = str.indexOf("/");
            if (i < 0) {
                return "-1";
            }
            return str.substring(str.indexOf(":") + 1);
        }
    }

    public static class Ping
    extends TagMisc {
        @Override
        public String getValue() {
            List list = Ping.player.field_71174_a.field_147303_b;
            for (GuiPlayerInfo playerInfo : list) {
                if (!player.func_146103_bH().getName().equals(playerInfo.field_78831_a)) continue;
                return String.valueOf(playerInfo.field_78829_b);
            }
            return "-1";
        }
    }

    public static class PingIcon
    extends TagMisc {
        private boolean needsUpdate(InfoText caller, int ping) {
            Info value = caller.getAttachedValue(this.getName());
            if (value == null) {
                return true;
            }
            return Integer.parseInt(value.getIdentifier()) != ping;
        }

        @Override
        @NotNull
        public String getValue(@NotNull InfoText caller) {
            List list = PingIcon.player.field_71174_a.field_147303_b;
            for (GuiPlayerInfo playerInfo : list) {
                if (!player.func_146103_bH().getName().equals(EnumChatFormatting.func_110646_a((String)playerInfo.field_78831_a))) continue;
                int pingIndex = PingIcon.getPingIndex(playerInfo);
                if (this.needsUpdate(caller, playerInfo.field_78829_b)) {
                    InfoIcon icon = new InfoIcon("textures/gui/icons.png");
                    icon.setIdentifier(String.valueOf(playerInfo.field_78829_b));
                    icon.setDisplayDimensions(0, 0, 10, 8);
                    icon.setTextureData(0, 176 + pingIndex * 8, 10, 8, 256, 256);
                    caller.attachValue(this.getName(), icon);
                    return PingIcon.getIconTag(icon);
                }
                return "";
            }
            return "-1";
        }

        private static int getPingIndex(GuiPlayerInfo playerInfo) {
            int responseTime = playerInfo.field_78829_b;
            if (responseTime < 0) {
                return 5;
            }
            if (responseTime < 150) {
                return 0;
            }
            if (responseTime < 300) {
                return 1;
            }
            if (responseTime < 600) {
                return 2;
            }
            if (responseTime < 1000) {
                return 3;
            }
            return 4;
        }

        @Override
        public String getValue() {
            return "";
        }
    }
}

