/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.fluid;

import com.gtnewhorizons.modularui.common.fluid.IOverflowableTank;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class FluidStackTank
implements IFluidTank,
IOverflowableTank {
    private final Supplier<FluidStack> getter;
    private final Consumer<FluidStack> setter;
    private final IntSupplier capacityGetter;
    private boolean allowOverflow;
    private boolean preventDraining;

    public FluidStackTank(Supplier<FluidStack> getter, Consumer<FluidStack> setter, int capacity) {
        this(getter, setter, () -> capacity);
    }

    public FluidStackTank(Supplier<FluidStack> getter, Consumer<FluidStack> setter, IntSupplier capacityGetter) {
        this.getter = getter;
        this.setter = setter;
        this.capacityGetter = capacityGetter;
    }

    public void setAllowOverflow(boolean allowOverflow) {
        this.allowOverflow = allowOverflow;
    }

    public void setPreventDraining(boolean preventDraining) {
        this.preventDraining = preventDraining;
    }

    public FluidStack getFluid() {
        return this.getter.get();
    }

    public int getFluidAmount() {
        FluidStack fluidStack = this.getter.get();
        return fluidStack != null ? fluidStack.amount : 0;
    }

    public int getCapacity() {
        return this.allowOverflow ? Integer.MAX_VALUE : this.getRealCapacity();
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        FluidStack fluid = this.getter.get();
        if (!doFill) {
            if (fluid == null) {
                return Math.min(this.getCapacity(), resource.amount);
            }
            if (!fluid.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(this.getCanFillAmount(), resource.amount);
        }
        if (fluid == null) {
            fluid = new FluidStack(resource, Math.min(this.getCapacity(), resource.amount));
            this.setter.accept(fluid);
            int retAmount = fluid.amount;
            this.validateFluid();
            return retAmount;
        }
        if (!fluid.isFluidEqual(resource)) {
            return 0;
        }
        int canFillAmount = this.getCanFillAmount();
        if (resource.amount < canFillAmount) {
            fluid.amount += resource.amount;
            canFillAmount = resource.amount;
        } else {
            fluid.amount = this.getRealCapacity();
        }
        this.validateFluid();
        return canFillAmount;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack fluid = this.getter.get();
        if (fluid == null) {
            return null;
        }
        int drained = maxDrain;
        if (fluid.amount < drained) {
            drained = fluid.amount;
        }
        FluidStack stack = new FluidStack(fluid, drained);
        if (doDrain) {
            fluid.amount -= drained;
            if (fluid.amount <= 0 && !this.preventDraining) {
                this.setter.accept(null);
            }
        }
        return stack;
    }

    @Override
    public int getRealCapacity() {
        return this.capacityGetter.getAsInt();
    }

    public int getCanFillAmount() {
        FluidStack fluid = this.getter.get();
        if (fluid == null) {
            return 0;
        }
        return this.allowOverflow ? Integer.MAX_VALUE : this.getRealCapacity() - fluid.amount;
    }

    public void validateFluid() {
        FluidStack fluid = this.getter.get();
        if (fluid == null) {
            return;
        }
        fluid.amount = Math.min(fluid.amount, this.getRealCapacity());
    }
}

