/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.fluids;

import com.google.common.primitives.Ints;
import com.gtnewhorizons.modularui.api.fluids.FluidTankLong;
import com.gtnewhorizons.modularui.api.fluids.IFluidTankLong;
import com.gtnewhorizons.modularui.common.fluid.IOverflowableTank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.Nullable;

public class FluidTankLongDelegate
implements IFluidTankLong {
    private final IFluidTank tank;

    public FluidTankLongDelegate(IFluidTank tank) {
        this.tank = tank;
    }

    @Override
    public long fill(Fluid fluid, long amount, boolean doFill) {
        return this.tank.fill(new FluidStack(fluid, Ints.saturatedCast((long)amount)), doFill);
    }

    @Override
    public FluidStack drain(long amount, boolean doDrain) {
        return this.tank.drain(Ints.saturatedCast((long)amount), doDrain);
    }

    @Override
    public long getCapacityLong() {
        return this.tank.getCapacity();
    }

    @Override
    public long getRealCapacityLong() {
        if (this.tank instanceof IOverflowableTank) {
            return ((IOverflowableTank)this.tank).getRealCapacity();
        }
        return this.tank.getCapacity();
    }

    @Override
    public long getFluidAmountLong() {
        return this.tank.getFluidAmount();
    }

    @Override
    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    @Override
    public Fluid getStoredFluid() {
        return this.tank.getFluid() != null ? this.tank.getFluid().getFluid() : null;
    }

    @Override
    public void setFluid(Fluid fluid, long amount) {
        this.tank.drain(Integer.MAX_VALUE, true);
        this.tank.fill(new FluidStack(fluid, Ints.saturatedCast((long)amount)), true);
    }

    @Override
    @Nullable
    public IFluidTankLong copy() {
        return new FluidTankLong(this.getStoredFluid(), this.getCapacityLong(), this.getFluidAmountLong());
    }

    @Override
    public boolean isFluidEqual(@Nullable IFluidTankLong cached) {
        return cached == null && this.tank.getFluid() == null || cached != null && cached.getFluidStack() == null && this.tank.getFluid() == null || cached != null && this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(cached.getFluidStack());
    }

    @Override
    public void saveToNBT(NBTTagCompound fluidTag) {
        if (this.tank.getFluid() == null) {
            return;
        }
        this.tank.getFluid().writeToNBT(fluidTag);
    }

    @Override
    public void loadFromNBT(NBTTagCompound fluidTag) {
        this.tank.drain(Integer.MAX_VALUE, true);
        this.tank.fill(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag), true);
    }
}

