/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent17;
import net.minecraftforge.common.MinecraftForge;
import openblocks.Config;
import openblocks.client.Icons;
import openblocks.client.SoundIconRegistry;
import openblocks.common.item.ItemSonicGlasses;
import openmods.config.properties.ConfigurationChange;
import openmods.renderer.ManualDisplayList;
import openmods.utils.render.RenderUtils;
import org.lwjgl.opengl.GL11;

public class SoundEventsManager {
    public static final SoundEventsManager instance = new SoundEventsManager();
    public final SoundIconRegistry icons = new SoundIconRegistry();
    private final List<SoundEvent> events = Lists.newLinkedList();
    private ManualDisplayList notPumpkinOverlay = new ManualDisplayList();
    private static final ResourceLocation notPumpkin = new ResourceLocation("openblocks:textures/misc/glasses_obsidian.png");

    private SoundEventsManager() {
    }

    public void init() {
        this.icons.registerDefaults();
        MinecraftForge.EVENT_BUS.register((Object)this.icons);
    }

    public static boolean isEntityWearingGlasses(Entity e) {
        if (e instanceof EntityPlayer) {
            ItemStack helmet = ((EntityPlayer)e).field_71071_by.func_70440_f(3);
            return helmet != null && helmet.func_77973_b() instanceof ItemSonicGlasses;
        }
        return false;
    }

    public static boolean isPlayerWearingGlasses() {
        EntityLivingBase e = FMLClientHandler.instance().getClient().field_71451_h;
        return SoundEventsManager.isEntityWearingGlasses((Entity)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onSoundEvent(PlaySoundEvent17 evt) {
        if (SoundEventsManager.isPlayerWearingGlasses()) {
            ISound sound = evt.sound;
            Icons.IDrawableIcon icon = this.icons.getIcon(sound.func_147650_b());
            List<SoundEvent> list = this.events;
            synchronized (list) {
                this.events.add(new SoundEvent(sound, icon, Math.log(sound.func_147653_e() + 1.0f), sound.func_147655_f()));
            }
        }
    }

    @SubscribeEvent
    public void onReconfig(ConfigurationChange.Post evt) {
        if (evt.category.equals("glasses")) {
            this.notPumpkinOverlay.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tickUpdate() {
        List<SoundEvent> list = this.events;
        synchronized (list) {
            SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
            Iterator<SoundEvent> it = this.events.iterator();
            while (it.hasNext()) {
                SoundEvent evt = it.next();
                evt.update(handler);
                if (evt.isAlive()) continue;
                it.remove();
            }
        }
    }

    private void dimWorld(final TextureManager tex, final Minecraft mc) {
        final double level = Config.sonicGlassesOpacity;
        if (level <= 0.0) {
            return;
        }
        if (level >= 1.0 && !Config.sonicGlassesUseTexture) {
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClear((int)16384);
            return;
        }
        if (!this.notPumpkinOverlay.isCompiled()) {
            this.notPumpkinOverlay.compile(new ManualDisplayList.Renderer(){

                public void render() {
                    GL11.glMatrixMode((int)5888);
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                    GL11.glMatrixMode((int)5889);
                    GL11.glPushMatrix();
                    GL11.glLoadIdentity();
                    GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0);
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)2929);
                    GL11.glDisable((int)3008);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    float maxU = (float)mc.field_71443_c / 1024.0f;
                    float maxV = (float)mc.field_71440_d / 1024.0f;
                    if (Config.sonicGlassesUseTexture) {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)level));
                        tex.func_110577_a(notPumpkin);
                        GL11.glBegin((int)7);
                        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)0.0f);
                        GL11.glTexCoord2f((float)maxU, (float)0.0f);
                        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)0.0f);
                        GL11.glTexCoord2f((float)maxU, (float)maxV);
                        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
                        GL11.glTexCoord2f((float)0.0f, (float)maxV);
                        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)0.0f);
                        GL11.glEnd();
                    } else {
                        GL11.glDisable((int)3553);
                        GL11.glColor4f((float)0.085f, (float)0.074f, (float)0.129f, (float)((float)level));
                        GL11.glBegin((int)7);
                        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)0.0f);
                        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)0.0f);
                        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
                        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)0.0f);
                        GL11.glEnd();
                        GL11.glEnable((int)3553);
                    }
                    GL11.glDisable((int)3042);
                    GL11.glEnable((int)2929);
                    GL11.glEnable((int)3008);
                    GL11.glEnable((int)2896);
                    GL11.glPopMatrix();
                    GL11.glMatrixMode((int)5888);
                    GL11.glPopMatrix();
                }
            });
        }
        this.notPumpkinOverlay.render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderEvents(RenderWorldLastEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O != 0) {
            return;
        }
        TextureManager tex = mc.field_71446_o;
        EntityLivingBase rve = mc.field_71451_h;
        if (!SoundEventsManager.isEntityWearingGlasses((Entity)rve)) {
            return;
        }
        GL11.glDisable((int)2912);
        GL11.glClear((int)256);
        this.dimWorld(tex, mc);
        double interpX = rve.field_70169_q + (rve.field_70165_t - rve.field_70169_q) * (double)evt.partialTicks;
        double interpY = rve.field_70167_r + (rve.field_70163_u - rve.field_70167_r) * (double)evt.partialTicks;
        double interpZ = rve.field_70166_s + (rve.field_70161_v - rve.field_70166_s) * (double)evt.partialTicks;
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        List<SoundEvent> list = this.events;
        synchronized (list) {
            for (SoundEvent snd : this.events) {
                double px = (double)snd.sound.func_147649_g() - interpX;
                double py = (double)snd.sound.func_147654_h() - interpY;
                double pz = (double)snd.sound.func_147651_i() - interpZ;
                GL11.glPushMatrix();
                GL11.glTranslated((double)px, (double)py, (double)pz);
                RenderUtils.setupBillboard((Entity)rve);
                snd.icon.draw(tex, snd.getAlpha(evt.partialTicks), snd.size);
                GL11.glPopMatrix();
            }
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    private static class SoundEvent {
        public final Icons.IDrawableIcon icon;
        public final double size;
        public final ISound sound;
        private boolean isPlaying = true;
        private int ticks;
        private final int TTL;

        private SoundEvent(ISound sound, Icons.IDrawableIcon icon, double size, double TTL) {
            this.sound = sound;
            this.icon = icon;
            this.size = size;
            this.TTL = MathHelper.func_76128_c((double)(20.0 * TTL));
        }

        public void update(SoundHandler handler) {
            if (this.isPlaying) {
                this.isPlaying = handler.func_147692_c(this.sound);
            } else {
                ++this.ticks;
            }
        }

        public boolean isAlive() {
            return this.ticks <= this.TTL;
        }

        public double getAlpha(double partialTick) {
            return 1.0 - ((double)this.ticks + partialTick) / (double)this.TTL;
        }
    }
}

