/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.ChunkCoordIntPair;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.events.team.ForgeTeamConfigEvent;
import serverutils.events.team.ForgeTeamDeletedEvent;
import serverutils.events.team.ForgeTeamLoadedEvent;
import serverutils.events.team.ForgeTeamSavedEvent;
import serverutils.lib.EnumTeamStatus;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.data.TeamData;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.NBTUtils;

public class ServerUtilitiesTeamData
extends TeamData {
    private EnumTeamStatus editBlocks = EnumTeamStatus.ALLY;
    private EnumTeamStatus interactWithBlocks = EnumTeamStatus.ALLY;
    private EnumTeamStatus attackEntities = EnumTeamStatus.ALLY;
    private EnumTeamStatus useItems = EnumTeamStatus.ALLY;
    private boolean explosions = false;
    public boolean canForceChunks = false;
    private int cachedMaxClaimChunks;
    private int cachedMaxChunkloaderChunks;
    public boolean chunkloadsDecayed;

    public static ServerUtilitiesTeamData get(ForgeTeam team) {
        return (ServerUtilitiesTeamData)team.getData().get("serverutilities");
    }

    @SubscribeEvent
    public void onTeamSaved(ForgeTeamSavedEvent event) {
        if (!ClaimedChunks.isActive() && !ClaimedChunks.isForcedToSave()) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        Int2ObjectOpenHashMap claimedChunks = new Int2ObjectOpenHashMap();
        for (ClaimedChunk chunk : ClaimedChunks.instance.getTeamChunks(event.getTeam(), OptionalInt.empty(), ClaimedChunks.isForcedToSave())) {
            ChunkDimPos pos = chunk.getPos();
            NBTTagList list = (NBTTagList)claimedChunks.get(pos.dim);
            if (list == null) {
                list = new NBTTagList();
                claimedChunks.put(pos.dim, (Object)list);
            }
            NBTTagCompound chunkNBT = new NBTTagCompound();
            chunkNBT.func_74768_a("x", pos.posX);
            chunkNBT.func_74768_a("z", pos.posZ);
            chunkNBT.func_74757_a("preDecay", chunk.preDecay);
            if (chunk.isLoaded()) {
                chunkNBT.func_74757_a("loaded", true);
            }
            list.func_74742_a((NBTBase)chunkNBT);
        }
        NBTTagCompound claimedChunksTag = new NBTTagCompound();
        for (Map.Entry entry : claimedChunks.int2ObjectEntrySet()) {
            claimedChunksTag.func_74782_a(((Integer)entry.getKey()).toString(), (NBTBase)entry.getValue());
        }
        if (!claimedChunksTag.func_82582_d()) {
            nbt.func_74782_a("ClaimedChunks", (NBTBase)claimedChunksTag);
        }
        File file = event.getTeam().getDataFile("claimedchunks");
        if (nbt.func_82582_d()) {
            FileUtils.deleteSafe(file);
        } else {
            NBTUtils.writeNBTSafe(file, nbt);
        }
    }

    @SubscribeEvent
    public void onTeamLoaded(ForgeTeamLoadedEvent event) {
        if (!ClaimedChunks.isActive()) {
            return;
        }
        NBTTagCompound nbt = NBTUtils.readNBT(event.getTeam().getDataFile("claimedchunks"));
        if (nbt == null) {
            return;
        }
        ServerUtilitiesTeamData data = ServerUtilitiesTeamData.get(event.getTeam());
        NBTTagCompound claimedChunksTag = nbt.func_74775_l("ClaimedChunks");
        for (String dim : claimedChunksTag.func_150296_c()) {
            NBTTagList list = claimedChunksTag.func_150295_c(dim, 10);
            int dimInt = Integer.parseInt(dim);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound chunkNBT = list.func_150305_b(i);
                ClaimedChunk chunk = new ClaimedChunk(new ChunkDimPos(new ChunkCoordIntPair(chunkNBT.func_74762_e("x"), chunkNBT.func_74762_e("z")), dimInt), data);
                chunk.setLoaded(chunkNBT.func_74767_n("loaded"));
                chunk.preDecay = chunkNBT.func_74767_n("preDecay");
                ClaimedChunks.instance.addChunk(chunk);
            }
        }
    }

    @SubscribeEvent
    public void getTeamSettings(ForgeTeamConfigEvent event) {
        ServerUtilitiesTeamData.get(event.getTeam()).addConfig(event.getConfig());
    }

    @SubscribeEvent
    public void onTeamDeleted(ForgeTeamDeletedEvent event) {
        if (ClaimedChunks.isActive()) {
            ClaimedChunks.instance.unclaimAllChunks(event.getTeam().getOwner(), event.getTeam(), OptionalInt.empty());
        }
    }

    ServerUtilitiesTeamData(ForgeTeam t) {
        super(t);
    }

    @Override
    public String getId() {
        return "serverutilities";
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("Explosions", this.explosions);
        nbt.func_74778_a("EditBlocks", this.editBlocks.getName());
        nbt.func_74778_a("InteractWithBlocks", this.interactWithBlocks.getName());
        nbt.func_74778_a("AttackEntities", this.attackEntities.getName());
        nbt.func_74778_a("UseItems", this.useItems.getName());
        nbt.func_74757_a("DecayedChunkloads", this.chunkloadsDecayed);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.explosions = nbt.func_74767_n("Explosions");
        this.editBlocks = EnumTeamStatus.NAME_MAP_PERMS.get(nbt.func_74779_i("EditBlocks"));
        this.interactWithBlocks = EnumTeamStatus.NAME_MAP_PERMS.get(nbt.func_74779_i("InteractWithBlocks"));
        this.attackEntities = EnumTeamStatus.NAME_MAP_PERMS.get(nbt.func_74779_i("AttackEntities"));
        this.useItems = EnumTeamStatus.NAME_MAP_PERMS.get(nbt.func_74779_i("UseItems"));
        this.chunkloadsDecayed = nbt.func_74767_n("DecayedChunkloads");
        if (ClaimedChunks.isActive() && nbt.func_74764_b("ClaimedChunks")) {
            this.team.markDirty();
            NBTTagCompound claimedChunksTag = nbt.func_74775_l("ClaimedChunks");
            for (String dim : claimedChunksTag.func_150296_c()) {
                NBTTagList list = claimedChunksTag.func_150295_c(dim, 10);
                int dimInt = Integer.parseInt(dim);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound chunkNBT = list.func_150305_b(i);
                    ClaimedChunk chunk = new ClaimedChunk(new ChunkDimPos(new ChunkCoordIntPair(chunkNBT.func_74762_e("x"), chunkNBT.func_74762_e("z")), dimInt), this);
                    chunk.setLoaded(chunkNBT.func_74767_n("loaded"));
                    ClaimedChunks.instance.addChunk(chunk);
                }
            }
        }
    }

    private void addConfig(ConfigGroup main) {
        ConfigGroup group = main.getGroup("serverutilities");
        group.setDisplayName((IChatComponent)new ChatComponentText("Server Utilities"));
        group.addBool("explosions", () -> this.explosions, v -> {
            this.explosions = v;
        }, false).setCanEdit(ServerUtilitiesConfig.world.enable_explosions.isDefault());
        group.addEnum("blocks_edit", () -> this.editBlocks, v -> {
            this.editBlocks = v;
        }, EnumTeamStatus.NAME_MAP_PERMS).setCanEdit(ServerUtilitiesConfig.teams.grief_protection);
        group.addEnum("blocks_interact", () -> this.interactWithBlocks, v -> {
            this.interactWithBlocks = v;
        }, EnumTeamStatus.NAME_MAP_PERMS).setCanEdit(ServerUtilitiesConfig.teams.interaction_protection);
        group.addEnum("attack_entities", () -> this.attackEntities, v -> {
            this.attackEntities = v;
        }, EnumTeamStatus.NAME_MAP_PERMS);
        group.addEnum("use_items", () -> this.useItems, v -> {
            this.useItems = v;
        }, EnumTeamStatus.NAME_MAP_PERMS).setCanEdit(ServerUtilitiesConfig.teams.grief_protection);
    }

    public EnumTeamStatus getEditBlocksStatus() {
        return this.editBlocks;
    }

    public EnumTeamStatus getInteractWithBlocksStatus() {
        return this.interactWithBlocks;
    }

    public EnumTeamStatus getAttackEntitiesStatus() {
        return this.attackEntities;
    }

    public EnumTeamStatus getUseItemsStatus() {
        return this.useItems;
    }

    public boolean hasExplosions() {
        return this.explosions;
    }

    public int getMaxClaimChunks() {
        if (!ClaimedChunks.isActive()) {
            return -1;
        }
        if (!this.team.isValid()) {
            return -2;
        }
        if (this.cachedMaxClaimChunks >= 0) {
            return this.cachedMaxClaimChunks;
        }
        this.cachedMaxClaimChunks = 0;
        for (ForgePlayer player : this.team.getMembers()) {
            this.cachedMaxClaimChunks += player.getRankConfig("serverutilities.claims.max_chunks").getInt();
        }
        return this.cachedMaxClaimChunks;
    }

    public int getMaxChunkloaderChunks() {
        if (!ClaimedChunks.isActive()) {
            return -1;
        }
        if (!this.team.isValid()) {
            return -2;
        }
        if (this.cachedMaxChunkloaderChunks >= 0) {
            return this.cachedMaxChunkloaderChunks;
        }
        this.cachedMaxChunkloaderChunks = 0;
        for (ForgePlayer player : this.team.getMembers()) {
            this.cachedMaxChunkloaderChunks += player.getRankConfig("serverutilities.chunkloader.max_chunks").getInt();
        }
        return this.cachedMaxChunkloaderChunks;
    }

    public Set<ClaimedChunk> getTeamChunks() {
        if (!ClaimedChunks.isActive()) {
            return Collections.emptySet();
        }
        return ClaimedChunks.instance.getTeamChunks(this.team, OptionalInt.empty());
    }

    @Override
    public void clearCache() {
        this.cachedMaxClaimChunks = -1;
        this.cachedMaxChunkloaderChunks = -1;
    }

    public void decayChunkloads() {
        this.chunkloadsDecayed = true;
        for (ClaimedChunk chunk : this.getTeamChunks()) {
            if (!chunk.isLoaded()) continue;
            chunk.preDecay = true;
            chunk.setLoaded(false);
        }
        this.team.markDirty();
    }

    public void unDecayChunkloads() {
        this.chunkloadsDecayed = false;
        for (ClaimedChunk chunk : this.getTeamChunks()) {
            if (!chunk.preDecay) continue;
            chunk.preDecay = false;
            chunk.setLoaded(true);
        }
        this.team.markDirty();
    }
}

