/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei.arcaneworkbench;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.ModItems;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.NEIHelper;
import com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler.ArcaneShapedRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.tcneiadditions.client.TCNAClient;
import ru.timeconqueror.tcneiadditions.nei.arcaneworkbench.IArcaneOverlayProvider;
import ru.timeconqueror.tcneiadditions.util.GuiRecipeHelper;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import ru.timeconqueror.tcneiadditions.util.TCUtil;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ArcaneCraftingShapedHandler
extends ArcaneShapedRecipeHandler {
    private final String userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private int ySizeNormal;
    private int ySizeRod;
    private int ySizeCap;
    private TCNAClient tcnaClient = TCNAClient.getInstance();

    public void loadTransferRects() {
        TCUtil.loadTransferRects((TemplateRecipeHandler)this);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                boolean shouldShowRecipe;
                ShapedArcaneRecipe tcRecipe;
                ArcaneShapedCachedRecipe recipe;
                if (!(o instanceof ShapedArcaneRecipe) || !(recipe = new ArcaneShapedCachedRecipe(tcRecipe = (ShapedArcaneRecipe)o, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch()))).isValid()) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)tcRecipe));
            }
        } else if (outputId.equals("item")) {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)result.func_77973_b();
            WandRod rod = wand.getRod(result);
            WandCap cap = wand.getCap(result);
            boolean shouldShowRecipe = false;
            if ((!wand.isSceptre(result) || TCUtil.shouldShowRecipe(this.userName, "SCEPTRE")) && TCUtil.shouldShowRecipe(this.userName, cap.getResearch()) && TCUtil.shouldShowRecipe(this.userName, rod.getResearch())) {
                shouldShowRecipe = true;
            }
            if (!TCNAClient.getInstance().areWandRecipesDeleted()) {
                ArcaneWandCachedRecipe recipe = new ArcaneWandCachedRecipe(rod, cap, result, wand.isSceptre(result), shouldShowRecipe);
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(NEIHelper.getWandAspectsWandCost((ItemStack)result));
            }
            this.loadShapedRecipesForWands(result, shouldShowRecipe);
        } else {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                boolean shouldShowRecipe;
                ShapedArcaneRecipe shapedArcaneRecipe;
                ArcaneShapedCachedRecipe recipe;
                if (!(o instanceof ShapedArcaneRecipe) || !(recipe = new ArcaneShapedCachedRecipe(shapedArcaneRecipe = (ShapedArcaneRecipe)o, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, shapedArcaneRecipe.getResearch()))).isValid() || !NEIServerUtils.areStacksSameTypeCraftingWithNBT((ItemStack)shapedArcaneRecipe.getRecipeOutput(), (ItemStack)result)) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)shapedArcaneRecipe));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Object o : ThaumcraftApi.getCraftingRecipes()) {
            ShapedArcaneRecipe tcRecipe;
            ArcaneShapedCachedRecipe recipe;
            if (!(o instanceof ShapedArcaneRecipe) || !(recipe = new ArcaneShapedCachedRecipe(tcRecipe = (ShapedArcaneRecipe)o, true)).isValid() || !recipe.containsWithNBT(recipe.ingredients, ingredient) || !TCUtil.shouldShowRecipe(this.userName, tcRecipe.getResearch())) continue;
            recipe.computeVisuals();
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)tcRecipe));
        }
    }

    public void loadShapedRecipesForWands(ItemStack wandStack, boolean shouldShowRecipe) {
        if (!(wandStack.func_77973_b() instanceof ItemWandCasting)) {
            throw new RuntimeException("This method works only for Thaumcraft Wands! Provided: " + wandStack);
        }
        ItemWandCasting wand = (ItemWandCasting)wandStack.func_77973_b();
        WandRod rod = wand.getRod(wandStack);
        WandCap cap = wand.getCap(wandStack);
        boolean isSceptre = wand.isSceptre(wandStack);
        ThaumcraftApi.getCraftingRecipes().stream().filter(o -> o instanceof ShapedArcaneRecipe).filter(r -> {
            ItemStack output = ((ShapedArcaneRecipe)r).output;
            if (!(output.func_77973_b() instanceof ItemWandCasting)) {
                return false;
            }
            if (isSceptre != wand.isSceptre(output)) {
                return false;
            }
            if (output.func_77973_b().getClass() != wandStack.func_77973_b().getClass()) {
                return false;
            }
            WandRod outputRod = wand.getRod(output);
            WandCap outputCap = wand.getCap(output);
            return outputRod.getTag().equals(rod.getTag()) && outputCap.getTag().equals(cap.getTag());
        }).forEach(o -> {
            ShapedArcaneRecipe arcaneRecipe = (ShapedArcaneRecipe)o;
            ArcaneShapedCachedRecipe recipe = new ArcaneShapedCachedRecipe(arcaneRecipe, shouldShowRecipe);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            this.aspectsAmount.add(ArcaneCraftingShapedHandler.getAmounts((ShapedArcaneRecipe)arcaneRecipe));
        });
    }

    public void drawBackground(int recipeIndex) {
        boolean shouldShowRecipe;
        ShapedRecipeHandler.CachedShapedRecipe recipe;
        TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (cRecipe instanceof ArcaneShapedCachedRecipe) {
            recipe = (ArcaneShapedCachedRecipe)cRecipe;
            shouldShowRecipe = ((ArcaneShapedCachedRecipe)recipe).shouldShowRecipe;
        } else if (cRecipe instanceof ArcaneWandCachedRecipe) {
            recipe = (ArcaneWandCachedRecipe)cRecipe;
            shouldShowRecipe = ((ArcaneWandCachedRecipe)recipe).shouldShowRecipe;
        } else {
            throw new RuntimeException("Incompatible recipe type found: " + cRecipe.getClass());
        }
        if (shouldShowRecipe) {
            super.drawBackground(recipeIndex);
            this.drawAspects(recipeIndex);
            return;
        }
        int x = 34;
        int y = -15;
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.7f, (float)1.7f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)20, (int)7, (int)20, (int)3, (int)16, (int)16);
        GL11.glPopMatrix();
    }

    public void drawAspects(int recipe) {
        int[] amounts = (int[])this.aspectsAmount.get(recipe);
        AspectList aspects = NEIHelper.getPrimalAspectListFromAmounts((int[])amounts);
        int baseX = 36;
        int baseY = 115;
        int count = 0;
        int columns = aspects.size();
        int xOffset = (100 - columns * 20) / 2;
        for (int column = 0; column < columns; ++column) {
            Aspect aspect = aspects.getAspectsSortedAmount()[count++];
            int posX = baseX + column * 18 + xOffset;
            UtilsFX.drawTag((int)posX, (int)baseY, (Aspect)aspect, (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
        }
    }

    public List<PositionedStack> getIngredientStacksForOverlay(int recipeIndex) {
        TemplateRecipeHandler.CachedRecipe recipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        return recipe instanceof IArcaneOverlayProvider ? ((IArcaneOverlayProvider)recipe).getPositionedStacksForOverlay() : null;
    }

    public void drawExtras(int recipeIndex) {
        boolean shouldShowRecipe;
        ResearchItem researchItemNormal = null;
        ResearchItem researchItemRod = null;
        ResearchItem researchItemCap = null;
        TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        ItemStack result = cRecipe.getResult().item;
        if (result.func_77973_b() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)result.func_77973_b();
            WandRod rod = wand.getRod(result);
            WandCap cap = wand.getCap(result);
            if (cRecipe instanceof ArcaneShapedCachedRecipe) {
                shouldShowRecipe = ((ArcaneShapedCachedRecipe)cRecipe).shouldShowRecipe;
            } else if (cRecipe instanceof ArcaneWandCachedRecipe) {
                shouldShowRecipe = ((ArcaneWandCachedRecipe)cRecipe).shouldShowRecipe;
            } else {
                throw new RuntimeException("Incompatible recipe type found: " + cRecipe.getClass());
            }
            researchItemRod = ResearchCategories.getResearch((String)rod.getResearch());
            researchItemCap = ResearchCategories.getResearch((String)cap.getResearch());
        } else if (cRecipe instanceof ArcaneShapedCachedRecipe) {
            ArcaneShapedCachedRecipe recipe = (ArcaneShapedCachedRecipe)cRecipe;
            shouldShowRecipe = recipe.shouldShowRecipe;
            researchItemNormal = recipe.researchItem;
        } else {
            throw new RuntimeException("Incompatible recipe type found: " + cRecipe.getClass());
        }
        if (!shouldShowRecipe) {
            String textToDraw = StatCollector.func_74838_a((String)"tcneiadditions.research.missing");
            int y = 28;
            for (String text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
                GuiDraw.drawStringC((String)text, (int)82, (int)y, (int)this.tcnaClient.getColor("tcneiadditions.gui.textColor"), (boolean)false);
                y += 11;
            }
        }
        if (TCNAConfig.showResearchKey) {
            ArrayList<String> list;
            List listResearchString;
            int y = 135;
            if (researchItemNormal != null) {
                String researchString = EnumChatFormatting.UNDERLINE + ResearchCategories.getCategoryName((String)researchItemNormal.category) + " : " + researchItemNormal.getName();
                listResearchString = Minecraft.func_71410_x().field_71466_p.func_78271_c(researchString, 162);
                this.ySizeNormal = listResearchString.size() * 11;
                list = new ArrayList<String>();
                list.add(StatCollector.func_74838_a((String)"tcneiadditions.research.researchName") + ":");
                list.addAll(listResearchString);
                for (String text : list) {
                    GuiDraw.drawStringC((String)text, (int)82, (int)y, (int)this.tcnaClient.getColor("tcneiadditions.gui.researchNameColor"), (boolean)false);
                    y += 11;
                }
            } else {
                if (researchItemRod != null) {
                    String researchRodString = EnumChatFormatting.UNDERLINE + ResearchCategories.getCategoryName((String)researchItemRod.category) + " : " + researchItemRod.getName();
                    listResearchString = Minecraft.func_71410_x().field_71466_p.func_78271_c(researchRodString, 162);
                    this.ySizeRod = listResearchString.size() * 11;
                    list = new ArrayList();
                    list.add(StatCollector.func_74838_a((String)"tcneiadditions.research.researchName_rod") + ":");
                    list.addAll(listResearchString);
                    for (String text : list) {
                        GuiDraw.drawStringC((String)text, (int)82, (int)y, (int)this.tcnaClient.getColor("tcneiadditions.gui.researchNameColor"), (boolean)false);
                        y += 11;
                    }
                }
                if (researchItemCap != null) {
                    String researchCapString = EnumChatFormatting.UNDERLINE + ResearchCategories.getCategoryName((String)researchItemCap.category) + " : " + researchItemCap.getName();
                    listResearchString = Minecraft.func_71410_x().field_71466_p.func_78271_c(researchCapString, 162);
                    this.ySizeCap = listResearchString.size() * 11;
                    list = new ArrayList();
                    list.add(StatCollector.func_74838_a((String)"tcneiadditions.research.researchName_cap") + ":");
                    list.addAll(listResearchString);
                    for (String text : list) {
                        GuiDraw.drawStringC((String)text, (int)82, (int)y, (int)this.tcnaClient.getColor("tcneiadditions.gui.researchNameColor"), (boolean)false);
                        y += 11;
                    }
                }
            }
        }
        TCUtil.drawSeeAllRecipesLabel();
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> list, int recipeIndex) {
        if (TCNAConfig.showResearchKey && GuiContainerManager.shouldShowTooltip(gui) && list.size() == 0) {
            TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
            ItemStack result = cRecipe.getResult().item;
            Point mousePos = GuiDraw.getMousePosition();
            if (result.func_77973_b() instanceof ItemWandCasting) {
                ItemWandCasting wand = (ItemWandCasting)result.func_77973_b();
                WandRod rod = wand.getRod(result);
                WandCap cap = wand.getCap(result);
                ResearchItem researchItemRod = ResearchCategories.getResearch((String)rod.getResearch());
                ResearchItem researchItemCap = ResearchCategories.getResearch((String)cap.getResearch());
                Rectangle rectangleRod = this.getResearchRodRect(gui, recipeIndex);
                Rectangle rectangleCap = this.getResearchCapRect(gui, recipeIndex);
                if (rectangleRod.contains(mousePos)) {
                    TCUtil.getResearchPrerequisites(list, researchItemRod);
                }
                if (rectangleCap.contains(mousePos)) {
                    TCUtil.getResearchPrerequisites(list, researchItemCap);
                }
            } else if (cRecipe instanceof ArcaneShapedCachedRecipe) {
                ArcaneShapedCachedRecipe recipe = (ArcaneShapedCachedRecipe)cRecipe;
                Rectangle rectangle = this.getResearchNormalRect(gui, recipeIndex);
                if (rectangle.contains(mousePos)) {
                    TCUtil.getResearchPrerequisites(list, recipe.researchItem);
                }
            }
        }
        return super.handleTooltip(gui, list, recipeIndex);
    }

    protected Rectangle getResearchNormalRect(GuiRecipe<?> gui, int recipeIndex) {
        Point offset = gui.getRecipePosition(recipeIndex);
        return new Rectangle(GuiRecipeHelper.getGuiLeft(gui) + offset.x + 2, GuiRecipeHelper.getGuiTop(gui) + offset.y + 146, GuiRecipeHelper.getXSize(gui) - 9, this.ySizeNormal);
    }

    protected Rectangle getResearchRodRect(GuiRecipe<?> gui, int recipeIndex) {
        Point offset = gui.getRecipePosition(recipeIndex);
        return new Rectangle(GuiRecipeHelper.getGuiLeft(gui) + offset.x + 2, GuiRecipeHelper.getGuiTop(gui) + offset.y + 146, GuiRecipeHelper.getXSize(gui) - 9, this.ySizeRod);
    }

    protected Rectangle getResearchCapRect(GuiRecipe<?> gui, int recipeIndex) {
        Point offset = gui.getRecipePosition(recipeIndex);
        return new Rectangle(GuiRecipeHelper.getGuiLeft(gui) + offset.x + 2, GuiRecipeHelper.getGuiTop(gui) + offset.y + 157 + this.ySizeRod, GuiRecipeHelper.getXSize(gui) - 9, this.ySizeCap);
    }

    private class ArcaneShapedCachedRecipe
    extends ShapedRecipeHandler.CachedShapedRecipe
    implements IArcaneOverlayProvider {
        protected AspectList aspects;
        protected Object[] overlay;
        protected int width;
        protected int height;
        private final boolean shouldShowRecipe;
        private final ResearchItem researchItem;

        public ArcaneShapedCachedRecipe(ShapedArcaneRecipe recipe, boolean shouldShowRecipe) {
            super((ShapedRecipeHandler)ArcaneCraftingShapedHandler.this, recipe.width, recipe.height, recipe.getInput(), recipe.getRecipeOutput());
            this.result = new PositionedStack((Object)recipe.getRecipeOutput(), 74, 2);
            this.aspects = recipe.getAspects();
            this.overlay = recipe.getInput();
            this.width = recipe.width;
            this.height = recipe.height;
            this.shouldShowRecipe = shouldShowRecipe;
            this.researchItem = ResearchCategories.getResearch((String)recipe.getResearch());
            this.addAspectsToIngredients(this.aspects);
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public void setIngredients(int width, int height, Object[] items) {
            if (items != null && items.length > 0) {
                int y;
                int x;
                int[][][] positions2 = new int[width][height][2];
                int shiftX = 0;
                int shiftY = 0;
                for (x = 0; x < width && x < 3; ++x) {
                    for (y = 0; y < height && y < 3; ++y) {
                        positions2[x][y][0] = ArcaneShapedRecipeHandler.positions[y][x][0];
                        positions2[x][y][1] = ArcaneShapedRecipeHandler.positions[y][x][1];
                    }
                }
                for (x = 0; x < width && x < 3; ++x) {
                    for (y = 0; y < height && y < 3; ++y) {
                        if (items[y * width + x] == null || !(items[y * width + x] instanceof ItemStack) && !(items[y * width + x] instanceof ItemStack[]) && !(items[y * width + x] instanceof String) && !(items[y * width + x] instanceof List) || items[y * width + x] instanceof List && ((List)items[y * width + x]).isEmpty()) continue;
                        PositionedStack stack = new PositionedStack(items[y * width + x], positions2[x][y][0] + shiftX, positions2[x][y][1] + shiftY, false);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            if (!this.shouldShowRecipe) {
                return Collections.emptyList();
            }
            return super.getIngredients();
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return;
            }
            super.setIngredientPermutation(ingredients, ingredient);
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)ingredient).getAspects()[0];
                return this.aspects.aspects.containsKey(aspect);
            }
            return super.contains(ingredients, ingredient);
        }

        @Override
        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                for (int x = 0; x < this.width; ++x) {
                    for (int y = 0; y < this.height; ++y) {
                        Object object = this.overlay[y * this.width + x];
                        if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && (!(object instanceof List) || ((List)object).isEmpty())) continue;
                        stacks.add(new PositionedStack(object, 40 + x * 24, 40 + y * 24));
                    }
                }
            }
            return stacks;
        }

        protected void addAspectsToIngredients(AspectList aspects) {
            int baseX = 36;
            int baseY = 115;
            int count = 0;
            int columns = aspects.size();
            int xOffset = (100 - columns * 20) / 2;
            for (int column = 0; column < columns; ++column) {
                Aspect aspect = aspects.getAspectsSortedAmount()[count++];
                int posX = baseX + column * 18 + xOffset;
                ItemStack stack = new ItemStack(ModItems.itemAspect, aspects.getAmount(aspect), 1);
                ItemAspect.setAspect((ItemStack)stack, (Aspect)aspect);
                this.ingredients.add(new PositionedStack((Object)stack, posX, baseY, false));
            }
        }
    }

    private class ArcaneWandCachedRecipe
    extends ShapedRecipeHandler.CachedShapedRecipe
    implements IArcaneOverlayProvider {
        protected AspectList aspects;
        protected Object[] overlay;
        private final boolean shouldShowRecipe;

        public ArcaneWandCachedRecipe(WandRod rod, WandCap cap, ItemStack result, boolean isScepter, boolean shouldShowRecipe) {
            super((ShapedRecipeHandler)ArcaneCraftingShapedHandler.this, 3, 3, isScepter ? NEIHelper.buildScepterInput((WandRod)rod, (WandCap)cap) : NEIHelper.buildWandInput((WandRod)rod, (WandCap)cap), result);
            this.overlay = isScepter ? NEIHelper.buildScepterInput((WandRod)rod, (WandCap)cap) : NEIHelper.buildWandInput((WandRod)rod, (WandCap)cap);
            this.result = new PositionedStack((Object)result, 74, 2);
            this.aspects = NEIHelper.getPrimalAspectListFromAmounts((int[])NEIHelper.getWandAspectsWandCost((ItemStack)result));
            this.shouldShowRecipe = shouldShowRecipe;
            this.addAspectsToIngredients(this.aspects);
        }

        public List<PositionedStack> getIngredients() {
            if (!this.shouldShowRecipe) {
                return Collections.emptyList();
            }
            return super.getIngredients();
        }

        public void setIngredients(int width, int height, Object[] items) {
            if (items != null && items.length > 0) {
                int[][] positions = new int[][]{{48, 32}, {75, 33}, {103, 33}, {49, 60}, {76, 60}, {103, 60}, {49, 87}, {76, 87}, {103, 87}};
                int[][] positions2 = new int[][]{{48, 32}, {75, 33}, {49, 60}, {76, 60}};
                int shiftX = 0;
                int shiftY = 0;
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        Object object = items[y * width + x];
                        if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && !(object instanceof List) || object instanceof List && ((List)object).isEmpty()) continue;
                        if (width == 2 && height == 2) {
                            positions = positions2;
                        }
                        PositionedStack stack = new PositionedStack(object, positions[y * width + x][0] + shiftX, positions[y * width + x][1] + shiftY, object instanceof ItemStack);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                }
            }
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return;
            }
            super.setIngredientPermutation(ingredients, ingredient);
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                Aspect aspect = ItemAspect.getAspects((ItemStack)ingredient).getAspects()[0];
                return this.aspects.aspects.containsKey(aspect);
            }
            return super.contains(ingredients, ingredient);
        }

        @Override
        public ArrayList<PositionedStack> getPositionedStacksForOverlay() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            if (this.overlay != null && this.overlay.length > 0) {
                for (int x = 0; x < 3; ++x) {
                    for (int y = 0; y < 3; ++y) {
                        Object object = this.overlay[y * 3 + x];
                        if (!(object instanceof ItemStack) && !(object instanceof ItemStack[]) && !(object instanceof String) && (!(object instanceof List) || ((List)object).isEmpty())) continue;
                        stacks.add(new PositionedStack(object, 40 + x * 24, 40 + y * 24));
                    }
                }
            }
            return stacks;
        }

        protected void addAspectsToIngredients(AspectList aspects) {
            int baseX = 36;
            int baseY = 115;
            int count = 0;
            int columns = aspects.size();
            int xOffset = (100 - columns * 20) / 2;
            for (int column = 0; column < columns; ++column) {
                Aspect aspect = aspects.getAspectsSortedAmount()[count++];
                int posX = baseX + column * 18 + xOffset;
                ItemStack stack = new ItemStack(ModItems.itemAspect, aspects.getAmount(aspect), 1);
                ItemAspect.setAspect((ItemStack)stack, (Aspect)aspect);
                this.ingredients.add(new PositionedStack((Object)stack, posX, baseY, false));
            }
        }
    }
}

