/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.overlay;

import com.cleanroommc.modularui.api.widget.IGuiElement;
import com.cleanroommc.modularui.screen.ClientScreenHandler;
import com.cleanroommc.modularui.screen.ModularScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.renderer.RenderHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@ApiStatus.Experimental
public class OverlayStack {
    private static final List<ModularScreen> overlay = new ArrayList<ModularScreen>();

    public static void foreach(Consumer<ModularScreen> function, boolean topToBottom) {
        if (topToBottom) {
            for (int i = overlay.size() - 1; i >= 0; --i) {
                function.accept(overlay.get(i));
            }
        } else {
            for (ModularScreen screen : overlay) {
                function.accept(screen);
            }
        }
    }

    public static boolean interact(Predicate<ModularScreen> function, boolean topToBottom) {
        if (topToBottom) {
            for (int i = overlay.size() - 1; i >= 0; --i) {
                overlay.get(i).getContext().updateEventState();
                if (!function.test(overlay.get(i))) continue;
                return true;
            }
        } else {
            for (ModularScreen screen : overlay) {
                screen.getContext().updateEventState();
                if (!function.test(screen)) continue;
                return true;
            }
        }
        return false;
    }

    public static void draw(int mouseX, int mouseY, float partialTicks) {
        ModularScreen hovered = null;
        ModularScreen fallback = null;
        for (ModularScreen screen : overlay) {
            screen.getContext().updateState(mouseX, mouseY, partialTicks);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            screen.drawScreen(mouseX, mouseY, partialTicks);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            screen.drawForeground(partialTicks);
            if (screen.getContext().getHovered() != null) {
                hovered = screen;
            }
            fallback = screen;
        }
        ClientScreenHandler.drawDebugScreen(hovered, fallback);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
        RenderHelper.func_74519_b();
    }

    public static void open(ModularScreen screen) {
        int i = overlay.indexOf(screen);
        if (i >= 0 && i < overlay.size() - 1) {
            overlay.remove(i);
        }
        overlay.add(screen);
        screen.onOpen();
    }

    public static void close(ModularScreen screen) {
        if (overlay.remove(screen)) {
            screen.onCloseParent();
        }
    }

    static void closeAll() {
        for (int i = overlay.size() - 1; i >= 0; --i) {
            ModularScreen screen = overlay.remove(i);
            screen.onCloseParent();
        }
    }

    public static void onTick() {
        OverlayStack.foreach(ModularScreen::onUpdate, true);
    }

    @Nullable
    public static IGuiElement getHoveredElement() {
        for (int i = overlay.size() - 1; i >= 0; --i) {
            ModularScreen screen = overlay.get(i);
            IGuiElement hovered = screen.getContext().getHovered();
            if (hovered == null) continue;
            return hovered;
        }
        return null;
    }

    public static boolean isHoveringOverlay() {
        return OverlayStack.getHoveredElement() != null;
    }
}

