/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block.machine.mothershipEngine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.machine.AbstractBlockMothershipRestricted;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineAbstract;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineBooster;
import de.katzenpapst.amunra.vec.Vector3int;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class MothershipEngineBoosterBase
extends AbstractBlockMothershipRestricted {
    protected String activeTextureName;
    protected IIcon activeBlockIcon;
    protected ResourceLocation boosterTexture = new ResourceLocation("amunra", "textures/blocks/jet-base.png");

    public MothershipEngineBoosterBase(String name, String texture, String activeTexture) {
        super(name, texture);
        this.activeTextureName = activeTexture;
    }

    public MothershipEngineBoosterBase(String name, String texture, String activeTexture, String tool, int harvestLevel) {
        super(name, texture, tool, harvestLevel);
        this.activeTextureName = activeTexture;
    }

    @Override
    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity leTile = world.func_147438_o(x, y, z);
        if (leTile == null || !(leTile instanceof TileEntityMothershipEngineBooster)) {
            return false;
        }
        TileEntityMothershipEngineBooster tile = (TileEntityMothershipEngineBooster)leTile;
        if (tile.hasMaster()) {
            return super.onMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    protected void openGui(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity leTile = world.func_147438_o(x, y, z);
        if (leTile != null) {
            TileEntityMothershipEngineBooster tile = (TileEntityMothershipEngineBooster)leTile;
            Vector3int pos = tile.getMasterPosition();
            entityPlayer.openGui((Object)AmunRa.instance, 3, world, pos.x, pos.y, pos.z);
        }
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public MothershipEngineBoosterBase(String name, String texture, String activeTexture, String tool, int harvestLevel, float hardness, float resistance) {
        super(name, texture, tool, harvestLevel, hardness, resistance);
        this.activeTextureName = activeTexture;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityMothershipEngineBooster();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.activeBlockIcon = reg.func_94245_a(this.activeTextureName);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side <= 1) {
            return this.field_149761_L;
        }
        return this.activeBlockIcon;
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        TileEntity leTile = worldIn.func_147438_o(x, y, z);
        if (leTile == null) {
            return;
        }
        if (leTile instanceof TileEntityMothershipEngineAbstract) {
            TileEntityMothershipEngineAbstract tileEngine = (TileEntityMothershipEngineAbstract)leTile;
            tileEngine.scheduleUpdate();
        } else if (leTile instanceof TileEntityMothershipEngineBooster) {
            TileEntityMothershipEngineBooster tileBooster = (TileEntityMothershipEngineBooster)leTile;
            tileBooster.updateMaster(false);
            Vector3int pos = tileBooster.getPossibleNextBooster();
            if (pos != null) {
                worldIn.func_147460_e(pos.x, pos.y, pos.z, tileBooster.field_145854_h);
            }
        }
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.mothershipEngineRocket.description");
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149637_q() {
        return true;
    }

    public boolean func_149721_r() {
        return true;
    }

    public int func_149645_b() {
        return AmunRa.msBoosterRendererId;
    }

    public ResourceLocation getBoosterTexture() {
        return this.boosterTexture;
    }

    @Override
    public boolean canBeMoved(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityMothershipEngineBooster) {
            TileEntityMothershipEngineBooster tileBooster = (TileEntityMothershipEngineBooster)tileEntity;
            TileEntityMothershipEngineAbstract master = tileBooster.getMasterTile();
            return master == null || !master.isInUse();
        }
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (this.canBeMoved(world, x, y, z)) {
            return super.removedByPlayer(world, player, x, y, z);
        }
        return false;
    }
}

