/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.config;

import com.enderio.core.common.config.AbstractConfigHandler;
import com.enderio.core.common.config.ConfigProcessor;
import com.enderio.core.common.config.annot.Comment;
import com.enderio.core.common.config.annot.Config;
import com.enderio.core.common.config.annot.Range;
import net.minecraftforge.common.config.Property;

public class WPConfigHandler
extends AbstractConfigHandler {
    public static final WPConfigHandler INSTANCE = new WPConfigHandler();
    public static final String SECTION_BM = "blood_magic";
    public static final String SECTION_RC = "railcraft";
    public static final String SECTION_PLUGINS = "plugins";
    @Config(value="blood_magic")
    @Range(min=0.0, max=2.0)
    @Comment(value={"Determines the behavior of the shown info.\n", "0 - No sigil needed at all.", "1 - Need sigil in your inventory", "2 - Need sigil in your hand."})
    public static int sigilRequirement = 1;
    @Config(value="blood_magic")
    @Comment(value={"Determines how the Sigil of Sight affects the altar info.\n", "true - Sigil of Sight shows altar progress while Divination Sigil will not.", "false - Sigil of Sight provides no extra info and Divination sigil shows all information."})
    public static boolean seerBenefit = true;
    @Config(value="railcraft")
    @Comment(value={"Does the player need the Electric Meter in hand to see info about RC charge"})
    public static boolean meterInHand = true;

    private WPConfigHandler() {
        super("wailaplugins");
    }

    protected void init() {
        this.addSection(SECTION_BM);
        this.addSection(SECTION_RC);
        this.addSection(SECTION_PLUGINS);
        new ConfigProcessor(((Object)((Object)this)).getClass(), (AbstractConfigHandler)this).process(true);
    }

    protected void reloadNonIngameConfigs() {
    }

    protected void reloadIngameConfigs() {
    }

    public boolean isPluginEnabled(String modid) {
        this.activateSection(SECTION_PLUGINS);
        boolean ret = this.getPropFor(modid).getBoolean();
        this.saveConfigFile();
        return ret;
    }

    public void disablePlugin(String modid) {
        this.getProperty(modid, false).set(false);
        this.saveConfigFile();
    }

    private Property getPropFor(String modid) {
        this.activateSection(SECTION_PLUGINS);
        Property prop = this.getProperty(modid, true);
        prop.comment = "Should the plugin for the mod with modid '" + modid + "' be loaded";
        return prop;
    }
}

