/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.toolbox.tools;

import betterquesting.api.client.toolbox.IToolboxTool;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api2.client.gui.controls.PanelButtonQuest;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.panels.lists.CanvasQuestLine;
import betterquesting.client.gui2.editors.designer.PanelToolController;
import betterquesting.client.toolbox.ToolboxTabMain;
import betterquesting.network.handlers.NetChapterEdit;
import betterquesting.network.handlers.NetQuestEdit;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.QuestLineDatabase;
import betterquesting.questing.QuestLineEntry;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ToolboxToolCopy
implements IToolboxTool {
    private CanvasQuestLine gui = null;
    private final List<GrabEntry> grabList = new ArrayList<GrabEntry>();

    @Override
    public void initTool(CanvasQuestLine gui) {
        this.gui = gui;
        this.grabList.clear();
    }

    @Override
    public void disableTool() {
        this.grabList.clear();
    }

    @Override
    public void refresh(CanvasQuestLine gui) {
        if (this.grabList.size() <= 0) {
            return;
        }
        ArrayList<GrabEntry> tmp = new ArrayList<GrabEntry>();
        block0: for (GrabEntry grab : this.grabList) {
            for (PanelButtonQuest btn : PanelToolController.selected) {
                if (!((UUID)((Map.Entry)btn.getStoredValue()).getKey()).equals(((Map.Entry)grab.btn.getStoredValue()).getKey())) continue;
                tmp.add(new GrabEntry(btn, grab.offX, grab.offY));
                continue block0;
            }
        }
        this.grabList.clear();
        this.grabList.addAll(tmp);
    }

    @Override
    public void drawCanvas(int mx, int my, float partialTick) {
        if (this.grabList.size() <= 0) {
            return;
        }
        int snap = Math.max(1, ToolboxTabMain.INSTANCE.getSnapValue());
        int dx = mx;
        int dy = my;
        dx = (dx % snap + snap) % snap;
        dy = (dy % snap + snap) % snap;
        dx = mx - dx;
        dy = my - dy;
        for (GrabEntry grab : this.grabList) {
            ((GrabEntry)grab).btn.rect.x = dx + grab.offX;
            ((GrabEntry)grab).btn.rect.y = dy + grab.offY;
            grab.btn.drawPanel(dx, dy, partialTick);
        }
    }

    @Override
    public void drawOverlay(int mx, int my, float partialTick) {
        if (this.grabList.size() > 0) {
            ToolboxTabMain.INSTANCE.drawGrid(this.gui);
        }
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        return this.grabList.size() <= 0 ? null : Collections.emptyList();
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        if (click == 1 && this.grabList.size() > 0) {
            this.grabList.clear();
            return true;
        }
        if (click != 0 || !this.gui.getTransform().contains(mx, my)) {
            return false;
        }
        if (this.grabList.size() <= 0) {
            PanelButtonQuest btnClicked = this.gui.getButtonAt(mx, my);
            if (btnClicked != null) {
                if (PanelToolController.selected.size() > 0) {
                    if (!PanelToolController.selected.contains(btnClicked)) {
                        return false;
                    }
                    for (PanelButtonQuest btn : PanelToolController.selected) {
                        GuiRectangle rect = new GuiRectangle(btn.rect);
                        this.grabList.add(new GrabEntry(new PanelButtonQuest(rect, -1, "", (Map.Entry)btn.getStoredValue()), rect.x - btnClicked.rect.x, rect.y - btnClicked.rect.y));
                    }
                } else {
                    this.grabList.add(new GrabEntry(new PanelButtonQuest(new GuiRectangle(btnClicked.rect), -1, "", (Map.Entry)btnClicked.getStoredValue()), 0, 0));
                }
                return true;
            }
            return false;
        }
        IQuestLine qLine = this.gui.getQuestLine();
        UUID lID = QuestLineDatabase.INSTANCE.lookupKey(qLine);
        ArrayList<UUID> nextIDs = new ArrayList<UUID>(ToolboxToolCopy.getNextIDs(this.grabList.size()));
        HashBiMap remappedIDs = HashBiMap.create((int)this.grabList.size());
        for (int i = 0; i < this.grabList.size(); ++i) {
            remappedIDs.put(((Map.Entry)this.grabList.get(i).btn.getStoredValue()).getKey(), nextIDs.get(i));
        }
        NBTTagList qdList = new NBTTagList();
        for (int i = 0; i < this.grabList.size(); ++i) {
            Object entry2;
            GrabEntry grab = this.grabList.get(i);
            IQuest quest = (IQuest)((Map.Entry)grab.btn.getStoredValue()).getValue();
            UUID qID = (UUID)nextIDs.get(i);
            if (qLine.get(qID) == null) {
                qLine.put(qID, new QuestLineEntry(((GrabEntry)grab).btn.rect.x, ((GrabEntry)grab).btn.rect.y, ((GrabEntry)grab).btn.rect.w, ((GrabEntry)grab).btn.rect.h));
            }
            NBTTagCompound questTags = quest.writeToNBT(new NBTTagCompound());
            HashSet<UUID> reqs = new HashSet<UUID>(quest.getRequirements());
            for (Object entry2 : remappedIDs.entrySet()) {
                if (!reqs.contains(entry2.getKey())) continue;
                reqs.remove(entry2.getKey());
                reqs.add((UUID)entry2.getValue());
            }
            NBTTagList tagList = new NBTTagList();
            entry2 = reqs.iterator();
            while (entry2.hasNext()) {
                UUID questID = (UUID)entry2.next();
                NBTTagCompound tag = NBTConverter.UuidValueType.QUEST.writeId(questID);
                UUID oldID = (UUID)remappedIDs.inverse().getOrDefault((Object)questID, (Object)questID);
                IQuest.RequirementType requirementType = quest.getRequirementType(oldID);
                if (requirementType != IQuest.RequirementType.NORMAL) {
                    tag.func_74774_a("type", requirementType.id());
                }
                tagList.func_74742_a((NBTBase)tag);
            }
            questTags.func_74782_a("preRequisites", (NBTBase)tagList);
            NBTTagCompound tagEntry = new NBTTagCompound();
            NBTConverter.UuidValueType.QUEST.writeId(qID, tagEntry);
            tagEntry.func_74782_a("config", (NBTBase)questTags);
            qdList.func_74742_a((NBTBase)tagEntry);
        }
        this.grabList.clear();
        NBTTagCompound quPayload = new NBTTagCompound();
        quPayload.func_74782_a("data", (NBTBase)qdList);
        quPayload.func_74768_a("action", 3);
        NetQuestEdit.sendEdit(quPayload);
        NBTTagCompound chPayload = new NBTTagCompound();
        NBTTagList cdList = new NBTTagList();
        NBTTagCompound tagEntry = new NBTTagCompound();
        NBTConverter.UuidValueType.QUEST_LINE.writeId(lID, tagEntry);
        tagEntry.func_74782_a("config", qLine.writeToNBT((NBTBase)new NBTTagCompound(), null));
        cdList.func_74742_a((NBTBase)tagEntry);
        chPayload.func_74782_a("data", (NBTBase)cdList);
        chPayload.func_74768_a("action", 0);
        NetChapterEdit.sendEdit(chPayload);
        return true;
    }

    private static Set<UUID> getNextIDs(int num) {
        HashSet<UUID> nextIds = new HashSet<UUID>();
        while (nextIds.size() < num) {
            nextIds.add(QuestDatabase.INSTANCE.generateKey());
        }
        return nextIds;
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        return false;
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        return false;
    }

    @Override
    public boolean onKeyPressed(char c, int keyCode) {
        return this.grabList.size() > 0;
    }

    @Override
    public boolean clampScrolling() {
        return this.grabList.size() <= 0;
    }

    @Override
    public void onSelection(List<PanelButtonQuest> buttons) {
    }

    @Override
    public boolean useSelection() {
        return this.grabList.size() <= 0;
    }

    private class GrabEntry {
        private final PanelButtonQuest btn;
        private final int offX;
        private final int offY;

        private GrabEntry(PanelButtonQuest btn, int offX, int offY) {
            this.btn = btn;
            this.offX = offX;
            this.offY = offY;
        }
    }
}

