/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.HashSet;
import mcp.mobius.betterbarrels.RecipeHandler;
import mcp.mobius.betterbarrels.ServerTickHandler;
import mcp.mobius.betterbarrels.bspace.BSpaceStorageHandler;
import mcp.mobius.betterbarrels.common.BaseProxy;
import mcp.mobius.betterbarrels.common.StructuralLevel;
import mcp.mobius.betterbarrels.common.blocks.BlockBarrel;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.items.ItemBarrelHammer;
import mcp.mobius.betterbarrels.common.items.ItemTuningFork;
import mcp.mobius.betterbarrels.common.items.dolly.ItemBarrelMover;
import mcp.mobius.betterbarrels.common.items.dolly.ItemDiamondMover;
import mcp.mobius.betterbarrels.common.items.dolly.ItemFoldedBarrelMover;
import mcp.mobius.betterbarrels.common.items.upgrades.ItemUpgradeCore;
import mcp.mobius.betterbarrels.common.items.upgrades.ItemUpgradeSide;
import mcp.mobius.betterbarrels.common.items.upgrades.ItemUpgradeStructural;
import mcp.mobius.betterbarrels.network.BarrelPacketHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="JABBA", name="JABBA", version="1.4.6", dependencies="after:Waila;after:NotEnoughItems")
public class BetterBarrels {
    private static boolean DEBUG = Boolean.parseBoolean(System.getProperty("mcp.mobius.debugJabba", "false"));
    public static final String modid = "JABBA";
    public static Logger log = LogManager.getLogger((String)"JABBA");
    @Mod.Instance(value="JABBA")
    public static BetterBarrels instance;
    @SidedProxy(clientSide="mcp.mobius.betterbarrels.client.ClientProxy", serverSide="mcp.mobius.betterbarrels.common.BaseProxy")
    public static BaseProxy proxy;
    private static Configuration config;
    public static boolean disableDollyStacking;
    public static boolean fullBarrelTexture;
    public static boolean highRezTexture;
    public static boolean showUpgradeSymbols;
    public static boolean diamondDollyActive;
    public static int stacksSize;
    public static int maxCraftableTier;
    public static String upgradeItemStr;
    public static Block blockBarrel;
    public static Block blockMiniBarrel;
    public static Block blockBarrelShelf;
    public static Item itemUpgradeStructural;
    public static Item itemUpgradeCore;
    public static Item itemUpgradeSide;
    public static Item itemMover;
    public static Item itemMoverDiamond;
    public static Item itemTuningFork;
    public static Item itemLockingPlanks;
    public static Item itemHammer;
    public static Item itemFoldedMover;
    public static long limiterDelay;
    public static int blockBarrelRendererID;
    public static boolean allowVerticalPlacement;
    public static float verticalPlacementRange;
    public static boolean exposeFullStorageSize;
    public static boolean reverseBehaviourClickLeft;
    public static boolean allowOreDictUnification;
    public static boolean renderStackAndText;
    public static float renderDistance;
    public static String[] BlacklistedTileEntiyClassNames;
    public static HashSet<Class<? extends TileEntity>> BlacklistedTileEntityClasses;

    public static void debug(String msg) {
        if (DEBUG) {
            log.log(Level.WARN, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            diamondDollyActive = config.get("general", "diamondDollyActive", true).getBoolean(true);
            limiterDelay = config.get("general", "packetLimiterDelay", 500, "Controls the minimum delay (in ms) between two server/client sync. Lower values mean closer to realtime, and more network usage.").getInt();
            Object[] materialsList = config.get("general", "materialList", StructuralLevel.defaultUpgradeMaterialsList, "A structural tier will be created for each material in this list, even if not craftable").getStringList();
            if (materialsList.length > 18) {
                String[] trimedList = new String[18];
                for (int i = 0; i < 18; ++i) {
                    trimedList[i] = materialsList[i];
                }
                materialsList = trimedList;
                config.get("general", "materialList", trimedList).set(trimedList);
            }
            BetterBarrels.debug("00 - Loaded materials list: " + Arrays.toString(materialsList));
            StructuralLevel.createLevelArray((String[])materialsList);
            maxCraftableTier = Math.min(18, Math.min(materialsList.length, config.get("general", "maxCraftableTier", materialsList.length, "Maximum tier to generate crafting recipes for").getInt()));
            BetterBarrels.debug("01 - Max craftable tier: " + maxCraftableTier);
            proxy.initialiseClientData(config.get("general", "colorOverrides", new int[]{0, 0}, "This list contains paired numbers: first is the tier level this color applies to, second is the color. The color value is the RGB color as a single int").getIntList());
            stacksSize = config.get("general", "stacksSize", stacksSize, "How many stacks the base barrel and each upgrade will provide").getInt();
            upgradeItemStr = config.get("general", "tierUpgradeItem", upgradeItemStr, "The name of the item to use for the strutural tier upgrade recipes. Default is \"minecraft:fence\" for Vanilla Fence. The format is Ore.name for an ore dictionary lookup, or itemDomain:itemname[:meta] for a direct item, not this is case-sensitive.").getString();
            allowVerticalPlacement = config.getBoolean("allowVerticalPlacement", "general", true, "If true, barrels can be initially placed and dollyed so that their front side can be on the top or bottom. The front side is the side with the initial sticker applied.");
            verticalPlacementRange = config.getFloat("verticalPlacementRange", "general", 0.79f, 0.0f, 1.0f, "This is used when testing a players aim for block placement.  If the aim value is greater than or equal to this setting, it is determined you are attempting to place a block facing down.  The reverse is true for placing blocks facing up. 0 = dead ahead, 1 = directly above.");
            exposeFullStorageSize = config.getBoolean("exposeFullStorageSize", "experimental", false, "If true, barrels will expose their full contents through the standard MC inventory interfaces. This will allow mods that do not support the DSU to see the full contents of the barrel. *** WARNING *** This will allow mods that do not properly handle inventories to empty out a barrel in one go. Use at your own risk. If you do find such a game breaking mod, please report to that mods' author and ask them to handle inventories better. Otherwise, please enjoy this experimental feature ^_^");
            reverseBehaviourClickLeft = config.getBoolean("reverseBehaviourClickLeft", "general", false, "If true, punching a barrel will remove one item and shift punching a stack.");
            allowOreDictUnification = config.getBoolean("allowOreDictUnification", "general", true, "If true, Jabba will try unificate 'ingot' 'ore' 'dust' and 'nugget' using oredict");
            renderDistance = config.getFloat("renderDistance", "general", 10000.0f, 0.0f, 10000.0f, "Render Distance (square) for stack and text on barrel.");
            renderStackAndText = config.getBoolean("renderStackAndText", "general", true, "");
            BlacklistedTileEntiyClassNames = config.getStringList("BlacklistedTileEntiyClassNames", "general", BlacklistedTileEntiyClassNames, "The Canonical Class-Names of TileEntities that should be ignored when using a Dolly.");
            disableDollyStacking = config.getBoolean("disableDollyStacking", "general", false, "Disables the ability to collapse and stack the dollies");
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"BlockBarrel has a problem loading it's configuration", (Object[])new Object[0]);
            FMLLog.severe((String)e.getMessage(), (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
        for (String className : BlacklistedTileEntiyClassNames) {
            try {
                Class<?> aClass = Class.forName(className, false, this.getClass().getClassLoader());
                if (aClass != null && TileEntity.class.isAssignableFrom(aClass)) {
                    Class<?> aTileClass = aClass;
                    BlacklistedTileEntityClasses.add(aTileClass);
                    log.log(Level.INFO, "Blacklisted " + className + " from Dolly.");
                    continue;
                }
                if (aClass == null) {
                    log.log(Level.INFO, "Class " + className + " is Null.");
                }
                if (TileEntity.class.isAssignableFrom(aClass)) continue;
                log.log(Level.INFO, "Class " + className + " does not extend TileEntity.");
            }
            catch (ClassNotFoundException e) {
                log.log(Level.INFO, "Did not find " + className + ", unable to blacklist from Dolly.");
            }
        }
        proxy.registerEventHandler();
        blockBarrel = new BlockBarrel();
        itemUpgradeStructural = new ItemUpgradeStructural();
        itemUpgradeCore = new ItemUpgradeCore();
        itemUpgradeSide = new ItemUpgradeSide();
        itemMover = new ItemBarrelMover();
        itemMoverDiamond = new ItemDiamondMover();
        itemHammer = new ItemBarrelHammer();
        itemTuningFork = new ItemTuningFork();
        itemFoldedMover = new ItemFoldedBarrelMover();
        GameRegistry.registerBlock((Block)blockBarrel, (String)"barrel");
        GameRegistry.registerItem((Item)itemUpgradeStructural, (String)"upgradeStructural");
        GameRegistry.registerItem((Item)itemUpgradeCore, (String)"upgradeCore");
        GameRegistry.registerItem((Item)itemUpgradeSide, (String)"upgradeSide");
        GameRegistry.registerItem((Item)itemMover, (String)"mover");
        GameRegistry.registerItem((Item)itemFoldedMover, (String)"moverFolded");
        GameRegistry.registerItem((Item)itemMoverDiamond, (String)"moverDiamond");
        GameRegistry.registerItem((Item)itemHammer, (String)"hammer");
        GameRegistry.registerItem((Item)itemTuningFork, (String)"tuningFork");
        BarrelPacketHandler.INSTANCE.ordinal();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        if (!Loader.isModLoaded((String)"dreamcraft")) {
            RecipeHandler.instance().registerRecipes();
        }
        GameRegistry.registerTileEntity(TileEntityBarrel.class, (String)"TileEntityBarrel");
        FMLCommonHandler.instance().bus().register((Object)ServerTickHandler.INSTANCE);
        proxy.registerRenderers();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"mcp.mobius.betterbarrels.BBWailaProvider.callbackRegister");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeHandler.instance().registerOres();
        if (!Loader.isModLoaded((String)"dreamcraft")) {
            RecipeHandler.instance().registerLateRecipes();
        }
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        BSpaceStorageHandler.instance().writeToFile();
    }

    static {
        config = null;
        fullBarrelTexture = true;
        highRezTexture = true;
        showUpgradeSymbols = true;
        diamondDollyActive = true;
        stacksSize = 64;
        maxCraftableTier = StructuralLevel.defaultUpgradeMaterialsList.length;
        upgradeItemStr = "minecraft:fence";
        blockBarrel = null;
        blockMiniBarrel = null;
        blockBarrelShelf = null;
        itemUpgradeStructural = null;
        itemUpgradeCore = null;
        itemUpgradeSide = null;
        itemMover = null;
        itemMoverDiamond = null;
        itemTuningFork = null;
        itemLockingPlanks = null;
        itemHammer = null;
        itemFoldedMover = null;
        limiterDelay = 500L;
        blockBarrelRendererID = -1;
        allowVerticalPlacement = true;
        verticalPlacementRange = 1.0f;
        exposeFullStorageSize = false;
        reverseBehaviourClickLeft = false;
        allowOreDictUnification = true;
        renderStackAndText = false;
        renderDistance = 16.0f;
        BlacklistedTileEntiyClassNames = new String[]{"ic2.core.block.machine.tileentity.TileEntityNuke"};
        BlacklistedTileEntityClasses = new HashSet();
    }
}

