/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.interfaces;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.tileentity.TileEntity;
import vswe.stevesfactory.SFMLogging;
import vswe.stevesfactory.blocks.ConnectionBlock;
import vswe.stevesfactory.blocks.TileEntityManager;
import vswe.stevesfactory.blocks.WorldCoordinate;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.interfaces.ContainerBase;
import vswe.stevesfactory.network.PacketHandler;

public class ContainerManager
extends ContainerBase {
    private TileEntityManager manager;
    private List<FlowComponent> oldComponents;
    private List<WorldCoordinate> oldInventories;
    private int oldIdIndexToRemove;

    public ContainerManager(TileEntityManager manager, InventoryPlayer player) {
        super(manager, player);
        this.manager = manager;
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return entityplayer.func_70092_e((double)this.manager.field_145851_c, (double)this.manager.field_145848_d, (double)this.manager.field_145849_e) <= 64.0;
    }

    public void func_75142_b() {
        try {
            this.detectAndSendChangesImpl();
        }
        catch (Exception e) {
            SFMLogging.reportIncident(e, "ContainerManager#detectAndSendChanges", Iterables.filter(this.getCrafters(), EntityPlayerMP.class));
            for (ICrafting crafter : this.getCrafters()) {
                if (!(crafter instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)crafter).func_71053_j();
            }
        }
    }

    private void detectAndSendChangesImpl() {
        super.func_75142_b();
        if (this.oldComponents != null) {
            boolean hasInventoriesChanged;
            if (this.oldIdIndexToRemove < this.manager.getRemovedIds().size()) {
                int idToRemove = this.manager.getRemovedIds().get(this.oldIdIndexToRemove);
                ++this.oldIdIndexToRemove;
                this.manager.removeFlowComponent(idToRemove, this.oldComponents);
                PacketHandler.sendRemovalPacket(this, idToRemove);
            }
            for (int i = 0; i < this.manager.getFlowItems().size(); ++i) {
                if (i >= this.oldComponents.size()) {
                    PacketHandler.sendNewFlowComponent(this, this.manager.getFlowItems().get(i));
                    this.oldComponents.add(this.manager.getFlowItems().get(i).copy());
                    continue;
                }
                this.oldComponents.get(i).refreshData(this, this.manager.getFlowItems().get(i));
            }
            boolean bl = hasInventoriesChanged = this.oldInventories.size() != this.manager.getConnectedInventories().size();
            if (!hasInventoriesChanged) {
                for (int i = 0; i < this.oldInventories.size(); ++i) {
                    TileEntity tileEntity = this.manager.getConnectedInventories().get(i).getTileEntity();
                    if (!this.oldInventories.get(i).equals(new WorldCoordinate(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e))) continue;
                    hasInventoriesChanged = true;
                    break;
                }
            }
            if (hasInventoriesChanged) {
                this.oldInventories.clear();
                for (ConnectionBlock connection : this.manager.getConnectedInventories()) {
                    this.oldInventories.add(new WorldCoordinate(connection.getTileEntity().field_145851_c, connection.getTileEntity().field_145848_d, connection.getTileEntity().field_145849_e));
                }
                PacketHandler.sendUpdateInventoryPacket(this);
            }
        }
    }

    public void func_75132_a(ICrafting player) {
        super.func_75132_a(player);
        PacketHandler.sendAllData(this, player, this.manager);
        this.oldComponents = new ArrayList<FlowComponent>();
        for (FlowComponent component : this.manager.getFlowItems()) {
            this.oldComponents.add(component.copy());
        }
        this.manager.updateInventories();
        this.oldInventories = new ArrayList<WorldCoordinate>();
        for (ConnectionBlock connection : this.manager.getConnectedInventories()) {
            this.oldInventories.add(new WorldCoordinate(connection.getTileEntity().field_145851_c, connection.getTileEntity().field_145848_d, connection.getTileEntity().field_145849_e));
        }
        this.oldIdIndexToRemove = this.manager.getRemovedIds().size();
    }
}

