/*
 * Decompiled with CFR 0.152.
 */
package remoteio.core.transform;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import remoteio.core.MappingHelper;
import remoteio.core.mapping.MappingConstants;
import remoteio.core.transform.ITransformer;

public class TransformWorld
implements ITransformer {
    private static final String METHOD_HANDLER = "remoteio/common/tracker/RedstoneTracker";
    private static final String METHOD_REDSTONE = "getIndirectPowerLevelTo";
    private static final String METHOD_REDSTONE_DESC = "(L%s;IIII)I";

    @Override
    public String[] getClasses() {
        return new String[]{"net.minecraft.world.World"};
    }

    @Override
    public byte[] transform(String name, byte[] basicClass) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode targetNode = null;
        String world = MappingConstants.Type.get(MappingConstants.Type.WORLD);
        for (MethodNode methodNode : classNode.methods) {
            if (!MappingConstants.Method.equals(methodNode, MappingConstants.Method.GET_INDIRECT_POWER_LEVEL_TO, MappingConstants.Method.Desc.GET_INDIRECT_POWER_LEVEL_TO)) continue;
            targetNode = methodNode;
            MappingHelper.logger.info("Found method 'getIndirectPowerLevelTo'");
            break;
        }
        if (targetNode != null) {
            targetNode.instructions.clear();
            targetNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            targetNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            targetNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            targetNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            targetNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            targetNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, METHOD_HANDLER, METHOD_REDSTONE, String.format(METHOD_REDSTONE_DESC, world), false));
            targetNode.instructions.add((AbstractInsnNode)new InsnNode(172));
            MappingHelper.logger.warn("Successfully transformed World.class!");
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        MappingHelper.logger.warn("Failed to transform World.class");
        return basicClass;
    }
}

