/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.util;

import chylex.hee.system.commands.HeeDebugCommand;
import chylex.hee.system.logging.Log;
import chylex.hee.system.util.MathUtil;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.Random;

public interface IRandomAmount {
    public static final IRandomAmount exact = new IRandomAmount(){

        @Override
        public int generate(Random rand, int minAmount, int maxAmount) {
            return minAmount;
        }
    };
    public static final IRandomAmount linear = new IRandomAmount(){

        @Override
        public int generate(Random rand, int minAmount, int maxAmount) {
            return minAmount + rand.nextInt(maxAmount - minAmount + 1);
        }
    };
    public static final IRandomAmount preferSmaller = new IRandomAmount(){

        @Override
        public int generate(Random rand, int minAmount, int maxAmount) {
            return minAmount + MathUtil.floor(rand.nextDouble() * rand.nextDouble() * (double)(1 + maxAmount - minAmount));
        }
    };
    public static final IRandomAmount aroundCenter = new IRandomAmount(){

        @Override
        public int generate(Random rand, int minAmount, int maxAmount) {
            return MathUtil.clamp((int)Math.round((double)minAmount + (double)(maxAmount - minAmount) * 0.5 + (rand.nextDouble() - 0.5) * rand.nextDouble() * (double)(1 + maxAmount - minAmount)), minAmount, maxAmount);
        }
    };
    public static final IRandomAmount gaussian = new IRandomAmount(){

        @Override
        public int generate(Random rand, int minAmount, int maxAmount) {
            return minAmount + (int)Math.round(MathUtil.clamp(rand.nextGaussian() * 0.5, 0.0, 1.0) * (double)(maxAmount - minAmount));
        }
    };
    public static final HeeDebugCommand.HeeTest $debugTest = new HeeDebugCommand.HeeTest(){

        @Override
        public void run(String ... args) {
            Random rand = new Random();
            int index = 0;
            IRandomAmount[] algos = new IRandomAmount[]{linear, preferSmaller, aroundCenter, gaussian};
            String[] algoNames = new String[]{"linear", "preferSmaller", "aroundCenter", "gaussian"};
            TIntIntHashMap map = new TIntIntHashMap();
            for (IRandomAmount algo : algos) {
                int a;
                map.clear();
                for (a = 0; a < 10000; ++a) {
                    int val = algo.generate(rand, 1, 10);
                    map.adjustOrPutValue(val, 1, 1);
                }
                Log.debug("== Algorithm - " + algoNames[index] + " ==", new Object[0]);
                for (a = -1; a < 11; ++a) {
                    Log.debug("$0 ... $1", a + 1, map.get(a + 1));
                }
                ++index;
            }
        }
    };

    public int generate(Random var1, int var2, int var3);
}

