/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import serverutils.client.EnumPlacement;
import serverutils.client.EnumSidebarLocation;
import serverutils.client.ServerUtilitiesClientConfig;
import serverutils.client.gui.SidebarButton;
import serverutils.client.gui.SidebarButtonGroup;
import serverutils.client.gui.SidebarButtonManager;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.icon.Color4I;

public class GuiSidebar
extends GuiButton {
    public static Rectangle lastDrawnArea = new Rectangle();
    public static int dragOffsetX = 0;
    public static int dragOffsetY = 0;
    private final GuiContainer gui;
    public final List<GuiButtonSidebar> buttons;
    private int dragStartX;
    private int dragStartY;
    private GuiButtonSidebar mouseOver;
    private boolean isDragging;
    private final EnumSidebarLocation location;
    private EnumPlacement placement;

    public GuiSidebar(GuiContainer g) {
        super(495829, 0, 0, 0, 0, "");
        this.gui = g;
        this.buttons = new ArrayList<GuiButtonSidebar>();
        this.location = ServerUtilitiesClientConfig.sidebar_buttons;
        this.placement = ServerUtilitiesClientConfig.sidebar_placement;
    }

    public void func_146112_a(Minecraft mc, int mx, int my) {
        this.mouseOver = null;
        if (ServerUtilitiesClientConfig.sidebar_buttons != this.location) {
            this.clearButtons();
        }
        this.setButtonLocations(mc, mx, my);
        if (this.buttons.isEmpty()) {
            this.addButtonsToSidebar();
        }
        int x = Integer.MAX_VALUE;
        int y = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (GuiButtonSidebar guiButtonSidebar : this.buttons) {
            if (guiButtonSidebar.x >= 0 && guiButtonSidebar.y >= 0) {
                x = Math.min(x, guiButtonSidebar.x);
                y = Math.min(y, guiButtonSidebar.y);
                maxX = Math.max(maxX, guiButtonSidebar.x + 16);
                maxY = Math.max(maxY, guiButtonSidebar.y + 16);
            }
            if (mx < guiButtonSidebar.x || my < guiButtonSidebar.y || mx >= guiButtonSidebar.x + 16 || my >= guiButtonSidebar.y + 16) continue;
            this.mouseOver = guiButtonSidebar;
        }
        this.field_146120_f = (maxX += 2) - (x -= 2);
        this.field_146121_g = (maxY += 2) - (y -= 2);
        this.field_73735_i = 0.0f;
        this.field_146128_h = x;
        this.field_146129_i = y;
        GlStateManager.pushMatrix();
        GlStateManager.translate(0.0f, 0.0f, 500.0f);
        FontRenderer font = mc.field_71466_p;
        GlStateManager.enableBlend();
        GlStateManager.enableDepth();
        GlStateManager.blendFunc(770, 771);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        for (GuiButtonSidebar b : this.buttons) {
            String text;
            b.button.getIcon().draw(b.x, b.y, 16, 16);
            if (b == this.mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(b.x, b.y, 16, 16);
            }
            if (b.button.getCustomTextHandler() == null || (text = b.button.getCustomTextHandler().get()).isEmpty()) continue;
            int nw = font.func_78256_a(text);
            int width = 16;
            Color4I.LIGHT_RED.draw(b.x + width - nw, b.y - 1, nw + 1, 9);
            font.func_78276_b(text, b.x + width - nw + 1, b.y, -1);
            GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.mouseOver != null) {
            int n = mx + 10;
            int my1 = Math.max(3, my - 9);
            ArrayList<String> list = new ArrayList<String>();
            list.add(StatCollector.func_74838_a((String)this.mouseOver.button.getLangKey()));
            if (this.mouseOver.button.isDisabled()) {
                list.add(EnumChatFormatting.RED + ClientUtils.getDisabledTip());
            }
            if (this.mouseOver.button.getTooltipHandler() != null) {
                this.mouseOver.button.getTooltipHandler().accept(list);
            }
            int tw = 0;
            for (String s : list) {
                tw = Math.max(tw, font.func_78256_a(s));
            }
            Color4I.DARK_GRAY.draw(n - 3, my1 - 2, tw + 6, 2 + list.size() * 10);
            for (int i = 0; i < list.size(); ++i) {
                font.func_78276_b((String)list.get(i), n, my1 + i * 10, -1);
            }
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.disableDepth();
        GlStateManager.popMatrix();
        this.field_73735_i = 0.0f;
        lastDrawnArea = new Rectangle(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
    }

    public boolean func_146116_c(Minecraft mc, int mx, int my) {
        if (super.func_146116_c(mc, mx, my) && this.mouseOver != null) {
            if (GuiScreen.func_146271_m() && !this.location.isLocked()) {
                this.isDragging = true;
                this.dragStartX = mx;
                this.dragStartY = my;
            } else {
                this.mouseOver.button.onClicked(GuiScreen.func_146272_n());
            }
            return true;
        }
        return false;
    }

    public void func_146119_b(Minecraft mc, int mx, int my) {
        if (this.isDragging) {
            int newDragOffsetX = mx - this.dragStartX;
            int newDragOffsetY = my - this.dragStartY;
            for (GuiButtonSidebar button : this.buttons) {
                int newX = button.x + newDragOffsetX;
                int newY = button.y + newDragOffsetY;
                if (newX >= 0 && newX + 16 <= mc.field_71462_r.field_146294_l && newY >= 0 && newY + 16 <= mc.field_71462_r.field_146295_m) continue;
                return;
            }
            dragOffsetX += newDragOffsetX;
            dragOffsetY += newDragOffsetY;
            this.dragStartX = mx;
            this.dragStartY = my;
        }
    }

    public void func_146118_a(int mx, int my) {
        if (this.isDragging) {
            this.isDragging = false;
            SidebarButtonManager.INSTANCE.saveConfig();
        }
    }

    private void addButtonsToSidebar() {
        int rx = 0;
        int ry = 0;
        int max = this.placement.getMaxInRow();
        for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
            boolean addedAny = false;
            for (SidebarButton button : group.getButtons()) {
                if (!button.isActuallyVisible()) continue;
                this.buttons.add(new GuiButtonSidebar(rx, ry, button));
                switch (this.placement) {
                    case HORIZONTAL: {
                        ++ry;
                        break;
                    }
                    case VERTICAL: {
                        ++rx;
                        break;
                    }
                    case GROUPED: {
                        ++rx;
                        addedAny = true;
                    }
                }
                if (this.placement == EnumPlacement.GROUPED) continue;
                if (ry >= max) {
                    ry = 0;
                    --rx;
                    continue;
                }
                if (rx < max) continue;
                rx = 0;
                ++ry;
            }
            if (!addedAny) continue;
            rx = 0;
            ++ry;
        }
    }

    private void setButtonLocations(Minecraft mc, int mx, int my) {
        int offsetX = 18;
        int offsetY = 8;
        if (this.gui instanceof GuiContainerCreative) {
            offsetY = 6;
        }
        if (this.location.above()) {
            this.placement = ClientUtils.isCreativePlusGui((GuiScreen)this.gui) ? this.placement : EnumPlacement.HORIZONTAL;
            offsetX = 22;
            offsetY = -18;
        }
        if (ClientUtils.isCreativePlusGui((GuiScreen)this.gui)) {
            offsetY = 22;
            offsetX = 41;
        }
        this.func_146119_b(mc, mx, my);
        int actualOffsetX = this.location.isLocked() ? offsetX : offsetX - dragOffsetX;
        int actualOffsetY = this.location.isLocked() ? offsetY : -offsetY - dragOffsetY;
        int maxOffsetX = mc.field_71462_r.field_146294_l - 16;
        int maxOffsetY = mc.field_71462_r.field_146295_m - 16;
        for (GuiButtonSidebar button : this.buttons) {
            if (this.location == EnumSidebarLocation.TOP_LEFT) {
                button.x = 1 + button.buttonX * 17;
                button.y = 1 + button.buttonY * 17;
                continue;
            }
            if (this.location.isLocked()) {
                button.x = this.gui.field_147003_i - offsetX - button.buttonY * 17;
                button.y = this.gui.field_147009_r + offsetY + button.buttonX * 17;
                continue;
            }
            button.x = MathHelper.func_76125_a((int)(this.gui.field_147003_i - button.buttonY * 17 - actualOffsetX), (int)0, (int)maxOffsetX);
            button.y = MathHelper.func_76125_a((int)(this.gui.field_147009_r + button.buttonX * 17 - actualOffsetY), (int)0, (int)maxOffsetY);
        }
    }

    public void clearButtons() {
        this.buttons.clear();
    }

    public static class GuiButtonSidebar {
        public final int buttonX;
        public final int buttonY;
        public final SidebarButton button;
        public int x;
        public int y;

        public GuiButtonSidebar(int x, int y, SidebarButton b) {
            this.buttonX = x;
            this.buttonY = y;
            this.button = b;
        }
    }
}

