/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import forestry.api.recipes.IStillRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.recipes.nei.NEIUtils;
import forestry.core.recipes.nei.PositionedFluidTank;
import forestry.core.recipes.nei.RecipeHandlerBase;
import forestry.factory.gui.GuiStill;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class NEIHandlerStill
extends RecipeHandlerBase {
    @Override
    public String getRecipeID() {
        return "forestry.still";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.for.factory.6.name");
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/still.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(76, 27, 14, 12);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiStill.class;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)25, (int)0, (int)30, (int)11, (int)116, (int)65);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(79, 6, 176, 74, 4, 18, 80, 11);
        GuiDraw.drawTexturedModalRect((int)77, (int)46, (int)176, (int)60, (int)14, (int)14);
    }

    @Override
    public void loadAllRecipes() {
        for (IStillRecipe recipe : RecipeManagers.stillManager.recipes()) {
            this.arecipes.add(new CachedStillRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (IStillRecipe recipe : RecipeManagers.stillManager.recipes()) {
            if (!NEIUtils.areFluidsSameType(recipe.getOutput(), result)) continue;
            this.arecipes.add(new CachedStillRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingred) {
        for (IStillRecipe recipe : RecipeManagers.stillManager.recipes()) {
            if (!NEIUtils.areFluidsSameType(recipe.getInput(), ingred)) continue;
            this.arecipes.add(new CachedStillRecipe(recipe));
        }
    }

    public class CachedStillRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedFluidTank> tanks = new ArrayList<PositionedFluidTank>();

        public CachedStillRecipe(IStillRecipe recipe) {
            if (recipe.getInput() != null) {
                this.tanks.add(new PositionedFluidTank(recipe.getInput(), 10000, new Rectangle(30, 4, 16, 58), NEIHandlerStill.this.getGuiTexture(), new Point(176, 0)));
            }
            if (recipe.getOutput() != null) {
                this.tanks.add(new PositionedFluidTank(recipe.getOutput(), 10000, new Rectangle(120, 4, 16, 58), NEIHandlerStill.this.getGuiTexture(), new Point(176, 0)));
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public List<PositionedFluidTank> getFluidTanks() {
            return this.tanks;
        }
    }
}

