/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.lumbermill;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import binnie.extratrees.machines.lumbermill.LogSlotValidator;
import binnie.extratrees.machines.lumbermill.LumbermillComponentLogic;

public class LumbermillPackage
extends ExtraTreeMachine.PackageExtraTreeMachine
implements IMachineInformation {
    public LumbermillPackage() {
        super("lumbermill", "extratrees/sawmill_", true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Lumbermill);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot woodSlot = inventory.addSlot(0, "input");
        woodSlot.setValidator(new LogSlotValidator());
        woodSlot.forbidExtraction();
        InventorySlot planksSlot = inventory.addSlot(1, "output");
        planksSlot.setReadOnly();
        InventorySlot barkSlot = inventory.addSlot(2, "byproduct");
        barkSlot.setReadOnly();
        InventorySlot sawdustSlot = inventory.addSlot(3, "byproduct");
        sawdustSlot.setReadOnly();
        ComponentTankContainer tanks = new ComponentTankContainer(machine);
        TankSlot tankSlot = tanks.addTank(0, "input", 10000);
        tankSlot.setValidator(new TankValidator.Basic("water"));
        new ComponentPowerReceptor(machine);
        new LumbermillComponentLogic(machine);
    }
}

