/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.client.gui;

import com.github.lunatrius.core.client.gui.FontRendererHelper;
import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.client.gui.Info;
import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.value.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import org.jetbrains.annotations.NotNull;

public class InfoText
extends Info {
    private static final Pattern ICON_PATTERN = Pattern.compile("\\{ICON\\|( *)\\}", 2);
    private static final Matcher ICON_MATCHER = ICON_PATTERN.matcher("");
    private final Map<String, Info> attachedValues = new HashMap<String, Info>();
    private String text;
    private final List<Value> values;
    private final Alignment alignment;
    private final int index;
    private boolean needsUpdate = true;

    public InfoText(int index, Alignment alignment, List<Value> values) {
        super(0, 0);
        this.values = values;
        this.alignment = alignment;
        this.index = index;
        for (Value value : values) {
            value.setParent(this);
        }
    }

    public void update() {
        StringBuilder builder = new StringBuilder();
        for (Value value : this.values) {
            builder.append(this.getValue(value));
        }
        this.text = builder.toString();
        this.updatePosition();
    }

    @Override
    public void drawInfo() {
        if (this.needsUpdate) {
            this.updateChildren();
            this.needsUpdate = false;
        }
        FontRendererHelper.drawLeftAlignedString((FontRenderer)fontRenderer, (String)this.text, (int)this.getX(), (int)this.getY(), (int)0xFFFFFF);
        for (Info child : this.attachedValues.values()) {
            child.offsetX = this.x;
            child.offsetY = this.y;
            child.draw();
        }
    }

    private void updateChildren() {
        if (this.attachedValues.isEmpty()) {
            return;
        }
        ICON_MATCHER.reset(this.text);
        for (Info child : this.attachedValues.values()) {
            if (!ICON_MATCHER.find()) break;
            int newX = fontRenderer.func_78256_a(this.text.substring(0, ICON_MATCHER.start()));
            if (newX == 0) {
                this.offsetX = child.getWidth();
            }
            child.x = newX;
            this.text = this.text.replaceFirst(Pattern.quote(ICON_MATCHER.group(0)), ICON_MATCHER.group(1));
            ICON_MATCHER.reset(this.text);
        }
        this.updatePosition();
    }

    private void updatePosition() {
        int scaledWidth = InGameInfoCore.INSTANCE.scaledWidth;
        int scaledHeight = InGameInfoCore.INSTANCE.scaledHeight;
        this.x = this.alignment.getX(scaledWidth, this.getWidth());
        this.y = this.alignment.getY(scaledHeight, this.getHeight()) + this.getHeight();
    }

    @Nullable
    public Info getAttachedValue(String tag) {
        return this.attachedValues.get(tag);
    }

    public void removeAttachedValue(String tag) {
        this.attachedValues.remove(tag);
    }

    public void attachValue(@NotNull String tag, @NotNull Info value) {
        Info old = this.attachedValues.get(tag);
        if (old != null) {
            value.y = old.y;
            value.x = old.x;
        } else {
            this.needsUpdate = true;
        }
        if (value.x == 0) {
            this.offsetX = value.getWidth();
        }
        this.attachedValues.put(tag, value);
    }

    @Override
    public int getWidth() {
        return fontRenderer.func_78256_a(this.text);
    }

    @Override
    public int getHeight() {
        return this.index * (InfoText.fontRenderer.field_78288_b + 1);
    }

    private String getValue(Value value) {
        try {
            if (value.isValidSize()) {
                return value.getReplacedValue();
            }
        }
        catch (Exception e) {
            Reference.logger.debug("Failed to get value!", (Throwable)e);
            return "null";
        }
        return "";
    }

    @Override
    public String toString() {
        return String.format("InfoText{text: %s, x: %d, y: %d, offsetX: %d, offsetY: %d, children: %s}", this.text, this.x, this.y, this.offsetX, this.offsetY, this.children);
    }
}

