/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.retrofuturabootstrap.api;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

public interface FastClassAccessor {
    public boolean isPublic();

    public boolean isFinal();

    public boolean isInterface();

    public boolean isAbstract();

    public boolean isSynthetic();

    public boolean isAnnotation();

    public boolean isEnum();

    public boolean isModule();

    @NotNull
    public String binaryThisName();

    @Nullable
    public String binarySuperName();

    @NotNull
    public @NotNull List<@NotNull String> binaryInterfaceNames();

    public static OfLoaded ofLoaded(Class<?> loadedClass) {
        return new OfLoaded(loadedClass);
    }

    public static OfAsmNode ofAsmNode(ClassNode handle) {
        return new OfAsmNode(handle);
    }

    public static final class OfLoaded
    implements FastClassAccessor {
        public final Class<?> handle;
        private @Nullable List<@NotNull String> interfacesCache = null;

        private OfLoaded(Class<?> handle) {
            this.handle = handle;
        }

        @Override
        public boolean isPublic() {
            return Modifier.isPublic(this.handle.getModifiers());
        }

        @Override
        public boolean isFinal() {
            return Modifier.isFinal(this.handle.getModifiers());
        }

        @Override
        public boolean isInterface() {
            return Modifier.isInterface(this.handle.getModifiers());
        }

        @Override
        public boolean isAbstract() {
            return Modifier.isAbstract(this.handle.getModifiers());
        }

        @Override
        public boolean isSynthetic() {
            return this.handle.isSynthetic();
        }

        @Override
        public boolean isAnnotation() {
            return this.handle.isAnnotation();
        }

        @Override
        public boolean isEnum() {
            return this.handle.isEnum();
        }

        @Override
        public boolean isModule() {
            return false;
        }

        @Override
        @NotNull
        public String binaryThisName() {
            return this.handle.getName().replace('.', '/');
        }

        @Override
        @Nullable
        public String binarySuperName() {
            Class<?> superclass = this.handle.getSuperclass();
            return superclass == null ? null : superclass.getName().replace('.', '/');
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull String> binaryInterfaceNames() {
            if (this.interfacesCache != null) {
                return this.interfacesCache;
            }
            Class<?>[] interfaces = this.handle.getInterfaces();
            ArrayList<String> binaryInterfaceNames = new ArrayList<String>(interfaces.length);
            for (Class<?> iface : interfaces) {
                binaryInterfaceNames.add(iface.getName().replace('.', '/'));
            }
            this.interfacesCache = Collections.unmodifiableList(binaryInterfaceNames);
            return this.interfacesCache;
        }
    }

    public static final class OfAsmNode
    implements FastClassAccessor {
        public final ClassNode handle;

        public OfAsmNode(ClassNode handle) {
            this.handle = handle;
        }

        @Override
        public boolean isPublic() {
            return (this.handle.access & 1) != 0;
        }

        @Override
        public boolean isFinal() {
            return (this.handle.access & 0x10) != 0;
        }

        @Override
        public boolean isInterface() {
            return (this.handle.access & 0x200) != 0;
        }

        @Override
        public boolean isAbstract() {
            return (this.handle.access & 0x400) != 0;
        }

        @Override
        public boolean isSynthetic() {
            return (this.handle.access & 0x1000) != 0;
        }

        @Override
        public boolean isAnnotation() {
            return (this.handle.access & 0x2000) != 0;
        }

        @Override
        public boolean isEnum() {
            return (this.handle.access & 0x4000) != 0;
        }

        @Override
        public boolean isModule() {
            return (this.handle.access & 0x8000) != 0;
        }

        @Override
        @NotNull
        public String binaryThisName() {
            return this.handle.name;
        }

        @Override
        @Nullable
        public String binarySuperName() {
            return this.handle.superName;
        }

        @Override
        @NotNull
        public @NotNull List<@NotNull String> binaryInterfaceNames() {
            return this.handle.interfaces == null ? Collections.emptyList() : Collections.unmodifiableList(this.handle.interfaces);
        }
    }
}

